import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [support](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupport.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Support extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to add one or more attachments to an AWS Support case
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_AddAttachmentsToSet.html
     */
    toAddAttachmentsToSet(): this;
    /**
     * Grants permission to add a customer communication to an AWS Support case
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_AddCommunicationToCase.html
     */
    toAddCommunicationToCase(): this;
    /**
     * Grants permission to creates a new AWS Support case
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_CreateCase.html
     */
    toCreateCase(): this;
    /**
     * Grants permission to describe attachment detail
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeAttachment.html
     */
    toDescribeAttachment(): this;
    /**
     * Grants permission to allow secondary services to read AWS Support case attributes.This is an internally managed function
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/accessing-support.html
     */
    toDescribeCaseAttributes(): this;
    /**
     * Grants permission to list AWS Support cases that matches the given inputs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeCases.html
     */
    toDescribeCases(): this;
    /**
     * Grants permission to get a single communication and attachments for a single AWS Support case
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/accessing-support.html
     */
    toDescribeCommunication(): this;
    /**
     * Grants permission to list the communications and attachments for one or more AWS Support cases
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeCommunications.html
     */
    toDescribeCommunications(): this;
    /**
     * Grants permission to describes the available options for creating a support case
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeCreateCaseOptions.html
     */
    toDescribeCreateCaseOptions(): this;
    /**
     * Grants permission to return issue types for AWS Support cases
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/accessing-support.html
     */
    toDescribeIssueTypes(): this;
    /**
     * Grants permission to list AWS services and categories that applies to each service
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeServices.html
     */
    toDescribeServices(): this;
    /**
     * Grants permission to list severity levels that can be assigned to an AWS Support case
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeSeverityLevels.html
     */
    toDescribeSeverityLevels(): this;
    /**
     * Grants permission to return the support level for an AWS Account identifier
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/accessing-support.html
     */
    toDescribeSupportLevel(): this;
    /**
     * Grants permission to describes the available support languages for a given category code, service code and issue type
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeSupportedLanguages.html
     */
    toDescribeSupportedLanguages(): this;
    /**
     * Grants permission to get the status of a Trusted Advisor refresh check based on a list of check identifiers
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeTrustedAdvisorCheckRefreshStatuses.html
     */
    toDescribeTrustedAdvisorCheckRefreshStatuses(): this;
    /**
     * Grants permission to get the results of the Trusted Advisor check that has the specified check identifier
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeTrustedAdvisorCheckResult.html
     */
    toDescribeTrustedAdvisorCheckResult(): this;
    /**
     * Grants permission to get the summaries of the results of the Trusted Advisor checks that have the specified check identifiers
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeTrustedAdvisorCheckSummaries.html
     */
    toDescribeTrustedAdvisorCheckSummaries(): this;
    /**
     * Grants permission to get a list of all available Trusted Advisor checks, including name, identifier, category and description
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeTrustedAdvisorChecks.html
     */
    toDescribeTrustedAdvisorChecks(): this;
    /**
     * Grants permission to retrieve personalized troubleshooting assistance for account and technical issues for a specific interaction
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_GetInteraction.html
     */
    toGetInteraction(): this;
    /**
     * Grants permission to initiate a call on AWS Support Center. This is an internally managed function
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/accessing-support.html
     */
    toInitiateCallForCase(): this;
    /**
     * Grants permission to initiate a chat on AWS Support Center.This is an internally managed function
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/accessing-support.html
     */
    toInitiateChatForCase(): this;
    /**
     * Grants permission to allow secondary services to attach attributes to AWS Support cases. This is an internally managed function
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/accessing-support.html
     */
    toPutCaseAttributes(): this;
    /**
     * Grants permission to rate an AWS Support case communication
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/accessing-support.html
     */
    toRateCaseCommunication(): this;
    /**
     * Grants permission to requests a refresh of the Trusted Advisor check that has the specified check identifier
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_RefreshTrustedAdvisorCheck.html
     */
    toRefreshTrustedAdvisorCheck(): this;
    /**
     * Grants permission to resolve an AWS Support case
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_ResolveCase.html
     */
    toResolveCase(): this;
    /**
     * Grants permission to return a list of AWS Support cases that matches the given inputs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/accessing-support.html
     */
    toSearchForCases(): this;
    /**
     * Grants permission to start a specific interaction to receive personalized troubleshooting assistance for account and technical issues
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_StartInteraction.html
     */
    toStartInteraction(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Statement provider for service [support](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupport.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
