"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Support = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [support](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupport.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Support extends shared_1.PolicyStatement {
    /**
     * Grants permission to add one or more attachments to an AWS Support case
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_AddAttachmentsToSet.html
     */
    toAddAttachmentsToSet() {
        return this.to('AddAttachmentsToSet');
    }
    /**
     * Grants permission to add a customer communication to an AWS Support case
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_AddCommunicationToCase.html
     */
    toAddCommunicationToCase() {
        return this.to('AddCommunicationToCase');
    }
    /**
     * Grants permission to creates a new AWS Support case
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_CreateCase.html
     */
    toCreateCase() {
        return this.to('CreateCase');
    }
    /**
     * Grants permission to describe attachment detail
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeAttachment.html
     */
    toDescribeAttachment() {
        return this.to('DescribeAttachment');
    }
    /**
     * Grants permission to allow secondary services to read AWS Support case attributes.This is an internally managed function
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/accessing-support.html
     */
    toDescribeCaseAttributes() {
        return this.to('DescribeCaseAttributes');
    }
    /**
     * Grants permission to list AWS Support cases that matches the given inputs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeCases.html
     */
    toDescribeCases() {
        return this.to('DescribeCases');
    }
    /**
     * Grants permission to get a single communication and attachments for a single AWS Support case
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/accessing-support.html
     */
    toDescribeCommunication() {
        return this.to('DescribeCommunication');
    }
    /**
     * Grants permission to list the communications and attachments for one or more AWS Support cases
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeCommunications.html
     */
    toDescribeCommunications() {
        return this.to('DescribeCommunications');
    }
    /**
     * Grants permission to describes the available options for creating a support case
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeCreateCaseOptions.html
     */
    toDescribeCreateCaseOptions() {
        return this.to('DescribeCreateCaseOptions');
    }
    /**
     * Grants permission to return issue types for AWS Support cases
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/accessing-support.html
     */
    toDescribeIssueTypes() {
        return this.to('DescribeIssueTypes');
    }
    /**
     * Grants permission to list AWS services and categories that applies to each service
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeServices.html
     */
    toDescribeServices() {
        return this.to('DescribeServices');
    }
    /**
     * Grants permission to list severity levels that can be assigned to an AWS Support case
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeSeverityLevels.html
     */
    toDescribeSeverityLevels() {
        return this.to('DescribeSeverityLevels');
    }
    /**
     * Grants permission to return the support level for an AWS Account identifier
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/accessing-support.html
     */
    toDescribeSupportLevel() {
        return this.to('DescribeSupportLevel');
    }
    /**
     * Grants permission to describes the available support languages for a given category code, service code and issue type
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeSupportedLanguages.html
     */
    toDescribeSupportedLanguages() {
        return this.to('DescribeSupportedLanguages');
    }
    /**
     * Grants permission to get the status of a Trusted Advisor refresh check based on a list of check identifiers
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeTrustedAdvisorCheckRefreshStatuses.html
     */
    toDescribeTrustedAdvisorCheckRefreshStatuses() {
        return this.to('DescribeTrustedAdvisorCheckRefreshStatuses');
    }
    /**
     * Grants permission to get the results of the Trusted Advisor check that has the specified check identifier
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeTrustedAdvisorCheckResult.html
     */
    toDescribeTrustedAdvisorCheckResult() {
        return this.to('DescribeTrustedAdvisorCheckResult');
    }
    /**
     * Grants permission to get the summaries of the results of the Trusted Advisor checks that have the specified check identifiers
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeTrustedAdvisorCheckSummaries.html
     */
    toDescribeTrustedAdvisorCheckSummaries() {
        return this.to('DescribeTrustedAdvisorCheckSummaries');
    }
    /**
     * Grants permission to get a list of all available Trusted Advisor checks, including name, identifier, category and description
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeTrustedAdvisorChecks.html
     */
    toDescribeTrustedAdvisorChecks() {
        return this.to('DescribeTrustedAdvisorChecks');
    }
    /**
     * Grants permission to retrieve personalized troubleshooting assistance for account and technical issues for a specific interaction
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_GetInteraction.html
     */
    toGetInteraction() {
        return this.to('GetInteraction');
    }
    /**
     * Grants permission to initiate a call on AWS Support Center. This is an internally managed function
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/accessing-support.html
     */
    toInitiateCallForCase() {
        return this.to('InitiateCallForCase');
    }
    /**
     * Grants permission to initiate a chat on AWS Support Center.This is an internally managed function
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/accessing-support.html
     */
    toInitiateChatForCase() {
        return this.to('InitiateChatForCase');
    }
    /**
     * Grants permission to allow secondary services to attach attributes to AWS Support cases. This is an internally managed function
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/accessing-support.html
     */
    toPutCaseAttributes() {
        return this.to('PutCaseAttributes');
    }
    /**
     * Grants permission to rate an AWS Support case communication
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/accessing-support.html
     */
    toRateCaseCommunication() {
        return this.to('RateCaseCommunication');
    }
    /**
     * Grants permission to requests a refresh of the Trusted Advisor check that has the specified check identifier
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_RefreshTrustedAdvisorCheck.html
     */
    toRefreshTrustedAdvisorCheck() {
        return this.to('RefreshTrustedAdvisorCheck');
    }
    /**
     * Grants permission to resolve an AWS Support case
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_ResolveCase.html
     */
    toResolveCase() {
        return this.to('ResolveCase');
    }
    /**
     * Grants permission to return a list of AWS Support cases that matches the given inputs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/accessing-support.html
     */
    toSearchForCases() {
        return this.to('SearchForCases');
    }
    /**
     * Grants permission to start a specific interaction to receive personalized troubleshooting assistance for account and technical issues
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_StartInteraction.html
     */
    toStartInteraction() {
        return this.to('StartInteraction');
    }
    /**
     * Statement provider for service [support](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupport.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'support';
        this.accessLevelList = {
            Write: [
                'AddAttachmentsToSet',
                'AddCommunicationToCase',
                'CreateCase',
                'InitiateCallForCase',
                'InitiateChatForCase',
                'PutCaseAttributes',
                'RateCaseCommunication',
                'RefreshTrustedAdvisorCheck',
                'ResolveCase',
                'StartInteraction'
            ],
            Read: [
                'DescribeAttachment',
                'DescribeCaseAttributes',
                'DescribeCases',
                'DescribeCommunication',
                'DescribeCommunications',
                'DescribeCreateCaseOptions',
                'DescribeIssueTypes',
                'DescribeServices',
                'DescribeSeverityLevels',
                'DescribeSupportLevel',
                'DescribeSupportedLanguages',
                'DescribeTrustedAdvisorCheckRefreshStatuses',
                'DescribeTrustedAdvisorCheckResult',
                'DescribeTrustedAdvisorCheckSummaries',
                'DescribeTrustedAdvisorChecks',
                'GetInteraction',
                'SearchForCases'
            ]
        };
    }
}
exports.Support = Support;
//# sourceMappingURL=data:application/json;base64,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