"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Supportapp = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [supportapp](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupportappinslack.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Supportapp extends shared_1.PolicyStatement {
    /**
     * Grants permission to create a Slack channel configuration for your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/supportapp/latest/APIReference/API_CreateSlackChannelConfiguration.html
     */
    toCreateSlackChannelConfiguration() {
        return this.to('CreateSlackChannelConfiguration');
    }
    /**
     * Grants permission to delete an alias from your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/supportapp/latest/APIReference/API_DeleteAccountAlias.html
     */
    toDeleteAccountAlias() {
        return this.to('DeleteAccountAlias');
    }
    /**
     * Grants permission to delete a Slack channel configuration from your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/supportapp/latest/APIReference/API_DeleteSlackChannelConfiguration.html
     */
    toDeleteSlackChannelConfiguration() {
        return this.to('DeleteSlackChannelConfiguration');
    }
    /**
     * Grants permission to delete a Slack workspace configuration from your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/supportapp/latest/APIReference/API_DeleteSlackWorkspaceConfiguration.html
     */
    toDeleteSlackWorkspaceConfiguration() {
        return this.to('DeleteSlackWorkspaceConfiguration');
    }
    /**
     * Grants permission to list all public Slack channels in a workspace that have invited the AWS Support App
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/slack-authorization-permissions.html
     */
    toDescribeSlackChannels() {
        return this.to('DescribeSlackChannels');
    }
    /**
     * Grants permission to get the alias for your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/supportapp/latest/APIReference/API_GetAccountAlias.html
     */
    toGetAccountAlias() {
        return this.to('GetAccountAlias');
    }
    /**
     * Grants permission to get parameters for the Slack OAuth code, which the AWS Support App uses to authorize the workspace
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/slack-authorization-permissions.html
     */
    toGetSlackOauthParameters() {
        return this.to('GetSlackOauthParameters');
    }
    /**
     * Grants permission to list all Slack channel configurations for your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/supportapp/latest/APIReference/API_ListSlackChannelConfigurations.html
     */
    toListSlackChannelConfigurations() {
        return this.to('ListSlackChannelConfigurations');
    }
    /**
     * Grants permission to list all Slack workspace configurations for your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/supportapp/latest/APIReference/API_ListSlackWorkspaceConfigurations.html
     */
    toListSlackWorkspaceConfigurations() {
        return this.to('ListSlackWorkspaceConfigurations');
    }
    /**
     * Grants permission to create or update an alias for your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/supportapp/latest/APIReference/API_PutAccountAlias.html
     */
    toPutAccountAlias() {
        return this.to('PutAccountAlias');
    }
    /**
     * Grants permission to redeem the Slack OAuth code, which the AWS Support App uses to authorize the workspace
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/slack-authorization-permissions.html
     */
    toRedeemSlackOauthCode() {
        return this.to('RedeemSlackOauthCode');
    }
    /**
     * Grants permission to register a Slack workspace for an AWS account that is part of an organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/supportapp/latest/APIReference/API_RegisterSlackWorkspaceForOrganization.html
     */
    toRegisterSlackWorkspaceForOrganization() {
        return this.to('RegisterSlackWorkspaceForOrganization');
    }
    /**
     * Grants permission to update a Slack channel configuration for your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/supportapp/latest/APIReference/API_UpdateSlackChannelConfiguration.html
     */
    toUpdateSlackChannelConfiguration() {
        return this.to('UpdateSlackChannelConfiguration');
    }
    /**
     * Statement provider for service [supportapp](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupportappinslack.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'supportapp';
        this.accessLevelList = {
            Write: [
                'CreateSlackChannelConfiguration',
                'DeleteAccountAlias',
                'DeleteSlackChannelConfiguration',
                'DeleteSlackWorkspaceConfiguration',
                'PutAccountAlias',
                'RedeemSlackOauthCode',
                'RegisterSlackWorkspaceForOrganization',
                'UpdateSlackChannelConfiguration'
            ],
            Read: [
                'DescribeSlackChannels',
                'GetAccountAlias',
                'GetSlackOauthParameters',
                'ListSlackChannelConfigurations',
                'ListSlackWorkspaceConfigurations'
            ]
        };
    }
}
exports.Supportapp = Supportapp;
//# sourceMappingURL=data:application/json;base64,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