import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [supportrecommendations](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupportrecommendations.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Supportrecommendations extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to the GetSupportTroubleshootingResponse API which lists troubleshooting responses for users' issues
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-support-recommendations.html/
     */
    toGetSupportTroubleshootingResponse(): this;
    /**
     * Grants permission to the StartSupportTroubleshooting API which starts troubleshooting for users' issues
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-support-recommendations.html/
     */
    toStartSupportTroubleshooting(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Statement provider for service [supportrecommendations](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupportrecommendations.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
