import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [tax](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awstaxsettings.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Tax extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to batch delete tax registration data
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html
     */
    toBatchDeleteTaxRegistration(): this;
    /**
     * Grants permission to batch update tax registrations
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html
     */
    toBatchPutTaxRegistration(): this;
    /**
     * Grants permission to delete supplemental tax registration data
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html
     */
    toDeleteSupplementalTaxRegistration(): this;
    /**
     * Grants permission to delete tax registration data
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html
     */
    toDeleteTaxRegistration(): this;
    /**
     * Grants permission to view tax exemptions data
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html
     */
    toGetExemptions(): this;
    /**
     * Grants permission to view/download tax documents/forms
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html
     */
    toGetTaxInfoReportingDocument(): this;
    /**
     * Grants permission to view tax inheritance status
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html
     */
    toGetTaxInheritance(): this;
    /**
     * Grants permission to retrieve tax interview data
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html
     */
    toGetTaxInterview(): this;
    /**
     * Grants permission to view tax registrations data
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html
     */
    toGetTaxRegistration(): this;
    /**
     * Grants permission to download tax registration documents
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html
     */
    toGetTaxRegistrationDocument(): this;
    /**
     * Grants permission to view supplemental tax registrations
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html
     */
    toListSupplementalTaxRegistrations(): this;
    /**
     * Grants permission to view tax registrations
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html
     */
    toListTaxRegistrations(): this;
    /**
     * Grants permission to update supplemental tax registrations data
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html
     */
    toPutSupplementalTaxRegistration(): this;
    /**
     * Grants permission to set tax inheritance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html
     */
    toPutTaxInheritance(): this;
    /**
     * Grants permission to update tax interview data
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html
     */
    toPutTaxInterview(): this;
    /**
     * Grants permission to update tax registrations data
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html
     */
    toPutTaxRegistration(): this;
    /**
     * Grants permission to update tax exemptions data
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html
     */
    toUpdateExemptions(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Statement provider for service [tax](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awstaxsettings.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
