import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [timestream-influxdb](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazontimestreaminfluxdb.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class TimestreamInfluxdb extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to create a new Timestream InfluxDB Cluster
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - timestream-influxdb:CreateDbInstance
     *
     * https://docs.aws.amazon.com/ts-influxdb/latest/ts-influxdb-api/API_CreateDbCluster.html
     */
    toCreateDbCluster(): this;
    /**
     * Grants permission to create a new Timestream InfluxDB instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/ts-influxdb/latest/ts-influxdb-api/API_CreateDbInstance.html
     */
    toCreateDbInstance(): this;
    /**
     * Grants permission to create a new Timestream InfluxDB parameter group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/ts-influxdb/latest/ts-influxdb-api/API_CreateDbParameterGroup.html
     */
    toCreateDbParameterGroup(): this;
    /**
     * Grants permission to delete a Timestream InfluxDB Cluster
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - timestream-influxdb:DeleteDbInstance
     *
     * https://docs.aws.amazon.com/ts-influxdb/latest/ts-influxdb-api/API_DeleteDbCluster.html
     */
    toDeleteDbCluster(): this;
    /**
     * Grants permission to delete a Timestream InfluxDB instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ts-influxdb/latest/ts-influxdb-api/API_DeleteDbInstance.html
     */
    toDeleteDbInstance(): this;
    /**
     * Grants permission to get information about a Timestream InfluxDB Cluster
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ts-influxdb/latest/ts-influxdb-api/API_GetDbCluster.html
     */
    toGetDbCluster(): this;
    /**
     * Grants permission to get information about a Timestream InfluxDB instance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ts-influxdb/latest/ts-influxdb-api/API_GetDbInstance.html
     */
    toGetDbInstance(): this;
    /**
     * Grants permission to get information about a Timestream InfluxDB parameter group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ts-influxdb/latest/ts-influxdb-api/API_GetDbParameterGroup.html
     */
    toGetDbParameterGroup(): this;
    /**
     * Grants permission to list information about all Timestream InfluxDB clusters in the account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/ts-influxdb/latest/ts-influxdb-api/API_ListDbClusters.html
     */
    toListDbClusters(): this;
    /**
     * Grants permission to list information about all Timestream InfluxDB instances in the account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/ts-influxdb/latest/ts-influxdb-api/API_ListDbInstances.html
     */
    toListDbInstances(): this;
    /**
     * Grants permission to list information about all Timestream InfluxDB Instances belonging to a cluster
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ts-influxdb/latest/ts-influxdb-api/API_ListDbInstancesForCluster.html
     */
    toListDbInstancesForCluster(): this;
    /**
     * Grants permission to list information about all Timestream InfluxDB parameter groups
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/ts-influxdb/latest/ts-influxdb-api/API_ListDbParameterGroups.html
     */
    toListDbParameterGroups(): this;
    /**
     * Grants permission to list tags for a Timestream InfluxDB resource
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/ts-influxdb/latest/ts-influxdb-api/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to tag a Timestream InfluxDB resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/ts-influxdb/latest/ts-influxdb-api/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to untag a Timestream InfluxDB resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/ts-influxdb/latest/ts-influxdb-api/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update a Timestream InfluxDB Cluster
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - timestream-influxdb:UpdateDbInstance
     *
     * https://docs.aws.amazon.com/ts-influxdb/latest/ts-influxdb-api/API_UpdateDbCluster.html
     */
    toUpdateDbCluster(): this;
    /**
     * Grants permission to update a Timestream InfluxDB instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ts-influxdb/latest/ts-influxdb-api/API_UpdateDbInstance.html
     */
    toUpdateDbInstance(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type db-cluster to the statement
     *
     * https://docs.aws.amazon.com/ts-influxdb/latest/ts-influxdb-api/API_DbClusterSummary.html
     *
     * @param dbClusterId - Identifier for the dbClusterId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDbCluster(dbClusterId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type db-instance to the statement
     *
     * https://docs.aws.amazon.com/ts-influxdb/latest/ts-influxdb-api/API_DbInstanceSummary.html
     *
     * @param dbInstanceIdentifier - Identifier for the dbInstanceIdentifier.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDbInstance(dbInstanceIdentifier: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type db-parameter-group to the statement
     *
     * https://docs.aws.amazon.com/ts-influxdb/latest/ts-influxdb-api/API_DbParameterGroupSummary.html
     *
     * @param dbParameterGroupIdentifier - Identifier for the dbParameterGroupIdentifier.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDbParameterGroup(dbParameterGroupIdentifier: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by a tag key and value pair that is allowed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateDbCluster()
     * - .toCreateDbInstance()
     * - .toCreateDbParameterGroup()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by a tag key and value pair of a resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to actions:
     * - .toListTagsForResource()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * Applies to resource types:
     * - db-cluster
     * - db-instance
     * - db-parameter-group
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by a list of tag keys that are allowed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateDbCluster()
     * - .toCreateDbInstance()
     * - .toCreateDbParameterGroup()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [timestream-influxdb](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazontimestreaminfluxdb.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
