/**
 * Fetches a list of executions for a given state machine.
 *
 * @param {string} stateMachineArn - The ARN of the state machine.
 * @return {Promise<Array>} - A promise that resolves to an array of execution objects.
 * @throws {Error} - If an error occurs while fetching the list of executions.
 * @example
 * const _stateMachineArn = 'arn:aws:states:{{Region}}:{{AccountID}}:stateMachine:MyStateMachine-oiye9p0di';
 * const _executionName = '3db0f8ae-fab8-4c77-bb61-3f3b48ab39e1';
 * listExecutions(_stateMachineArn).then(executions => {
 *   const filteredExecutions = executions!.filter(execution => execution.name!.includes(_executionName + '-'));
 *   console.log(filteredExecutions);
 * }).catch(error => {
 *   console.log(error);
 * });
 */
export declare const listExecutions: (stateMachineArn: string) => Promise<import("@aws-sdk/client-sfn").ExecutionListItem[] | undefined>;
/**
 * Retrieves the execution history of a specific execution using the given execution ARN.
 *
 * @param {string} executionArn - The ARN of the execution.
 *
 * @returns {Promise<string>} - The ID of the AMI associated with the execution if it succeeded, otherwise an empty string.
 */
export declare function getExecutionHistory(executionArn: string): Promise<string>;
