import { SENSITIVE_STRING } from "@smithy/smithy-client";
export const CapacityReservationBillingRequestStatus = {
    accepted: "accepted",
    cancelled: "cancelled",
    expired: "expired",
    pending: "pending",
    rejected: "rejected",
    revoked: "revoked",
};
export const ClientVpnConnectionStatusCode = {
    active: "active",
    failed_to_terminate: "failed-to-terminate",
    terminated: "terminated",
    terminating: "terminating",
};
export const AssociatedNetworkType = {
    vpc: "vpc",
};
export const ClientVpnEndpointAttributeStatusCode = {
    applied: "applied",
    applying: "applying",
};
export const VpnProtocol = {
    openvpn: "openvpn",
};
export const ConversionTaskState = {
    active: "active",
    cancelled: "cancelled",
    cancelling: "cancelling",
    completed: "completed",
};
export const ReportState = {
    cancelled: "cancelled",
    complete: "complete",
    error: "error",
    running: "running",
};
export const ElasticGpuStatus = {
    Impaired: "IMPAIRED",
    Ok: "OK",
};
export const ElasticGpuState = {
    Attached: "ATTACHED",
};
export const FastLaunchResourceType = {
    SNAPSHOT: "snapshot",
};
export const FastLaunchStateCode = {
    disabling: "disabling",
    disabling_failed: "disabling-failed",
    enabled: "enabled",
    enabled_failed: "enabled-failed",
    enabling: "enabling",
    enabling_failed: "enabling-failed",
};
export const FastSnapshotRestoreStateCode = {
    disabled: "disabled",
    disabling: "disabling",
    enabled: "enabled",
    enabling: "enabling",
    optimizing: "optimizing",
};
export const FleetEventType = {
    FLEET_CHANGE: "fleet-change",
    INSTANCE_CHANGE: "instance-change",
    SERVICE_ERROR: "service-error",
};
export const FleetActivityStatus = {
    ERROR: "error",
    FULFILLED: "fulfilled",
    PENDING_FULFILLMENT: "pending_fulfillment",
    PENDING_TERMINATION: "pending_termination",
};
export const FpgaImageAttributeName = {
    description: "description",
    loadPermission: "loadPermission",
    name: "name",
    productCodes: "productCodes",
};
export const PermissionGroup = {
    all: "all",
};
export const ProductCodeValues = {
    devpay: "devpay",
    marketplace: "marketplace",
};
export const FpgaImageStateCode = {
    available: "available",
    failed: "failed",
    pending: "pending",
    unavailable: "unavailable",
};
export const PaymentOption = {
    ALL_UPFRONT: "AllUpfront",
    NO_UPFRONT: "NoUpfront",
    PARTIAL_UPFRONT: "PartialUpfront",
};
export const ReservationState = {
    ACTIVE: "active",
    PAYMENT_FAILED: "payment-failed",
    PAYMENT_PENDING: "payment-pending",
    RETIRED: "retired",
};
export const ImageAttributeName = {
    blockDeviceMapping: "blockDeviceMapping",
    bootMode: "bootMode",
    deregistrationProtection: "deregistrationProtection",
    description: "description",
    imdsSupport: "imdsSupport",
    kernel: "kernel",
    lastLaunchedTime: "lastLaunchedTime",
    launchPermission: "launchPermission",
    productCodes: "productCodes",
    ramdisk: "ramdisk",
    sriovNetSupport: "sriovNetSupport",
    tpmSupport: "tpmSupport",
    uefiData: "uefiData",
};
export const ImageReferenceResourceType = {
    EC2_INSTANCE: "ec2:Instance",
    EC2_LAUNCH_TEMPLATE: "ec2:LaunchTemplate",
    IMAGE_BUILDER_CONTAINER_RECIPE: "imagebuilder:ContainerRecipe",
    IMAGE_BUILDER_IMAGE_RECIPE: "imagebuilder:ImageRecipe",
    SSM_PARAMETER: "ssm:Parameter",
};
export const ImageReferenceOptionName = {
    STATE_NAME: "state-name",
    VERSION_DEPTH: "version-depth",
};
export const ArchitectureValues = {
    arm64: "arm64",
    arm64_mac: "arm64_mac",
    i386: "i386",
    x86_64: "x86_64",
    x86_64_mac: "x86_64_mac",
};
export const BootModeValues = {
    legacy_bios: "legacy-bios",
    uefi: "uefi",
    uefi_preferred: "uefi-preferred",
};
export const HypervisorType = {
    ovm: "ovm",
    xen: "xen",
};
export const ImageTypeValues = {
    kernel: "kernel",
    machine: "machine",
    ramdisk: "ramdisk",
};
export const ImdsSupportValues = {
    v2_0: "v2.0",
};
export const DeviceType = {
    ebs: "ebs",
    instance_store: "instance-store",
};
export const ImageState = {
    available: "available",
    deregistered: "deregistered",
    disabled: "disabled",
    error: "error",
    failed: "failed",
    invalid: "invalid",
    pending: "pending",
    transient: "transient",
};
export const TpmSupportValues = {
    v2_0: "v2.0",
};
export const VirtualizationType = {
    hvm: "hvm",
    paravirtual: "paravirtual",
};
export const InstanceAttributeName = {
    blockDeviceMapping: "blockDeviceMapping",
    disableApiStop: "disableApiStop",
    disableApiTermination: "disableApiTermination",
    ebsOptimized: "ebsOptimized",
    enaSupport: "enaSupport",
    enclaveOptions: "enclaveOptions",
    groupSet: "groupSet",
    instanceInitiatedShutdownBehavior: "instanceInitiatedShutdownBehavior",
    instanceType: "instanceType",
    kernel: "kernel",
    productCodes: "productCodes",
    ramdisk: "ramdisk",
    rootDeviceName: "rootDeviceName",
    sourceDestCheck: "sourceDestCheck",
    sriovNetSupport: "sriovNetSupport",
    userData: "userData",
};
export const InstanceStateName = {
    pending: "pending",
    running: "running",
    shutting_down: "shutting-down",
    stopped: "stopped",
    stopping: "stopping",
    terminated: "terminated",
};
export const InstanceBootModeValues = {
    legacy_bios: "legacy-bios",
    uefi: "uefi",
};
export const InstanceLifecycleType = {
    capacity_block: "capacity-block",
    scheduled: "scheduled",
    spot: "spot",
};
export const InstanceAutoRecoveryState = {
    default: "default",
    disabled: "disabled",
};
export const InstanceRebootMigrationState = {
    default: "default",
    disabled: "disabled",
};
export const InstanceMetadataEndpointState = {
    disabled: "disabled",
    enabled: "enabled",
};
export const InstanceMetadataProtocolState = {
    disabled: "disabled",
    enabled: "enabled",
};
export const HttpTokensState = {
    optional: "optional",
    required: "required",
};
export const InstanceMetadataTagsState = {
    disabled: "disabled",
    enabled: "enabled",
};
export const InstanceMetadataOptionsState = {
    applied: "applied",
    pending: "pending",
};
export const MonitoringState = {
    disabled: "disabled",
    disabling: "disabling",
    enabled: "enabled",
    pending: "pending",
};
export const StatusName = {
    reachability: "reachability",
};
export const StatusType = {
    failed: "failed",
    initializing: "initializing",
    insufficient_data: "insufficient-data",
    passed: "passed",
};
export const SummaryStatus = {
    impaired: "impaired",
    initializing: "initializing",
    insufficient_data: "insufficient-data",
    not_applicable: "not-applicable",
    ok: "ok",
};
export const EventCode = {
    instance_reboot: "instance-reboot",
    instance_retirement: "instance-retirement",
    instance_stop: "instance-stop",
    system_maintenance: "system-maintenance",
    system_reboot: "system-reboot",
};
export const LocationType = {
    availability_zone: "availability-zone",
    availability_zone_id: "availability-zone-id",
    outpost: "outpost",
    region: "region",
};
export const AttachmentLimitType = {
    DEDICATED: "dedicated",
    SHARED: "shared",
};
export const EbsOptimizedSupport = {
    default: "default",
    supported: "supported",
    unsupported: "unsupported",
};
export const EbsEncryptionSupport = {
    supported: "supported",
    unsupported: "unsupported",
};
export const EbsNvmeSupport = {
    REQUIRED: "required",
    SUPPORTED: "supported",
    UNSUPPORTED: "unsupported",
};
export const InstanceTypeHypervisor = {
    NITRO: "nitro",
    XEN: "xen",
};
export const DiskType = {
    hdd: "hdd",
    ssd: "ssd",
};
export const InstanceStorageEncryptionSupport = {
    required: "required",
    unsupported: "unsupported",
};
export const EphemeralNvmeSupport = {
    REQUIRED: "required",
    SUPPORTED: "supported",
    UNSUPPORTED: "unsupported",
};
export const BandwidthWeightingType = {
    DEFAULT: "default",
    EBS_1: "ebs-1",
    VPC_1: "vpc-1",
};
export const EnaSupport = {
    required: "required",
    supported: "supported",
    unsupported: "unsupported",
};
export const FlexibleEnaQueuesSupport = {
    SUPPORTED: "supported",
    UNSUPPORTED: "unsupported",
};
export const NitroEnclavesSupport = {
    SUPPORTED: "supported",
    UNSUPPORTED: "unsupported",
};
export const DiskImageDescriptionFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ImportManifestUrl && { ImportManifestUrl: SENSITIVE_STRING }),
});
export const ImportInstanceVolumeDetailItemFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Image && { Image: DiskImageDescriptionFilterSensitiveLog(obj.Image) }),
});
export const ImportInstanceTaskDetailsFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Volumes && { Volumes: obj.Volumes.map((item) => ImportInstanceVolumeDetailItemFilterSensitiveLog(item)) }),
});
export const ImportVolumeTaskDetailsFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Image && { Image: DiskImageDescriptionFilterSensitiveLog(obj.Image) }),
});
export const ConversionTaskFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ImportInstance && { ImportInstance: ImportInstanceTaskDetailsFilterSensitiveLog(obj.ImportInstance) }),
    ...(obj.ImportVolume && { ImportVolume: ImportVolumeTaskDetailsFilterSensitiveLog(obj.ImportVolume) }),
});
export const DescribeConversionTasksResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ConversionTasks && {
        ConversionTasks: obj.ConversionTasks.map((item) => ConversionTaskFilterSensitiveLog(item)),
    }),
});
export const SnapshotDetailFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Url && { Url: SENSITIVE_STRING }),
});
export const ImportImageTaskFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SnapshotDetails && {
        SnapshotDetails: obj.SnapshotDetails.map((item) => SnapshotDetailFilterSensitiveLog(item)),
    }),
});
export const DescribeImportImageTasksResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SnapshotTaskDetailFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Url && { Url: SENSITIVE_STRING }),
});
export const ImportSnapshotTaskFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SnapshotTaskDetail && { SnapshotTaskDetail: SnapshotTaskDetailFilterSensitiveLog(obj.SnapshotTaskDetail) }),
});
export const DescribeImportSnapshotTasksResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ImportSnapshotTasks && {
        ImportSnapshotTasks: obj.ImportSnapshotTasks.map((item) => ImportSnapshotTaskFilterSensitiveLog(item)),
    }),
});
