import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { CreateNetworkInterfaceRequest, CreateNetworkInterfaceResult } from "../models/models_2";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link CreateNetworkInterfaceCommand}.
 */
export interface CreateNetworkInterfaceCommandInput extends CreateNetworkInterfaceRequest {
}
/**
 * @public
 *
 * The output of {@link CreateNetworkInterfaceCommand}.
 */
export interface CreateNetworkInterfaceCommandOutput extends CreateNetworkInterfaceResult, __MetadataBearer {
}
declare const CreateNetworkInterfaceCommand_base: {
    new (input: CreateNetworkInterfaceCommandInput): import("@smithy/smithy-client").CommandImpl<CreateNetworkInterfaceCommandInput, CreateNetworkInterfaceCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: CreateNetworkInterfaceCommandInput): import("@smithy/smithy-client").CommandImpl<CreateNetworkInterfaceCommandInput, CreateNetworkInterfaceCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Creates a network interface in the specified subnet.</p>
 *          <p>The number of IP addresses you can assign to a network interface varies by instance
 *             type.</p>
 *          <p>For more information about network interfaces, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html">Elastic network interfaces</a> in the
 *                 <i>Amazon EC2 User Guide</i>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, CreateNetworkInterfaceCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, CreateNetworkInterfaceCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // CreateNetworkInterfaceRequest
 *   Ipv4Prefixes: [ // Ipv4PrefixList
 *     { // Ipv4PrefixSpecificationRequest
 *       Ipv4Prefix: "STRING_VALUE",
 *     },
 *   ],
 *   Ipv4PrefixCount: Number("int"),
 *   Ipv6Prefixes: [ // Ipv6PrefixList
 *     { // Ipv6PrefixSpecificationRequest
 *       Ipv6Prefix: "STRING_VALUE",
 *     },
 *   ],
 *   Ipv6PrefixCount: Number("int"),
 *   InterfaceType: "efa" || "efa-only" || "branch" || "trunk",
 *   TagSpecifications: [ // TagSpecificationList
 *     { // TagSpecification
 *       ResourceType: "capacity-reservation" || "client-vpn-endpoint" || "customer-gateway" || "carrier-gateway" || "coip-pool" || "declarative-policies-report" || "dedicated-host" || "dhcp-options" || "egress-only-internet-gateway" || "elastic-ip" || "elastic-gpu" || "export-image-task" || "export-instance-task" || "fleet" || "fpga-image" || "host-reservation" || "image" || "image-usage-report" || "import-image-task" || "import-snapshot-task" || "instance" || "instance-event-window" || "internet-gateway" || "ipam" || "ipam-pool" || "ipam-scope" || "ipv4pool-ec2" || "ipv6pool-ec2" || "key-pair" || "launch-template" || "local-gateway" || "local-gateway-route-table" || "local-gateway-virtual-interface" || "local-gateway-virtual-interface-group" || "local-gateway-route-table-vpc-association" || "local-gateway-route-table-virtual-interface-group-association" || "natgateway" || "network-acl" || "network-interface" || "network-insights-analysis" || "network-insights-path" || "network-insights-access-scope" || "network-insights-access-scope-analysis" || "outpost-lag" || "placement-group" || "prefix-list" || "replace-root-volume-task" || "reserved-instances" || "route-table" || "security-group" || "security-group-rule" || "service-link-virtual-interface" || "snapshot" || "spot-fleet-request" || "spot-instances-request" || "subnet" || "subnet-cidr-reservation" || "traffic-mirror-filter" || "traffic-mirror-session" || "traffic-mirror-target" || "transit-gateway" || "transit-gateway-attachment" || "transit-gateway-connect-peer" || "transit-gateway-multicast-domain" || "transit-gateway-policy-table" || "transit-gateway-route-table" || "transit-gateway-route-table-announcement" || "volume" || "vpc" || "vpc-endpoint" || "vpc-endpoint-connection" || "vpc-endpoint-service" || "vpc-endpoint-service-permission" || "vpc-peering-connection" || "vpn-connection" || "vpn-gateway" || "vpc-flow-log" || "capacity-reservation-fleet" || "traffic-mirror-filter-rule" || "vpc-endpoint-connection-device-type" || "verified-access-instance" || "verified-access-group" || "verified-access-endpoint" || "verified-access-policy" || "verified-access-trust-provider" || "vpn-connection-device-type" || "vpc-block-public-access-exclusion" || "route-server" || "route-server-endpoint" || "route-server-peer" || "ipam-resource-discovery" || "ipam-resource-discovery-association" || "instance-connect-endpoint" || "verified-access-endpoint-target" || "ipam-external-resource-verification-token" || "capacity-block" || "mac-modification-task",
 *       Tags: [ // TagList
 *         { // Tag
 *           Key: "STRING_VALUE",
 *           Value: "STRING_VALUE",
 *         },
 *       ],
 *     },
 *   ],
 *   ClientToken: "STRING_VALUE",
 *   EnablePrimaryIpv6: true || false,
 *   ConnectionTrackingSpecification: { // ConnectionTrackingSpecificationRequest
 *     TcpEstablishedTimeout: Number("int"),
 *     UdpStreamTimeout: Number("int"),
 *     UdpTimeout: Number("int"),
 *   },
 *   Operator: { // OperatorRequest
 *     Principal: "STRING_VALUE",
 *   },
 *   SubnetId: "STRING_VALUE", // required
 *   Description: "STRING_VALUE",
 *   PrivateIpAddress: "STRING_VALUE",
 *   Groups: [ // SecurityGroupIdStringList
 *     "STRING_VALUE",
 *   ],
 *   PrivateIpAddresses: [ // PrivateIpAddressSpecificationList
 *     { // PrivateIpAddressSpecification
 *       Primary: true || false,
 *       PrivateIpAddress: "STRING_VALUE",
 *     },
 *   ],
 *   SecondaryPrivateIpAddressCount: Number("int"),
 *   Ipv6Addresses: [ // InstanceIpv6AddressList
 *     { // InstanceIpv6Address
 *       Ipv6Address: "STRING_VALUE",
 *       IsPrimaryIpv6: true || false,
 *     },
 *   ],
 *   Ipv6AddressCount: Number("int"),
 *   DryRun: true || false,
 * };
 * const command = new CreateNetworkInterfaceCommand(input);
 * const response = await client.send(command);
 * // { // CreateNetworkInterfaceResult
 * //   NetworkInterface: { // NetworkInterface
 * //     Association: { // NetworkInterfaceAssociation
 * //       AllocationId: "STRING_VALUE",
 * //       AssociationId: "STRING_VALUE",
 * //       IpOwnerId: "STRING_VALUE",
 * //       PublicDnsName: "STRING_VALUE",
 * //       PublicIp: "STRING_VALUE",
 * //       CustomerOwnedIp: "STRING_VALUE",
 * //       CarrierIp: "STRING_VALUE",
 * //     },
 * //     Attachment: { // NetworkInterfaceAttachment
 * //       AttachTime: new Date("TIMESTAMP"),
 * //       AttachmentId: "STRING_VALUE",
 * //       DeleteOnTermination: true || false,
 * //       DeviceIndex: Number("int"),
 * //       NetworkCardIndex: Number("int"),
 * //       InstanceId: "STRING_VALUE",
 * //       InstanceOwnerId: "STRING_VALUE",
 * //       Status: "attaching" || "attached" || "detaching" || "detached",
 * //       EnaSrdSpecification: { // AttachmentEnaSrdSpecification
 * //         EnaSrdEnabled: true || false,
 * //         EnaSrdUdpSpecification: { // AttachmentEnaSrdUdpSpecification
 * //           EnaSrdUdpEnabled: true || false,
 * //         },
 * //       },
 * //       EnaQueueCount: Number("int"),
 * //     },
 * //     AvailabilityZone: "STRING_VALUE",
 * //     ConnectionTrackingConfiguration: { // ConnectionTrackingConfiguration
 * //       TcpEstablishedTimeout: Number("int"),
 * //       UdpStreamTimeout: Number("int"),
 * //       UdpTimeout: Number("int"),
 * //     },
 * //     Description: "STRING_VALUE",
 * //     Groups: [ // GroupIdentifierList
 * //       { // GroupIdentifier
 * //         GroupId: "STRING_VALUE",
 * //         GroupName: "STRING_VALUE",
 * //       },
 * //     ],
 * //     InterfaceType: "interface" || "natGateway" || "efa" || "efa-only" || "trunk" || "load_balancer" || "network_load_balancer" || "vpc_endpoint" || "branch" || "transit_gateway" || "lambda" || "quicksight" || "global_accelerator_managed" || "api_gateway_managed" || "gateway_load_balancer" || "gateway_load_balancer_endpoint" || "iot_rules_managed" || "aws_codestar_connections_managed",
 * //     Ipv6Addresses: [ // NetworkInterfaceIpv6AddressesList
 * //       { // NetworkInterfaceIpv6Address
 * //         Ipv6Address: "STRING_VALUE",
 * //         PublicIpv6DnsName: "STRING_VALUE",
 * //         IsPrimaryIpv6: true || false,
 * //       },
 * //     ],
 * //     MacAddress: "STRING_VALUE",
 * //     NetworkInterfaceId: "STRING_VALUE",
 * //     OutpostArn: "STRING_VALUE",
 * //     OwnerId: "STRING_VALUE",
 * //     PrivateDnsName: "STRING_VALUE",
 * //     PublicDnsName: "STRING_VALUE",
 * //     PublicIpDnsNameOptions: { // PublicIpDnsNameOptions
 * //       DnsHostnameType: "STRING_VALUE",
 * //       PublicIpv4DnsName: "STRING_VALUE",
 * //       PublicIpv6DnsName: "STRING_VALUE",
 * //       PublicDualStackDnsName: "STRING_VALUE",
 * //     },
 * //     PrivateIpAddress: "STRING_VALUE",
 * //     PrivateIpAddresses: [ // NetworkInterfacePrivateIpAddressList
 * //       { // NetworkInterfacePrivateIpAddress
 * //         Association: {
 * //           AllocationId: "STRING_VALUE",
 * //           AssociationId: "STRING_VALUE",
 * //           IpOwnerId: "STRING_VALUE",
 * //           PublicDnsName: "STRING_VALUE",
 * //           PublicIp: "STRING_VALUE",
 * //           CustomerOwnedIp: "STRING_VALUE",
 * //           CarrierIp: "STRING_VALUE",
 * //         },
 * //         Primary: true || false,
 * //         PrivateDnsName: "STRING_VALUE",
 * //         PrivateIpAddress: "STRING_VALUE",
 * //       },
 * //     ],
 * //     Ipv4Prefixes: [ // Ipv4PrefixesList
 * //       { // Ipv4PrefixSpecification
 * //         Ipv4Prefix: "STRING_VALUE",
 * //       },
 * //     ],
 * //     Ipv6Prefixes: [ // Ipv6PrefixesList
 * //       { // Ipv6PrefixSpecification
 * //         Ipv6Prefix: "STRING_VALUE",
 * //       },
 * //     ],
 * //     RequesterId: "STRING_VALUE",
 * //     RequesterManaged: true || false,
 * //     SourceDestCheck: true || false,
 * //     Status: "available" || "associated" || "attaching" || "in-use" || "detaching",
 * //     SubnetId: "STRING_VALUE",
 * //     TagSet: [ // TagList
 * //       { // Tag
 * //         Key: "STRING_VALUE",
 * //         Value: "STRING_VALUE",
 * //       },
 * //     ],
 * //     VpcId: "STRING_VALUE",
 * //     DenyAllIgwTraffic: true || false,
 * //     Ipv6Native: true || false,
 * //     Ipv6Address: "STRING_VALUE",
 * //     Operator: { // OperatorResponse
 * //       Managed: true || false,
 * //       Principal: "STRING_VALUE",
 * //     },
 * //     AssociatedSubnets: [ // AssociatedSubnetList
 * //       "STRING_VALUE",
 * //     ],
 * //   },
 * //   ClientToken: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param CreateNetworkInterfaceCommandInput - {@link CreateNetworkInterfaceCommandInput}
 * @returns {@link CreateNetworkInterfaceCommandOutput}
 * @see {@link CreateNetworkInterfaceCommandInput} for command's `input` shape.
 * @see {@link CreateNetworkInterfaceCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 *
 * @public
 */
export declare class CreateNetworkInterfaceCommand extends CreateNetworkInterfaceCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: CreateNetworkInterfaceRequest;
            output: CreateNetworkInterfaceResult;
        };
        sdk: {
            input: CreateNetworkInterfaceCommandInput;
            output: CreateNetworkInterfaceCommandOutput;
        };
    };
}
