import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DeleteIpamExternalResourceVerificationTokenRequest, DeleteIpamExternalResourceVerificationTokenResult } from "../models/models_3";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link DeleteIpamExternalResourceVerificationTokenCommand}.
 */
export interface DeleteIpamExternalResourceVerificationTokenCommandInput extends DeleteIpamExternalResourceVerificationTokenRequest {
}
/**
 * @public
 *
 * The output of {@link DeleteIpamExternalResourceVerificationTokenCommand}.
 */
export interface DeleteIpamExternalResourceVerificationTokenCommandOutput extends DeleteIpamExternalResourceVerificationTokenResult, __MetadataBearer {
}
declare const DeleteIpamExternalResourceVerificationTokenCommand_base: {
    new (input: DeleteIpamExternalResourceVerificationTokenCommandInput): import("@smithy/smithy-client").CommandImpl<DeleteIpamExternalResourceVerificationTokenCommandInput, DeleteIpamExternalResourceVerificationTokenCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: DeleteIpamExternalResourceVerificationTokenCommandInput): import("@smithy/smithy-client").CommandImpl<DeleteIpamExternalResourceVerificationTokenCommandInput, DeleteIpamExternalResourceVerificationTokenCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Delete a verification token. A verification token is an Amazon Web Services-generated random value that you can use to prove ownership of an external resource. For example, you can use a verification token to validate that you control a public IP address range when you bring an IP address range to Amazon Web Services (BYOIP).
 * </p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DeleteIpamExternalResourceVerificationTokenCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DeleteIpamExternalResourceVerificationTokenCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // DeleteIpamExternalResourceVerificationTokenRequest
 *   DryRun: true || false,
 *   IpamExternalResourceVerificationTokenId: "STRING_VALUE", // required
 * };
 * const command = new DeleteIpamExternalResourceVerificationTokenCommand(input);
 * const response = await client.send(command);
 * // { // DeleteIpamExternalResourceVerificationTokenResult
 * //   IpamExternalResourceVerificationToken: { // IpamExternalResourceVerificationToken
 * //     IpamExternalResourceVerificationTokenId: "STRING_VALUE",
 * //     IpamExternalResourceVerificationTokenArn: "STRING_VALUE",
 * //     IpamId: "STRING_VALUE",
 * //     IpamArn: "STRING_VALUE",
 * //     IpamRegion: "STRING_VALUE",
 * //     TokenValue: "STRING_VALUE",
 * //     TokenName: "STRING_VALUE",
 * //     NotAfter: new Date("TIMESTAMP"),
 * //     Status: "valid" || "expired",
 * //     Tags: [ // TagList
 * //       { // Tag
 * //         Key: "STRING_VALUE",
 * //         Value: "STRING_VALUE",
 * //       },
 * //     ],
 * //     State: "create-in-progress" || "create-complete" || "create-failed" || "delete-in-progress" || "delete-complete" || "delete-failed",
 * //   },
 * // };
 *
 * ```
 *
 * @param DeleteIpamExternalResourceVerificationTokenCommandInput - {@link DeleteIpamExternalResourceVerificationTokenCommandInput}
 * @returns {@link DeleteIpamExternalResourceVerificationTokenCommandOutput}
 * @see {@link DeleteIpamExternalResourceVerificationTokenCommandInput} for command's `input` shape.
 * @see {@link DeleteIpamExternalResourceVerificationTokenCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 *
 * @public
 */
export declare class DeleteIpamExternalResourceVerificationTokenCommand extends DeleteIpamExternalResourceVerificationTokenCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: DeleteIpamExternalResourceVerificationTokenRequest;
            output: DeleteIpamExternalResourceVerificationTokenResult;
        };
        sdk: {
            input: DeleteIpamExternalResourceVerificationTokenCommandInput;
            output: DeleteIpamExternalResourceVerificationTokenCommandOutput;
        };
    };
}
