import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DeleteLocalGatewayRouteTableVpcAssociationRequest, DeleteLocalGatewayRouteTableVpcAssociationResult } from "../models/models_3";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link DeleteLocalGatewayRouteTableVpcAssociationCommand}.
 */
export interface DeleteLocalGatewayRouteTableVpcAssociationCommandInput extends DeleteLocalGatewayRouteTableVpcAssociationRequest {
}
/**
 * @public
 *
 * The output of {@link DeleteLocalGatewayRouteTableVpcAssociationCommand}.
 */
export interface DeleteLocalGatewayRouteTableVpcAssociationCommandOutput extends DeleteLocalGatewayRouteTableVpcAssociationResult, __MetadataBearer {
}
declare const DeleteLocalGatewayRouteTableVpcAssociationCommand_base: {
    new (input: DeleteLocalGatewayRouteTableVpcAssociationCommandInput): import("@smithy/smithy-client").CommandImpl<DeleteLocalGatewayRouteTableVpcAssociationCommandInput, DeleteLocalGatewayRouteTableVpcAssociationCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: DeleteLocalGatewayRouteTableVpcAssociationCommandInput): import("@smithy/smithy-client").CommandImpl<DeleteLocalGatewayRouteTableVpcAssociationCommandInput, DeleteLocalGatewayRouteTableVpcAssociationCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Deletes the specified association between a VPC and local gateway route table.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DeleteLocalGatewayRouteTableVpcAssociationCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DeleteLocalGatewayRouteTableVpcAssociationCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // DeleteLocalGatewayRouteTableVpcAssociationRequest
 *   LocalGatewayRouteTableVpcAssociationId: "STRING_VALUE", // required
 *   DryRun: true || false,
 * };
 * const command = new DeleteLocalGatewayRouteTableVpcAssociationCommand(input);
 * const response = await client.send(command);
 * // { // DeleteLocalGatewayRouteTableVpcAssociationResult
 * //   LocalGatewayRouteTableVpcAssociation: { // LocalGatewayRouteTableVpcAssociation
 * //     LocalGatewayRouteTableVpcAssociationId: "STRING_VALUE",
 * //     LocalGatewayRouteTableId: "STRING_VALUE",
 * //     LocalGatewayRouteTableArn: "STRING_VALUE",
 * //     LocalGatewayId: "STRING_VALUE",
 * //     VpcId: "STRING_VALUE",
 * //     OwnerId: "STRING_VALUE",
 * //     State: "STRING_VALUE",
 * //     Tags: [ // TagList
 * //       { // Tag
 * //         Key: "STRING_VALUE",
 * //         Value: "STRING_VALUE",
 * //       },
 * //     ],
 * //   },
 * // };
 *
 * ```
 *
 * @param DeleteLocalGatewayRouteTableVpcAssociationCommandInput - {@link DeleteLocalGatewayRouteTableVpcAssociationCommandInput}
 * @returns {@link DeleteLocalGatewayRouteTableVpcAssociationCommandOutput}
 * @see {@link DeleteLocalGatewayRouteTableVpcAssociationCommandInput} for command's `input` shape.
 * @see {@link DeleteLocalGatewayRouteTableVpcAssociationCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 *
 * @public
 */
export declare class DeleteLocalGatewayRouteTableVpcAssociationCommand extends DeleteLocalGatewayRouteTableVpcAssociationCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: DeleteLocalGatewayRouteTableVpcAssociationRequest;
            output: DeleteLocalGatewayRouteTableVpcAssociationResult;
        };
        sdk: {
            input: DeleteLocalGatewayRouteTableVpcAssociationCommandInput;
            output: DeleteLocalGatewayRouteTableVpcAssociationCommandOutput;
        };
    };
}
