import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DeleteNetworkInsightsPathRequest, DeleteNetworkInsightsPathResult } from "../models/models_3";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link DeleteNetworkInsightsPathCommand}.
 */
export interface DeleteNetworkInsightsPathCommandInput extends DeleteNetworkInsightsPathRequest {
}
/**
 * @public
 *
 * The output of {@link DeleteNetworkInsightsPathCommand}.
 */
export interface DeleteNetworkInsightsPathCommandOutput extends DeleteNetworkInsightsPathResult, __MetadataBearer {
}
declare const DeleteNetworkInsightsPathCommand_base: {
    new (input: DeleteNetworkInsightsPathCommandInput): import("@smithy/smithy-client").CommandImpl<DeleteNetworkInsightsPathCommandInput, DeleteNetworkInsightsPathCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: DeleteNetworkInsightsPathCommandInput): import("@smithy/smithy-client").CommandImpl<DeleteNetworkInsightsPathCommandInput, DeleteNetworkInsightsPathCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Deletes the specified path.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DeleteNetworkInsightsPathCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DeleteNetworkInsightsPathCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // DeleteNetworkInsightsPathRequest
 *   DryRun: true || false,
 *   NetworkInsightsPathId: "STRING_VALUE", // required
 * };
 * const command = new DeleteNetworkInsightsPathCommand(input);
 * const response = await client.send(command);
 * // { // DeleteNetworkInsightsPathResult
 * //   NetworkInsightsPathId: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param DeleteNetworkInsightsPathCommandInput - {@link DeleteNetworkInsightsPathCommandInput}
 * @returns {@link DeleteNetworkInsightsPathCommandOutput}
 * @see {@link DeleteNetworkInsightsPathCommandInput} for command's `input` shape.
 * @see {@link DeleteNetworkInsightsPathCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 *
 * @public
 */
export declare class DeleteNetworkInsightsPathCommand extends DeleteNetworkInsightsPathCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: DeleteNetworkInsightsPathRequest;
            output: DeleteNetworkInsightsPathResult;
        };
        sdk: {
            input: DeleteNetworkInsightsPathCommandInput;
            output: DeleteNetworkInsightsPathCommandOutput;
        };
    };
}
