import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { ModifyInstanceConnectEndpointRequest, ModifyInstanceConnectEndpointResult } from "../models/models_7";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link ModifyInstanceConnectEndpointCommand}.
 */
export interface ModifyInstanceConnectEndpointCommandInput extends ModifyInstanceConnectEndpointRequest {
}
/**
 * @public
 *
 * The output of {@link ModifyInstanceConnectEndpointCommand}.
 */
export interface ModifyInstanceConnectEndpointCommandOutput extends ModifyInstanceConnectEndpointResult, __MetadataBearer {
}
declare const ModifyInstanceConnectEndpointCommand_base: {
    new (input: ModifyInstanceConnectEndpointCommandInput): import("@smithy/smithy-client").CommandImpl<ModifyInstanceConnectEndpointCommandInput, ModifyInstanceConnectEndpointCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: ModifyInstanceConnectEndpointCommandInput): import("@smithy/smithy-client").CommandImpl<ModifyInstanceConnectEndpointCommandInput, ModifyInstanceConnectEndpointCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Modifies the specified EC2 Instance Connect Endpoint.</p>
 *          <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/modify-ec2-instance-connect-endpoint.html">Modify an
 *                 EC2 Instance Connect Endpoint</a> in the
 *             <i>Amazon EC2 User Guide</i>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, ModifyInstanceConnectEndpointCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, ModifyInstanceConnectEndpointCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // ModifyInstanceConnectEndpointRequest
 *   DryRun: true || false,
 *   InstanceConnectEndpointId: "STRING_VALUE", // required
 *   IpAddressType: "ipv4" || "dualstack" || "ipv6",
 *   SecurityGroupIds: [ // SecurityGroupIdStringListRequest
 *     "STRING_VALUE",
 *   ],
 *   PreserveClientIp: true || false,
 * };
 * const command = new ModifyInstanceConnectEndpointCommand(input);
 * const response = await client.send(command);
 * // { // ModifyInstanceConnectEndpointResult
 * //   Return: true || false,
 * // };
 *
 * ```
 *
 * @param ModifyInstanceConnectEndpointCommandInput - {@link ModifyInstanceConnectEndpointCommandInput}
 * @returns {@link ModifyInstanceConnectEndpointCommandOutput}
 * @see {@link ModifyInstanceConnectEndpointCommandInput} for command's `input` shape.
 * @see {@link ModifyInstanceConnectEndpointCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 *
 * @public
 */
export declare class ModifyInstanceConnectEndpointCommand extends ModifyInstanceConnectEndpointCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: ModifyInstanceConnectEndpointRequest;
            output: ModifyInstanceConnectEndpointResult;
        };
        sdk: {
            input: ModifyInstanceConnectEndpointCommandInput;
            output: ModifyInstanceConnectEndpointCommandOutput;
        };
    };
}
