import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_UpdateContainerAgentCommand, se_UpdateContainerAgentCommand } from "../protocols/Aws_json1_1";
export { $Command };
export class UpdateContainerAgentCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonEC2ContainerServiceV20141113", "UpdateContainerAgent", {})
    .n("ECSClient", "UpdateContainerAgentCommand")
    .f(void 0, void 0)
    .ser(se_UpdateContainerAgentCommand)
    .de(de_UpdateContainerAgentCommand)
    .build() {
}
