import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { ListActivitiesInput, ListActivitiesOutput } from "../models/models_0";
import { ServiceInputTypes, ServiceOutputTypes, SFNClientResolvedConfig } from "../SFNClient";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link ListActivitiesCommand}.
 */
export interface ListActivitiesCommandInput extends ListActivitiesInput {
}
/**
 * @public
 *
 * The output of {@link ListActivitiesCommand}.
 */
export interface ListActivitiesCommandOutput extends ListActivitiesOutput, __MetadataBearer {
}
declare const ListActivitiesCommand_base: {
    new (input: ListActivitiesCommandInput): import("@smithy/smithy-client").CommandImpl<ListActivitiesCommandInput, ListActivitiesCommandOutput, SFNClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (...[input]: [] | [ListActivitiesCommandInput]): import("@smithy/smithy-client").CommandImpl<ListActivitiesCommandInput, ListActivitiesCommandOutput, SFNClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Lists the existing activities.</p>
 *          <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page.
 *     Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
 *          <note>
 *             <p>This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.</p>
 *          </note>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { SFNClient, ListActivitiesCommand } from "@aws-sdk/client-sfn"; // ES Modules import
 * // const { SFNClient, ListActivitiesCommand } = require("@aws-sdk/client-sfn"); // CommonJS import
 * const client = new SFNClient(config);
 * const input = { // ListActivitiesInput
 *   maxResults: Number("int"),
 *   nextToken: "STRING_VALUE",
 * };
 * const command = new ListActivitiesCommand(input);
 * const response = await client.send(command);
 * // { // ListActivitiesOutput
 * //   activities: [ // ActivityList // required
 * //     { // ActivityListItem
 * //       activityArn: "STRING_VALUE", // required
 * //       name: "STRING_VALUE", // required
 * //       creationDate: new Date("TIMESTAMP"), // required
 * //     },
 * //   ],
 * //   nextToken: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param ListActivitiesCommandInput - {@link ListActivitiesCommandInput}
 * @returns {@link ListActivitiesCommandOutput}
 * @see {@link ListActivitiesCommandInput} for command's `input` shape.
 * @see {@link ListActivitiesCommandOutput} for command's `response` shape.
 * @see {@link SFNClientResolvedConfig | config} for SFNClient's `config` shape.
 *
 * @throws {@link InvalidToken} (client fault)
 *  <p>The provided token is not valid.</p>
 *
 * @throws {@link SFNServiceException}
 * <p>Base exception class for all service exceptions from SFN service.</p>
 *
 *
 * @public
 */
export declare class ListActivitiesCommand extends ListActivitiesCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: ListActivitiesInput;
            output: ListActivitiesOutput;
        };
        sdk: {
            input: ListActivitiesCommandInput;
            output: ListActivitiesCommandOutput;
        };
    };
}
