import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { CreateAssociationRequestFilterSensitiveLog, CreateAssociationResultFilterSensitiveLog, } from "../models/models_0";
import { de_CreateAssociationCommand, se_CreateAssociationCommand } from "../protocols/Aws_json1_1";
export { $Command };
export class CreateAssociationCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonSSM", "CreateAssociation", {})
    .n("SSMClient", "CreateAssociationCommand")
    .f(CreateAssociationRequestFilterSensitiveLog, CreateAssociationResultFilterSensitiveLog)
    .ser(se_CreateAssociationCommand)
    .de(de_CreateAssociationCommand)
    .build() {
}
