import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { DescribeMaintenanceWindowTasksResultFilterSensitiveLog, } from "../models/models_1";
import { de_DescribeMaintenanceWindowTasksCommand, se_DescribeMaintenanceWindowTasksCommand, } from "../protocols/Aws_json1_1";
export { $Command };
export class DescribeMaintenanceWindowTasksCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonSSM", "DescribeMaintenanceWindowTasks", {})
    .n("SSMClient", "DescribeMaintenanceWindowTasksCommand")
    .f(void 0, DescribeMaintenanceWindowTasksResultFilterSensitiveLog)
    .ser(se_DescribeMaintenanceWindowTasksCommand)
    .de(de_DescribeMaintenanceWindowTasksCommand)
    .build() {
}
