import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [account](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsaccountmanagement.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Account extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to accept the process to update the primary email address of an account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifEmailTargetDomain()
     *
     * https://docs.aws.amazon.com/accounts/latest/reference/API_AcceptPrimaryEmailUpdate.html
     */
    toAcceptPrimaryEmailUpdate(): this;
    /**
     * Grants permission to close an account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/accounts/latest/reference/security_account-permissions-ref.html
     */
    toCloseAccount(): this;
    /**
     * Grants permission to delete the alternate contacts for an account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAlternateContactTypes()
     *
     * https://docs.aws.amazon.com/accounts/latest/reference/API_DeleteAlternateContact.html
     */
    toDeleteAlternateContact(): this;
    /**
     * Grants permission to disable use of a Region
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifTargetRegion()
     *
     * https://docs.aws.amazon.com/accounts/latest/reference/API_DisableRegion.html
     */
    toDisableRegion(): this;
    /**
     * Grants permission to enable use of a Region
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifTargetRegion()
     *
     * https://docs.aws.amazon.com/accounts/latest/reference/API_EnableRegion.html
     */
    toEnableRegion(): this;
    /**
     * Grants permission to retrieve the account information for an account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/accounts/latest/reference/API_GetAccountInformation.html
     */
    toGetAccountInformation(): this;
    /**
     * Grants permission to retrieve the alternate contacts for an account
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAlternateContactTypes()
     *
     * https://docs.aws.amazon.com/accounts/latest/reference/API_GetAlternateContact.html
     */
    toGetAlternateContact(): this;
    /**
     * Grants permission to retrieve the primary contact information for an account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/accounts/latest/reference/API_GetContactInformation.html
     */
    toGetContactInformation(): this;
    /**
     * Grants permission to retrieve the primary email address of an account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/accounts/latest/reference/API_GetPrimaryEmail.html
     */
    toGetPrimaryEmail(): this;
    /**
     * Grants permission to get the opt-in status of a Region
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifTargetRegion()
     *
     * https://docs.aws.amazon.com/accounts/latest/reference/API_GetRegionOptStatus.html
     */
    toGetRegionOptStatus(): this;
    /**
     * Grants permission to list the available Regions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/accounts/latest/reference/API_ListRegions.html
     */
    toListRegions(): this;
    /**
     * Grants permission to update the name for an account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/accounts/latest/reference/API_PutAccountName.html
     */
    toPutAccountName(): this;
    /**
     * Grants permission to modify the alternate contacts for an account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAlternateContactTypes()
     *
     * https://docs.aws.amazon.com/accounts/latest/reference/API_PutAlternateContact.html
     */
    toPutAlternateContact(): this;
    /**
     * Grants permission to update the primary contact information for an account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/accounts/latest/reference/API_PutContactInformation.html
     */
    toPutContactInformation(): this;
    /**
     * Grants permission to start the process to update the primary email address of an account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifEmailTargetDomain()
     *
     * https://docs.aws.amazon.com/accounts/latest/reference/API_StartPrimaryEmailUpdate.html
     */
    toStartPrimaryEmailUpdate(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type account to the statement
     *
     * https://docs.aws.amazon.com/accounts/latest/reference/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-resources
     *
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onAccount(account?: string, partition?: string): this;
    /**
     * Adds a resource of type accountInOrganization to the statement
     *
     * https://docs.aws.amazon.com/accounts/latest/reference/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-resources
     *
     * @param managementAccountId - Identifier for the managementAccountId.
     * @param organizationId - Identifier for the organizationId.
     * @param memberAccountId - Identifier for the memberAccountId.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onAccountInOrganization(managementAccountId: string, organizationId: string, memberAccountId: string, partition?: string): this;
    /**
     * Filters access by the resource path for an account in an organization
     *
     * https://docs.aws.amazon.com/accounts/latest/reference/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-conditionkeys
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAccountResourceOrgPaths(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by resource tags for an account in an organization
     *
     * https://docs.aws.amazon.com/accounts/latest/reference/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-conditionkeys
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAccountResourceOrgTags(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by alternate contact types
     *
     * https://docs.aws.amazon.com/accounts/latest/reference/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-conditionkeys
     *
     * Applies to actions:
     * - .toDeleteAlternateContact()
     * - .toGetAlternateContact()
     * - .toPutAlternateContact()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAlternateContactTypes(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by email domain of the target email address
     *
     * https://docs.aws.amazon.com/accounts/latest/reference/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-conditionkeys
     *
     * Applies to actions:
     * - .toAcceptPrimaryEmailUpdate()
     * - .toStartPrimaryEmailUpdate()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifEmailTargetDomain(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by a list of Regions. Enables or disables all the Regions specified here
     *
     * https://docs.aws.amazon.com/accounts/latest/reference/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-conditionkeys
     *
     * Applies to actions:
     * - .toDisableRegion()
     * - .toEnableRegion()
     * - .toGetRegionOptStatus()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifTargetRegion(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [account](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsaccountmanagement.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
