import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [appfabric](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsappfabric.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Appfabric extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to start user access tasks for multiple users
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appfabric/latest/api/API_BatchGetUserAccessTasks.html
     */
    toBatchGetUserAccessTasks(): this;
    /**
     * Grants permission to connect app authorizations
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appfabric/latest/api/API_ConnectAppAuthorization.html
     */
    toConnectAppAuthorization(): this;
    /**
     * Grants permission to create app authorizations for app bundles
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/appfabric/latest/api/API_CreateAppAuthorization.html
     */
    toCreateAppAuthorization(): this;
    /**
     * Grants permission to create app bundles in your account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/appfabric/latest/api/API_CreateAppBundle.html
     */
    toCreateAppBundle(): this;
    /**
     * Grants permission to create ingestions for app bundles
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/appfabric/latest/api/API_CreateIngestion.html
     */
    toCreateIngestion(): this;
    /**
     * Grants permission to create ingestion destinations for app bundles
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/appfabric/latest/api/API_CreateIngestionDestination.html
     */
    toCreateIngestionDestination(): this;
    /**
     * Grants permission to delete app authorizations within an app bundle
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appfabric/latest/api/API_DeleteAppAuthorization.html
     */
    toDeleteAppAuthorization(): this;
    /**
     * Grants permission to delete app bundles in your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appfabric/latest/api/API_DeleteAppBundle.html
     */
    toDeleteAppBundle(): this;
    /**
     * Grants permission to delete ingestions within an app bundle
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appfabric/latest/api/API_DeleteIngestion.html
     */
    toDeleteIngestion(): this;
    /**
     * Grants permission to delete destinations within an ingestion
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appfabric/latest/api/API_DeleteIngestionDestination.html
     */
    toDeleteIngestionDestination(): this;
    /**
     * Grants permission to view details about app authorizations
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appfabric/latest/api/API_GetAppAuthorization.html
     */
    toGetAppAuthorization(): this;
    /**
     * Grants permission to view details about app bundles
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appfabric/latest/api/API_GetAppBundle.html
     */
    toGetAppBundle(): this;
    /**
     * Grants permission to view details about ingestions
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appfabric/latest/api/API_GetIngestion.html
     */
    toGetIngestion(): this;
    /**
     * Grants permission to view details about ingestion destinations
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appfabric/latest/api/API_GetIngestionDestination.html
     */
    toGetIngestionDestination(): this;
    /**
     * Grants permission to retrieve a list of app authorizations within an app bundle
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/appfabric/latest/api/API_ListAppAuthorizations.html
     */
    toListAppAuthorizations(): this;
    /**
     * Grants permission to retrieve a list of app bundles in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/appfabric/latest/api/API_ListAppBundles.html
     */
    toListAppBundles(): this;
    /**
     * Grants permission to retrieve a list of destinations within an ingestion
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/appfabric/latest/api/API_ListIngestionDestinations.html
     */
    toListIngestionDestinations(): this;
    /**
     * Grants permission to retrieve a list of ingestions within an app bundle
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/appfabric/latest/api/API_ListIngestions.html
     */
    toListIngestions(): this;
    /**
     * Grants permission to list tags for AppFabric resources
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appfabric/latest/api/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to start ingestions
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appfabric/latest/api/API_StartIngestion.html
     */
    toStartIngestion(): this;
    /**
     * Grants permission to start user access tasks
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appfabric/latest/api/API_StartUserAccessTasks.html
     */
    toStartUserAccessTasks(): this;
    /**
     * Grants permission to stop ingestions
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appfabric/latest/api/API_StopIngestion.html
     */
    toStopIngestion(): this;
    /**
     * Grants permission to tag AppFabric resources
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appfabric/latest/api/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to untag AppFabric resources
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/appfabric/latest/api/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update app authorizations within app bundles
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appfabric/latest/api/API_UpdateAppAuthorization.html
     */
    toUpdateAppAuthorization(): this;
    /**
     * Grants permission to update destinations within ingestions
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appfabric/latest/api/API_UpdateIngestionDestination.html
     */
    toUpdateIngestionDestination(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type appbundle to the statement
     *
     * https://docs.aws.amazon.com/appfabric/latest/api/API_AppBundle.html
     *
     * @param appBundleIdentifier - Identifier for the appBundleIdentifier.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAppbundle(appBundleIdentifier: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type appauthorization to the statement
     *
     * https://docs.aws.amazon.com/appfabric/latest/api/API_AppAuthorization.html
     *
     * @param appbundleId - Identifier for the appbundleId.
     * @param appAuthorizationIdentifier - Identifier for the appAuthorizationIdentifier.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAppauthorization(appbundleId: string, appAuthorizationIdentifier: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type ingestion to the statement
     *
     * https://docs.aws.amazon.com/appfabric/latest/api/API_Ingestion.html
     *
     * @param appbundleId - Identifier for the appbundleId.
     * @param ingestionIdentifier - Identifier for the ingestionIdentifier.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onIngestion(appbundleId: string, ingestionIdentifier: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type ingestiondestination to the statement
     *
     * https://docs.aws.amazon.com/appfabric/latest/api/API_IngestionDestination.html
     *
     * @param appbundleId - Identifier for the appbundleId.
     * @param ingestionIdentifier - Identifier for the ingestionIdentifier.
     * @param ingestionDestinationIdentifier - Identifier for the ingestionDestinationIdentifier.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onIngestiondestination(appbundleId: string, ingestionIdentifier: string, ingestionDestinationIdentifier: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the tags that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateAppAuthorization()
     * - .toCreateAppBundle()
     * - .toCreateIngestion()
     * - .toCreateIngestionDestination()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tags associated with the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to actions:
     * - .toGetAppAuthorization()
     * - .toGetAppBundle()
     * - .toGetIngestion()
     * - .toGetIngestionDestination()
     * - .toTagResource()
     * - .toUpdateAppAuthorization()
     * - .toUpdateIngestionDestination()
     *
     * Applies to resource types:
     * - appbundle
     * - appauthorization
     * - ingestion
     * - ingestiondestination
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tag keys that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateAppAuthorization()
     * - .toCreateAppBundle()
     * - .toCreateIngestion()
     * - .toCreateIngestionDestination()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [appfabric](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsappfabric.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
