import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [application-transformation](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsapplicationtransformationservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class ApplicationTransformation extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to get the details of all Containerization jobs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/tk-dotnet-refactoring/latest/userguide/what-is-tk-dotnet-refactoring.html
     */
    toGetContainerization(): this;
    /**
     * Grants permission to get the details of all Deployment jobs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/tk-dotnet-refactoring/latest/userguide/what-is-tk-dotnet-refactoring.html
     */
    toGetDeployment(): this;
    /**
     * Grants permission to Get the details of a Grouping Assessment Operation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/microservice-extractor/latest/userguide/what-is-microservice-extractor.html
     */
    toGetGroupingAssessment(): this;
    /**
     * Grants permission to Get Porting Compatibility Operation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/microservice-extractor/latest/userguide/what-is-microservice-extractor.html
     */
    toGetPortingCompatibilityAssessment(): this;
    /**
     * Grants permission to Get the details of a Porting Recommendation Assessment Operation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/microservice-extractor/latest/userguide/what-is-microservice-extractor.html
     */
    toGetPortingRecommendationAssessment(): this;
    /**
     * Grants permission to Get the details of a Runtime Assessment Operation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/microservice-extractor/latest/userguide/what-is-microservice-extractor.html
     */
    toGetRuntimeAssessment(): this;
    /**
     * Grants permission to Push Logs (Intended for Clients Only)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/microservice-extractor/latest/userguide/what-is-microservice-extractor.html
     */
    toPutLogData(): this;
    /**
     * Grants permission to Push Metrics Data (Intended for Clients Only)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/microservice-extractor/latest/userguide/what-is-microservice-extractor.html
     */
    toPutMetricData(): this;
    /**
     * Grants permission to start a Containerization job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/tk-dotnet-refactoring/latest/userguide/what-is-tk-dotnet-refactoring.html
     */
    toStartContainerization(): this;
    /**
     * Grants permission to start a Deployment job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/tk-dotnet-refactoring/latest/userguide/what-is-tk-dotnet-refactoring.html
     */
    toStartDeployment(): this;
    /**
     * Grants permission to Start a Grouping Assessment Operation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/microservice-extractor/latest/userguide/what-is-microservice-extractor.html
     */
    toStartGroupingAssessment(): this;
    /**
     * Grants permission to Start Porting Compatibility Operation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/microservice-extractor/latest/userguide/what-is-microservice-extractor.html
     */
    toStartPortingCompatibilityAssessment(): this;
    /**
     * Grants permission to Start the Porting Recommendation Assessment Operation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/microservice-extractor/latest/userguide/what-is-microservice-extractor.html
     */
    toStartPortingRecommendationAssessment(): this;
    /**
     * Grants permission to Start a Runtime Assessment Operation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/microservice-extractor/latest/userguide/what-is-microservice-extractor.html
     */
    toStartRuntimeAssessment(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Statement provider for service [application-transformation](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsapplicationtransformationservice.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
