import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [bcm-pricing-calculator](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsbillingandcostmanagementpricingcalculator.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class BcmPricingCalculator extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to create a new bill estimate. Charge is incurred for successful bill estimates
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_CreateBillEstimate.html
     */
    toCreateBillEstimate(): this;
    /**
     * Grants permission to create a new bill scenario
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_CreateBillScenario.html
     */
    toCreateBillScenario(): this;
    /**
     * Grants permission to create new commitments or remove existing commitment from a specified bill scenario
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_BatchCreateBillScenarioCommitmentModification.html
     */
    toCreateBillScenarioCommitmentModification(): this;
    /**
     * Grants permission to create usage in the specified bill scenario
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_BatchCreateBillScenarioUsageModification.html
     */
    toCreateBillScenarioUsageModification(): this;
    /**
     * Grants permission to create a new Workload estimate
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_CreateWorkloadEstimate.html
     */
    toCreateWorkloadEstimate(): this;
    /**
     * Grants permission to create usage in the specified workload estimate
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_BatchCreateWorkloadEstimateUsage.html
     */
    toCreateWorkloadEstimateUsage(): this;
    /**
     * Grants permission to delete bill estimate
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_DeleteBillEstimate.html
     */
    toDeleteBillEstimate(): this;
    /**
     * Grants permission to delete a bill scenario
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_DeleteBillScenario.html
     */
    toDeleteBillScenario(): this;
    /**
     * Grants permission to delete newly added commitments from the specified bill scenario
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_BatchDeleteBillScenarioCommitmentModification.html
     */
    toDeleteBillScenarioCommitmentModification(): this;
    /**
     * Grants permission to delete newly added usage from the specified bill scenario
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_BatchDeleteBillScenarioUsageModification.html
     */
    toDeleteBillScenarioUsageModification(): this;
    /**
     * Grants permission to delete the specified workload estimate
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_DeleteWorkloadEstimate.html
     */
    toDeleteWorkloadEstimate(): this;
    /**
     * Grants permission to delete newly added usage from the specified workload estimate
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_BatchDeleteWorkloadEstimateUsage.html
     */
    toDeleteWorkloadEstimateUsage(): this;
    /**
     * Grants permission to retrieve details of a bill estimate including estimated cost
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_GetBillEstimate.html
     */
    toGetBillEstimate(): this;
    /**
     * Grants permission to retrieve information associated with a bill scenario
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_GetBillScenario.html
     */
    toGetBillScenario(): this;
    /**
     * Grants permission to retrieve applicable rate type preferences for the account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_GetPreferences.html
     */
    toGetPreferences(): this;
    /**
     * Grants permission to retrieve information associated with a workload estimate
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_GetWorkloadEstimate.html
     */
    toGetWorkloadEstimate(): this;
    /**
     * Grants permission to list commitments associated with the specified bill estimate
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_ListBillEstimateCommitments.html
     */
    toListBillEstimateCommitments(): this;
    /**
     * Grants permission to list added or removed commitments for a specified bill estimate
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_ListBillEstimateInputCommitmentModifications.html
     */
    toListBillEstimateInputCommitmentModifications(): this;
    /**
     * Grants permission to list added or modified usage for a specified bill estimate
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_ListBillEstimateInputUsageModifications.html
     */
    toListBillEstimateInputUsageModifications(): this;
    /**
     * Grants permission to list result line items for a specified bill estimate
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_ListBillEstimateLineItems.html
     */
    toListBillEstimateLineItems(): this;
    /**
     * Grants permission to list bill estimates
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_ListBillEstimates.html
     */
    toListBillEstimates(): this;
    /**
     * Grants permission to list commitments included in a bill scenario
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_ListBillScenarioCommitmentModifications.html
     */
    toListBillScenarioCommitmentModifications(): this;
    /**
     * Grants permission to list usage lines of a specified bill scenario
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_ListBillScenarioUsageModifications.html
     */
    toListBillScenarioUsageModifications(): this;
    /**
     * Grants permission to list bill scenarios
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_ListBillScenarios.html
     */
    toListBillScenarios(): this;
    /**
     * Grants permission to return a list of tags for a resource
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to list usage lines for the specified workload estimate
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_ListWorkloadEstimateUsage.html
     */
    toListWorkloadEstimateUsage(): this;
    /**
     * Grants permission to list workload estimates
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_ListWorkloadEstimates.html
     */
    toListWorkloadEstimates(): this;
    /**
     * Grants permission to add a tag to a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove a tag from a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update bill estimate name and expiration date time
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_UpdateBillEstimate.html
     */
    toUpdateBillEstimate(): this;
    /**
     * Grants permission to update name and expiration date time of the specified bill scenario
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_UpdateBillScenario.html
     */
    toUpdateBillScenario(): this;
    /**
     * Grants permission to update commitment group of commitments in the specified bill scenario
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_BatchUpdateBillScenarioCommitmentModification.html
     */
    toUpdateBillScenarioCommitmentModification(): this;
    /**
     * Grants permission to update usage amount, usage hour, and usage group in the specified bill scenario
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_BatchUpdateBillScenarioUsageModification.html
     */
    toUpdateBillScenarioUsageModification(): this;
    /**
     * Grants permission to update rate type preferences for the account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_UpdatePreferences.html
     */
    toUpdatePreferences(): this;
    /**
     * Grants permission to update name and expiration date time of the specified workload estimate
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_UpdateWorkloadEstimate.html
     */
    toUpdateWorkloadEstimate(): this;
    /**
     * Grants permission to update usage amount and usage group in the specified workload estimate based on the usage id
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_BatchUpdateWorkloadEstimateUsage.html
     */
    toUpdateWorkloadEstimateUsage(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type bill-estimate to the statement
     *
     * https://docs.aws.amazon.com/cost-management/latest/userguide/pc-bill-estimate.html
     *
     * @param billEstimateId - Identifier for the billEstimateId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onBillEstimate(billEstimateId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type bill-scenario to the statement
     *
     * https://docs.aws.amazon.com/cost-management/latest/userguide/pc-bill-scenario.html
     *
     * @param billScenarioId - Identifier for the billScenarioId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onBillScenario(billScenarioId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type workload-estimate to the statement
     *
     * https://docs.aws.amazon.com/cost-management/latest/userguide/pc-workload-estimate.html
     *
     * @param workloadEstimateId - Identifier for the workloadEstimateId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onWorkloadEstimate(workloadEstimateId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the tags that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tags associated with the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tag keys that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [bcm-pricing-calculator](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsbillingandcostmanagementpricingcalculator.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
