import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [cleanrooms](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscleanrooms.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Cleanrooms extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to view details of analysisTemplates associated to the collaboration
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - cleanrooms:GetCollaborationAnalysisTemplate
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_BatchGetCollaborationAnalysisTemplate.html
     */
    toBatchGetCollaborationAnalysisTemplate(): this;
    /**
     * Grants permission to view details for schemas
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - cleanrooms:GetSchema
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_BatchGetSchema.html
     */
    toBatchGetSchema(): this;
    /**
     * Grants permission to view analysis rules associated with schemas
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - cleanrooms:GetSchema
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_BatchGetSchemaAnalysisRule.html
     */
    toBatchGetSchemaAnalysisRule(): this;
    /**
     * Grants permission to create a new analysis template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateAnalysisTemplate.html
     */
    toCreateAnalysisTemplate(): this;
    /**
     * Grants permission to create a new collaboration, a shared data collaboration environment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html
     */
    toCreateCollaboration(): this;
    /**
     * Grants permission to link a Cleanrooms ML configured audience model with a collaboration by creating a new association
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - cleanrooms-ml:GetConfiguredAudienceModel
     * - cleanrooms-ml:GetConfiguredAudienceModelPolicy
     * - cleanrooms-ml:PutConfiguredAudienceModelPolicy
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateConfiguredAudienceModelAssociation.html
     */
    toCreateConfiguredAudienceModelAssociation(): this;
    /**
     * Grants permission to create a new configured table
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - athena:GetTableMetadata
     * - glue:BatchGetPartition
     * - glue:GetDatabase
     * - glue:GetDatabases
     * - glue:GetPartition
     * - glue:GetPartitions
     * - glue:GetSchemaVersion
     * - glue:GetTable
     * - glue:GetTables
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateConfiguredTable.html
     */
    toCreateConfiguredTable(): this;
    /**
     * Grants permission to create a analysis rule for a configured table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateConfiguredTableAnalysisRule.html
     */
    toCreateConfiguredTableAnalysisRule(): this;
    /**
     * Grants permission to link a configured table with a collaboration by creating a new association
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateConfiguredTableAssociation.html
     */
    toCreateConfiguredTableAssociation(): this;
    /**
     * Grants permission to create an analysis rule for a configured table association
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateConfiguredTableAssociationAnalysisRule.html
     */
    toCreateConfiguredTableAssociationAnalysisRule(): this;
    /**
     * Grants permission to link an id mapping workflow with a collaboration by creating a new id mapping table
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - entityresolution:AddPolicyStatement
     * - entityresolution:GetIdMappingWorkflow
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateIdMappingTable.html
     */
    toCreateIdMappingTable(): this;
    /**
     * Grants permission to link an AWS Entity Resolution Id Namespace with a collaboration by creating a new association
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - entityresolution:AddPolicyStatement
     * - entityresolution:GetIdNamespace
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateIdNamespaceAssociation.html
     */
    toCreateIdNamespaceAssociation(): this;
    /**
     * Grants permission to join collaborations by creating a membership
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     * - logs:CreateLogDelivery
     * - logs:CreateLogGroup
     * - logs:DeleteLogDelivery
     * - logs:DescribeLogGroups
     * - logs:DescribeResourcePolicies
     * - logs:GetLogDelivery
     * - logs:ListLogDeliveries
     * - logs:PutResourcePolicy
     * - logs:UpdateLogDelivery
     * - s3:GetBucketLocation
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateMembership.html
     */
    toCreateMembership(): this;
    /**
     * Grants permission to create a new privacy budget template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreatePrivacyBudgetTemplate.html
     */
    toCreatePrivacyBudgetTemplate(): this;
    /**
     * Grants permission to delete an existing analysis template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_DeleteAnalysisTemplate.html
     */
    toDeleteAnalysisTemplate(): this;
    /**
     * Grants permission to delete an existing collaboration
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - cleanrooms-ml:DeleteConfiguredAudienceModelPolicy
     * - cleanrooms-ml:GetConfiguredAudienceModelPolicy
     * - cleanrooms-ml:PutConfiguredAudienceModelPolicy
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_DeleteCollaboration.html
     */
    toDeleteCollaboration(): this;
    /**
     * Grants permission to delete an existing configured audience model association
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - cleanrooms-ml:DeleteConfiguredAudienceModelPolicy
     * - cleanrooms-ml:GetConfiguredAudienceModelPolicy
     * - cleanrooms-ml:PutConfiguredAudienceModelPolicy
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_DeleteConfiguredAudienceModelAssociation.html
     */
    toDeleteConfiguredAudienceModelAssociation(): this;
    /**
     * Grants permission to delete a configured table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_DeleteConfiguredTable.html
     */
    toDeleteConfiguredTable(): this;
    /**
     * Grants permission to delete an existing analysis rule
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_DeleteConfiguredTableAnalysisRule.html
     */
    toDeleteConfiguredTableAnalysisRule(): this;
    /**
     * Grants permission to remove a configured table association from a collaboration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_DeleteConfiguredTableAssociation.html
     */
    toDeleteConfiguredTableAssociation(): this;
    /**
     * Grants permission to delete an existing configured table association analysis rule
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_DeleteConfiguredTableAssociationAnalysisRule.html
     */
    toDeleteConfiguredTableAssociationAnalysisRule(): this;
    /**
     * Grants permission to remove an id mapping table from a collaboration
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - entityresolution:DeletePolicyStatement
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_DeleteIdMappingTable.html
     */
    toDeleteIdMappingTable(): this;
    /**
     * Grants permission to remove an Id Namespace Association from a collaboration
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - entityresolution:DeletePolicyStatement
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_DeleteIdNamespaceAssociation.html
     */
    toDeleteIdNamespaceAssociation(): this;
    /**
     * Grants permission to delete members from a collaboration
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - cleanrooms-ml:DeleteConfiguredAudienceModelPolicy
     * - cleanrooms-ml:GetConfiguredAudienceModelPolicy
     * - cleanrooms-ml:PutConfiguredAudienceModelPolicy
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_DeleteMember.html
     */
    toDeleteMember(): this;
    /**
     * Grants permission to leave collaborations by deleting a membership
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_DeleteMembership.html
     */
    toDeleteMembership(): this;
    /**
     * Grants permission to delete an existing privacy budget template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_DeletePrivacyBudgetTemplate.html
     */
    toDeletePrivacyBudgetTemplate(): this;
    /**
     * Grants permission to view details for an analysis template
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_GetAnalysisTemplate.html
     */
    toGetAnalysisTemplate(): this;
    /**
     * Grants permission to view details for a collaboration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_GetCollaboration.html
     */
    toGetCollaboration(): this;
    /**
     * Grants permission to view details for an analysis template within a collaboration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_GetCollaborationAnalysisTemplate.html
     */
    toGetCollaborationAnalysisTemplate(): this;
    /**
     * Grants permission to view details for a configured audience model association within a collaboration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_GetCollaborationConfiguredAudienceModelAssociation.html
     */
    toGetCollaborationConfiguredAudienceModelAssociation(): this;
    /**
     * Grants permission to get id namespace association within a collaboration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_GetCollaborationIdNamespaceAssociation.html
     */
    toGetCollaborationIdNamespaceAssociation(): this;
    /**
     * Grants permission to view details for a privacy budget template within a collaboration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_GetCollaborationPrivacyBudgetTemplate.html
     */
    toGetCollaborationPrivacyBudgetTemplate(): this;
    /**
     * Grants permission to view details for a configured audience model association
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_GetConfiguredAudienceModelAssociation.html
     */
    toGetConfiguredAudienceModelAssociation(): this;
    /**
     * Grants permission to view details for a configured table
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_GetConfiguredTable.html
     */
    toGetConfiguredTable(): this;
    /**
     * Grants permission to view analysis rules for a configured table
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_GetConfiguredTableAnalysisRule.html
     */
    toGetConfiguredTableAnalysisRule(): this;
    /**
     * Grants permission to view details for a configured table association
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_GetConfiguredTableAssociation.html
     */
    toGetConfiguredTableAssociation(): this;
    /**
     * Grants permission to view analysis rules for a configured table association
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_GetConfiguredTableAssociationAnalysisRule.html
     */
    toGetConfiguredTableAssociationAnalysisRule(): this;
    /**
     * Grants permission to view details of an id mapping table
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_GetIdMappingTable.html
     */
    toGetIdMappingTable(): this;
    /**
     * Grants permission to view details of an id namespace association
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - entityresolution:GetIdNamespace
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_GetIdNamespaceAssociation.html
     */
    toGetIdNamespaceAssociation(): this;
    /**
     * Grants permission to view details about a membership
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_GetMembership.html
     */
    toGetMembership(): this;
    /**
     * Grants permission to view details for a privacy budget template
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_GetPrivacyBudgetTemplate.html
     */
    toGetPrivacyBudgetTemplate(): this;
    /**
     * Grants permission to view a protected job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_GetProtectedJob.html
     */
    toGetProtectedJob(): this;
    /**
     * Grants permission to view a protected query
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_GetProtectedQuery.html
     */
    toGetProtectedQuery(): this;
    /**
     * Grants permission to view details for a schema
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_GetSchema.html
     */
    toGetSchema(): this;
    /**
     * Grants permission to view analysis rules associated with a schema
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - cleanrooms:GetSchema
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_GetSchemaAnalysisRule.html
     */
    toGetSchemaAnalysisRule(): this;
    /**
     * Grants permission to list available analysis templates
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_ListAnalysisTemplates.html
     */
    toListAnalysisTemplates(): this;
    /**
     * Grants permission to list available analysis templates within a collaboration
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_ListCollaborationAnalysisTemplates.html
     */
    toListCollaborationAnalysisTemplates(): this;
    /**
     * Grants permission to list available configured audience model association within a collaboration
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_ListCollaborationConfiguredAudienceModelAssociations.html
     */
    toListCollaborationConfiguredAudienceModelAssociations(): this;
    /**
     * Grants permission to list id namespace within a collaboration
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_ListCollaborationIdNamespaceAssociations.html
     */
    toListCollaborationIdNamespaceAssociations(): this;
    /**
     * Grants permission to list available privacy budget templates within a collaboration
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_ListCollaborationPrivacyBudgetTemplates.html
     */
    toListCollaborationPrivacyBudgetTemplates(): this;
    /**
     * Grants permission to list privacy budgets within a collaboration
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_ListCollaborationPrivacyBudgets.html
     */
    toListCollaborationPrivacyBudgets(): this;
    /**
     * Grants permission to list available collaborations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_ListCollaborations.html
     */
    toListCollaborations(): this;
    /**
     * Grants permission to list available configured audience model associations for a membership
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_ListConfiguredAudienceModelAssociations.html
     */
    toListConfiguredAudienceModelAssociations(): this;
    /**
     * Grants permission to list available configured table associations for a membership
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_ListConfiguredTableAssociations.html
     */
    toListConfiguredTableAssociations(): this;
    /**
     * Grants permission to list available configured tables
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_ListConfiguredTables.html
     */
    toListConfiguredTables(): this;
    /**
     * Grants permission to list available id mapping tables for a membership
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_ListIdMappingTables.html
     */
    toListIdMappingTables(): this;
    /**
     * Grants permission to list entity resolution data associations for a membership
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_ListIdNamespaceAssociations.html
     */
    toListIdNamespaceAssociations(): this;
    /**
     * Grants permission to list the members of a collaboration
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_ListMembers.html
     */
    toListMembers(): this;
    /**
     * Grants permission to list available memberships
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_ListMemberships.html
     */
    toListMemberships(): this;
    /**
     * Grants permission to list available privacy budget templates
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_ListPrivacyBudgetTemplates.html
     */
    toListPrivacyBudgetTemplates(): this;
    /**
     * Grants permission to list available privacy budgets
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_ListPrivacyBudgets.html
     */
    toListPrivacyBudgets(): this;
    /**
     * Grants permission to list protected jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_ListProtectedJobs.html
     */
    toListProtectedJobs(): this;
    /**
     * Grants permission to list protected queries
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_ListProtectedQueries.html
     */
    toListProtectedQueries(): this;
    /**
     * Grants permission to view available schemas for a collaboration
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_ListSchemas.html
     */
    toListSchemas(): this;
    /**
     * Grants permission to list tags for a resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to access a collaboration in the context of Clean Rooms ML custom models
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/userguide/ml-behaviors-byom.html#ml-behaviors-byom-membership-collaboration-access
     */
    toPassCollaboration(): this;
    /**
     * Grants permission to access a membership in the context of Clean Rooms ML custom models
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/userguide/ml-behaviors-byom.html#ml-behaviors-byom-membership-collaboration-access
     */
    toPassMembership(): this;
    /**
     * Grants permission to start an Id Mapping Job in AWS Entity Resolution to generate id mapping results in cleanrooms collaboration.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - entityresolution:GetIdMappingWorkflow
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_PopulateIdMappingTable.html
     */
    toPopulateIdMappingTable(): this;
    /**
     * Grants permission to preview privacy budget template settings
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_PreviewPrivacyImpact.html
     */
    toPreviewPrivacyImpact(): this;
    /**
     * Grants permission to start protected jobs
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - cleanrooms:GetCollaborationAnalysisTemplate
     * - cleanrooms:GetSchema
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_StartProtectedJob.html
     */
    toStartProtectedJob(): this;
    /**
     * Grants permission to start protected queries
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - cleanrooms:GetCollaborationAnalysisTemplate
     * - cleanrooms:GetSchema
     * - s3:GetBucketLocation
     * - s3:ListBucket
     * - s3:PutObject
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_StartProtectedQuery.html
     */
    toStartProtectedQuery(): this;
    /**
     * Grants permission to tag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to untag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update details of the analysis template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_UpdateAnalysisTemplate.html
     */
    toUpdateAnalysisTemplate(): this;
    /**
     * Grants permission to update details of the collaboration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_UpdateCollaboration.html
     */
    toUpdateCollaboration(): this;
    /**
     * Grants permission to update a configured audience model association
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_UpdateConfiguredAudienceModelAssociation.html
     */
    toUpdateConfiguredAudienceModelAssociation(): this;
    /**
     * Grants permission to update an existing configured table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_UpdateConfiguredTable.html
     */
    toUpdateConfiguredTable(): this;
    /**
     * Grants permission to update analysis rules for a configured table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_UpdateConfiguredTableAnalysisRule.html
     */
    toUpdateConfiguredTableAnalysisRule(): this;
    /**
     * Grants permission to update a configured table association
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_UpdateConfiguredTableAssociation.html
     */
    toUpdateConfiguredTableAssociation(): this;
    /**
     * Grants permission to update analysis rules for a configured table association
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_UpdateConfiguredTableAssociationAnalysisRule.html
     */
    toUpdateConfiguredTableAssociationAnalysisRule(): this;
    /**
     * Grants permission to update an id mapping table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_UpdateIdMappingTable.html
     */
    toUpdateIdMappingTable(): this;
    /**
     * Grants permission to update a entity resolution input association
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - entityresolution:GetIdNamespace
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_UpdateIdNamespaceAssociation.html
     */
    toUpdateIdNamespaceAssociation(): this;
    /**
     * Grants permission to update details of a membership
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     * - logs:CreateLogDelivery
     * - logs:CreateLogGroup
     * - logs:DeleteLogDelivery
     * - logs:DescribeLogGroups
     * - logs:DescribeResourcePolicies
     * - logs:GetLogDelivery
     * - logs:ListLogDeliveries
     * - logs:PutResourcePolicy
     * - logs:UpdateLogDelivery
     * - s3:GetBucketLocation
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_UpdateMembership.html
     */
    toUpdateMembership(): this;
    /**
     * Grants permission to update details of the privacy budget template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_UpdatePrivacyBudgetTemplate.html
     */
    toUpdatePrivacyBudgetTemplate(): this;
    /**
     * Grants permission to update protected jobs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_UpdateProtectedJob.html
     */
    toUpdateProtectedJob(): this;
    /**
     * Grants permission to update protected queries
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_UpdateProtectedQuery.html
     */
    toUpdateProtectedQuery(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type analysistemplate to the statement
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/userguide/security-iam.html
     *
     * @param membershipId - Identifier for the membershipId.
     * @param analysisTemplateId - Identifier for the analysisTemplateId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAnalysistemplate(membershipId: string, analysisTemplateId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type collaboration to the statement
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/userguide/security-iam.html
     *
     * @param collaborationId - Identifier for the collaborationId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onCollaboration(collaborationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type configuredaudiencemodelassociation to the statement
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/userguide/security-iam.html
     *
     * @param membershipId - Identifier for the membershipId.
     * @param configuredAudienceModelAssociationId - Identifier for the configuredAudienceModelAssociationId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onConfiguredaudiencemodelassociation(membershipId: string, configuredAudienceModelAssociationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type configuredtable to the statement
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/userguide/security-iam.html
     *
     * @param configuredTableId - Identifier for the configuredTableId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onConfiguredtable(configuredTableId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type configuredtableassociation to the statement
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/userguide/security-iam.html
     *
     * @param membershipId - Identifier for the membershipId.
     * @param configuredTableAssociationId - Identifier for the configuredTableAssociationId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onConfiguredtableassociation(membershipId: string, configuredTableAssociationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type idmappingtable to the statement
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/userguide/security-iam.html
     *
     * @param membershipId - Identifier for the membershipId.
     * @param idMappingTableId - Identifier for the idMappingTableId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onIdmappingtable(membershipId: string, idMappingTableId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type idnamespaceassociation to the statement
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/userguide/security-iam.html
     *
     * @param membershipId - Identifier for the membershipId.
     * @param idNamespaceAssociationId - Identifier for the idNamespaceAssociationId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onIdnamespaceassociation(membershipId: string, idNamespaceAssociationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type membership to the statement
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/userguide/security-iam.html
     *
     * @param membershipId - Identifier for the membershipId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onMembership(membershipId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type privacybudgettemplate to the statement
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/userguide/security-iam.html
     *
     * @param membershipId - Identifier for the membershipId.
     * @param privacyBudgetTemplateId - Identifier for the privacyBudgetTemplateId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onPrivacybudgettemplate(membershipId: string, privacyBudgetTemplateId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the tags that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateAnalysisTemplate()
     * - .toCreateCollaboration()
     * - .toCreateConfiguredAudienceModelAssociation()
     * - .toCreateConfiguredTable()
     * - .toCreateConfiguredTableAssociation()
     * - .toCreateConfiguredTableAssociationAnalysisRule()
     * - .toCreateIdMappingTable()
     * - .toCreateIdNamespaceAssociation()
     * - .toCreateMembership()
     * - .toCreatePrivacyBudgetTemplate()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tags associated with the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to actions:
     * - .toCreateAnalysisTemplate()
     * - .toCreateCollaboration()
     * - .toCreateConfiguredAudienceModelAssociation()
     * - .toCreateConfiguredTable()
     * - .toCreateConfiguredTableAssociation()
     * - .toCreateConfiguredTableAssociationAnalysisRule()
     * - .toCreateIdMappingTable()
     * - .toCreateIdNamespaceAssociation()
     * - .toCreateMembership()
     * - .toCreatePrivacyBudgetTemplate()
     *
     * Applies to resource types:
     * - analysistemplate
     * - collaboration
     * - configuredaudiencemodelassociation
     * - configuredtable
     * - configuredtableassociation
     * - idmappingtable
     * - idnamespaceassociation
     * - membership
     * - privacybudgettemplate
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tag keys that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateAnalysisTemplate()
     * - .toCreateCollaboration()
     * - .toCreateConfiguredAudienceModelAssociation()
     * - .toCreateConfiguredTable()
     * - .toCreateConfiguredTableAssociation()
     * - .toCreateConfiguredTableAssociationAnalysisRule()
     * - .toCreateIdMappingTable()
     * - .toCreateIdNamespaceAssociation()
     * - .toCreateMembership()
     * - .toCreatePrivacyBudgetTemplate()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [cleanrooms](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscleanrooms.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
