import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [cleanrooms-ml](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscleanroomsml.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class CleanroomsMl extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to cancel a trained model
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_CancelTrainedModel.html
     */
    toCancelTrainedModel(): this;
    /**
     * Grants permission to cancel a trained model inference job
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_CancelTrainedModelInferenceJob.html
     */
    toCancelTrainedModelInferenceJob(): this;
    /**
     * Grants permission to create an audience model
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_CreateAudienceModel.html
     */
    toCreateAudienceModel(): this;
    /**
     * Grants permission to create a configured audience model
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_CreateConfiguredAudienceModel.html
     */
    toCreateConfiguredAudienceModel(): this;
    /**
     * Grants permission to create a configured model algorithm
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_CreateConfiguredModelAlgorithm.html
     */
    toCreateConfiguredModelAlgorithm(): this;
    /**
     * Grants permission to create a configured model algorithm association
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_CreateConfiguredModelAlgorithmAssociation.html
     */
    toCreateConfiguredModelAlgorithmAssociation(): this;
    /**
     * Grants permission to create an ML input channel
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_CreateMLInputChannel.html
     */
    toCreateMLInputChannel(): this;
    /**
     * Grants permission to create a trained model
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_CreateTrainedModel.html
     */
    toCreateTrainedModel(): this;
    /**
     * Grants permission to create a training dataset, or seed audience. In Clean Rooms ML, the TrainingDataset is metadata that points to a Glue table, which is read only during AudienceModel creation
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_CreateTrainingDataset.html
     */
    toCreateTrainingDataset(): this;
    /**
     * Grants permission to delete the specified audience generation job, and removes all data associated with the job
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_DeleteAudienceGenerationJob.html
     */
    toDeleteAudienceGenerationJob(): this;
    /**
     * Grants permission to delete the specified audience generation job, and removes all data associated with the job
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_DeleteAudienceModel.html
     */
    toDeleteAudienceModel(): this;
    /**
     * Grants permission to delete the specified configured audience model
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_DeleteConfiguredAudienceModel.html
     */
    toDeleteConfiguredAudienceModel(): this;
    /**
     * Grants permission to delete the specified configured audience model policy
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_DeleteConfiguredAudienceModelPolicy.html
     */
    toDeleteConfiguredAudienceModelPolicy(): this;
    /**
     * Grants permission to delete a configured model algorithm
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_DeleteConfiguredModelAlgorithm.html
     */
    toDeleteConfiguredModelAlgorithm(): this;
    /**
     * Grants permission to delete a configured model algorithm association
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_DeleteConfiguredModelAlgorithmAssociation.html
     */
    toDeleteConfiguredModelAlgorithmAssociation(): this;
    /**
     * Grants permission to delete an ML configuration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_DeleteMLConfiguration.html
     */
    toDeleteMLConfiguration(): this;
    /**
     * Grants permission to delete all data associated with the ML input channel
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_DeleteMLInputChannelData.html
     */
    toDeleteMLInputChannelData(): this;
    /**
     * Grants permission to delete all output associated with the trained model
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_DeleteTrainedModelOutput.html
     */
    toDeleteTrainedModelOutput(): this;
    /**
     * Grants permission to delete a training dataset
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_DeleteTrainingDataset.html
     */
    toDeleteTrainingDataset(): this;
    /**
     * Grants permission to return information about an audience generation job
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_GetAudienceGenerationJob.html
     */
    toGetAudienceGenerationJob(): this;
    /**
     * Grants permission to return information about an audience model
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_GetAudienceModel.html
     */
    toGetAudienceModel(): this;
    /**
     * Grants permission to return information about a configured model algorithm association created by any member in the collaboration
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifCollaborationId()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_GetCollaborationConfiguredModelAlgorithmAssociation.html
     */
    toGetCollaborationConfiguredModelAlgorithmAssociation(): this;
    /**
     * Grants permission to return information about an ML input channel created by any member in the collaboration
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifCollaborationId()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_GetCollaborationMLInputChannel.html
     */
    toGetCollaborationMLInputChannel(): this;
    /**
     * Grants permission to return information about a trained model created by any member in the collaboration
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifCollaborationId()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_GetCollaborationTrainedModel.html
     */
    toGetCollaborationTrainedModel(): this;
    /**
     * Grants permission to return information about a configured audience model
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_GetConfiguredAudienceModel.html
     */
    toGetConfiguredAudienceModel(): this;
    /**
     * Grants permission to return information about a configured audience model policy
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_GetConfiguredAudienceModelPolicy.html
     */
    toGetConfiguredAudienceModelPolicy(): this;
    /**
     * Grants permission to return information about a configured model algorithm
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_GetConfiguredModelAlgorithm.html
     */
    toGetConfiguredModelAlgorithm(): this;
    /**
     * Grants permission to return information about a configured model algorithm association
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_GetConfiguredModelAlgorithmAssociation.html
     */
    toGetConfiguredModelAlgorithmAssociation(): this;
    /**
     * Grants permission to return information about an ML configuration
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_GetMLConfiguration.html
     */
    toGetMLConfiguration(): this;
    /**
     * Grants permission to return information about an ML input channel
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_GetMLInputChannel.html
     */
    toGetMLInputChannel(): this;
    /**
     * Grants permission to return information about a trained model
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_GetTrainedModel.html
     */
    toGetTrainedModel(): this;
    /**
     * Grants permission to return information about a trained model inference job
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_GetTrainedModelInferenceJob.html
     */
    toGetTrainedModelInferenceJob(): this;
    /**
     * Grants permission to return information about a training dataset
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_GetTrainingDataset.html
     */
    toGetTrainingDataset(): this;
    /**
     * Grants permission to return a list of the audience export jobs
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_ListAudienceExportJobs.html
     */
    toListAudienceExportJobs(): this;
    /**
     * Grants permission to return a list of audience generation jobs
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_ListAudienceGenerationJobs.html
     */
    toListAudienceGenerationJobs(): this;
    /**
     * Grants permission to return a list of audience models
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_ListAudienceModels.html
     */
    toListAudienceModels(): this;
    /**
     * Grants permission to return a list of configured model algorithms created by any member in the collaboration
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifCollaborationId()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_ListCollaborationConfiguredModelAlgorithmAssociations.html
     */
    toListCollaborationConfiguredModelAlgorithmAssociations(): this;
    /**
     * Grants permission to return a list of ML input channels created by any member in the collaboration
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifCollaborationId()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_ListCollaborationMLInputChannels.html
     */
    toListCollaborationMLInputChannels(): this;
    /**
     * Grants permission to return a list of trained model export jobs started by any member in the collaboration
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifCollaborationId()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_ListCollaborationTrainedModelExportJobs.html
     */
    toListCollaborationTrainedModelExportJobs(): this;
    /**
     * Grants permission to return a list of trained model inference jobs started by any member in the collaboration
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifCollaborationId()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_ListCollaborationTrainedModelInferenceJobs.html
     */
    toListCollaborationTrainedModelInferenceJobs(): this;
    /**
     * Grants permission to return a list of trained models created by any member in the collaboration
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifCollaborationId()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_ListCollaborationTrainedModels.html
     */
    toListCollaborationTrainedModels(): this;
    /**
     * Grants permission to return a list of configured audience models
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_ListConfiguredAudienceModels.html
     */
    toListConfiguredAudienceModels(): this;
    /**
     * Grants permission to return a list of configured model algorithm associations
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_ListConfiguredModelAlgorithmAssociations.html
     */
    toListConfiguredModelAlgorithmAssociations(): this;
    /**
     * Grants permission to return a list of configured model algorithms
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_ListConfiguredModelAlgorithms.html
     */
    toListConfiguredModelAlgorithms(): this;
    /**
     * Grants permission to return a list of ML input channels
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_ListMLInputChannels.html
     */
    toListMLInputChannels(): this;
    /**
     * Grants permission to return a list of tags for a provided resource
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to return a list of trained model inference jobs
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_ListTrainedModelInferenceJobs.html
     */
    toListTrainedModelInferenceJobs(): this;
    /**
     * Grants permission to return a list of trained models
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_ListTrainedModels.html
     */
    toListTrainedModels(): this;
    /**
     * Grants permission to return a list of training datasets
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_ListTrainingDatasets.html
     */
    toListTrainingDatasets(): this;
    /**
     * Grants permission to create or update the resource policy for a configured audience model
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_PutConfiguredAudienceModelPolicy.html
     */
    toPutConfiguredAudienceModelPolicy(): this;
    /**
     * Grants permission to put an ML configuration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_PutMLConfiguration.html
     */
    toPutMLConfiguration(): this;
    /**
     * Grants permission to export an audience of a specified size after you have generated an audience
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_StartAudienceExportJob.html
     */
    toStartAudienceExportJob(): this;
    /**
     * Grants permission to start the audience generation job
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifCollaborationId()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_StartAudienceGenerationJob.html
     */
    toStartAudienceGenerationJob(): this;
    /**
     * Grants permission to start a trained model export job
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_StartTrainedModelExportJob.html
     */
    toStartTrainedModelExportJob(): this;
    /**
     * Grants permission to start a trained model inference job
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_StartTrainedModelInferenceJob.html
     */
    toStartTrainedModelInferenceJob(): this;
    /**
     * Grants permission to tag a specific resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to untag a specific resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_UntagResource.html
     */
    toUnTagResource(): this;
    /**
     * Grants permission to update a configured audience model.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cleanrooms-ml/latest/APIReference/API_UpdateConfiguredAudienceModel.html
     */
    toUpdateConfiguredAudienceModel(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type trainingdataset to the statement
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onTrainingdataset(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type audiencemodel to the statement
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAudiencemodel(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type configuredaudiencemodel to the statement
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onConfiguredaudiencemodel(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type audiencegenerationjob to the statement
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAudiencegenerationjob(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type ConfiguredModelAlgorithm to the statement
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onConfiguredModelAlgorithm(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type ConfiguredModelAlgorithmAssociation to the statement
     *
     * @param membershipId - Identifier for the membershipId.
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onConfiguredModelAlgorithmAssociation(membershipId: string, resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type MLInputChannel to the statement
     *
     * @param membershipId - Identifier for the membershipId.
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onMLInputChannel(membershipId: string, resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type TrainedModel to the statement
     *
     * @param membershipId - Identifier for the membershipId.
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onTrainedModel(membershipId: string, resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type TrainedModelInferenceJob to the statement
     *
     * @param membershipId - Identifier for the membershipId.
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onTrainedModelInferenceJob(membershipId: string, resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the presence of tag key-value pairs in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCancelTrainedModel()
     * - .toCancelTrainedModelInferenceJob()
     * - .toCreateAudienceModel()
     * - .toCreateConfiguredAudienceModel()
     * - .toCreateConfiguredModelAlgorithm()
     * - .toCreateConfiguredModelAlgorithmAssociation()
     * - .toCreateMLInputChannel()
     * - .toCreateTrainedModel()
     * - .toCreateTrainingDataset()
     * - .toDeleteAudienceGenerationJob()
     * - .toDeleteAudienceModel()
     * - .toDeleteConfiguredAudienceModel()
     * - .toDeleteConfiguredAudienceModelPolicy()
     * - .toDeleteConfiguredModelAlgorithm()
     * - .toDeleteConfiguredModelAlgorithmAssociation()
     * - .toDeleteMLConfiguration()
     * - .toDeleteMLInputChannelData()
     * - .toDeleteTrainedModelOutput()
     * - .toDeleteTrainingDataset()
     * - .toGetAudienceGenerationJob()
     * - .toGetAudienceModel()
     * - .toGetCollaborationConfiguredModelAlgorithmAssociation()
     * - .toGetCollaborationMLInputChannel()
     * - .toGetCollaborationTrainedModel()
     * - .toGetConfiguredAudienceModel()
     * - .toGetConfiguredAudienceModelPolicy()
     * - .toGetConfiguredModelAlgorithm()
     * - .toGetConfiguredModelAlgorithmAssociation()
     * - .toGetMLConfiguration()
     * - .toGetMLInputChannel()
     * - .toGetTrainedModel()
     * - .toGetTrainedModelInferenceJob()
     * - .toGetTrainingDataset()
     * - .toListAudienceExportJobs()
     * - .toListAudienceGenerationJobs()
     * - .toListCollaborationConfiguredModelAlgorithmAssociations()
     * - .toListCollaborationMLInputChannels()
     * - .toListCollaborationTrainedModelExportJobs()
     * - .toListCollaborationTrainedModelInferenceJobs()
     * - .toListCollaborationTrainedModels()
     * - .toListConfiguredModelAlgorithmAssociations()
     * - .toListConfiguredModelAlgorithms()
     * - .toListMLInputChannels()
     * - .toListTrainedModelInferenceJobs()
     * - .toListTrainedModels()
     * - .toPutMLConfiguration()
     * - .toStartAudienceExportJob()
     * - .toStartAudienceGenerationJob()
     * - .toStartTrainedModelExportJob()
     * - .toStartTrainedModelInferenceJob()
     * - .toTagResource()
     * - .toUpdateConfiguredAudienceModel()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by tag key-value pairs attached to the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to actions:
     * - .toListTagsForResource()
     * - .toTagResource()
     * - .toUnTagResource()
     *
     * Applies to resource types:
     * - trainingdataset
     * - audiencemodel
     * - configuredaudiencemodel
     * - audiencegenerationjob
     * - ConfiguredModelAlgorithm
     * - ConfiguredModelAlgorithmAssociation
     * - MLInputChannel
     * - TrainedModel
     * - TrainedModelInferenceJob
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the presence of tag keys in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCancelTrainedModel()
     * - .toCancelTrainedModelInferenceJob()
     * - .toCreateAudienceModel()
     * - .toCreateConfiguredAudienceModel()
     * - .toCreateConfiguredModelAlgorithm()
     * - .toCreateConfiguredModelAlgorithmAssociation()
     * - .toCreateMLInputChannel()
     * - .toCreateTrainedModel()
     * - .toCreateTrainingDataset()
     * - .toDeleteAudienceGenerationJob()
     * - .toDeleteAudienceModel()
     * - .toDeleteConfiguredAudienceModel()
     * - .toDeleteConfiguredAudienceModelPolicy()
     * - .toDeleteConfiguredModelAlgorithm()
     * - .toDeleteConfiguredModelAlgorithmAssociation()
     * - .toDeleteMLConfiguration()
     * - .toDeleteMLInputChannelData()
     * - .toDeleteTrainedModelOutput()
     * - .toDeleteTrainingDataset()
     * - .toGetAudienceGenerationJob()
     * - .toGetAudienceModel()
     * - .toGetCollaborationConfiguredModelAlgorithmAssociation()
     * - .toGetCollaborationMLInputChannel()
     * - .toGetCollaborationTrainedModel()
     * - .toGetConfiguredAudienceModel()
     * - .toGetConfiguredAudienceModelPolicy()
     * - .toGetConfiguredModelAlgorithm()
     * - .toGetConfiguredModelAlgorithmAssociation()
     * - .toGetMLConfiguration()
     * - .toGetMLInputChannel()
     * - .toGetTrainedModel()
     * - .toGetTrainedModelInferenceJob()
     * - .toGetTrainingDataset()
     * - .toListAudienceExportJobs()
     * - .toListAudienceGenerationJobs()
     * - .toListCollaborationConfiguredModelAlgorithmAssociations()
     * - .toListCollaborationMLInputChannels()
     * - .toListCollaborationTrainedModelExportJobs()
     * - .toListCollaborationTrainedModelInferenceJobs()
     * - .toListCollaborationTrainedModels()
     * - .toListConfiguredModelAlgorithmAssociations()
     * - .toListConfiguredModelAlgorithms()
     * - .toListMLInputChannels()
     * - .toListTagsForResource()
     * - .toListTrainedModelInferenceJobs()
     * - .toListTrainedModels()
     * - .toPutMLConfiguration()
     * - .toStartAudienceExportJob()
     * - .toStartAudienceGenerationJob()
     * - .toStartTrainedModelExportJob()
     * - .toStartTrainedModelInferenceJob()
     * - .toTagResource()
     * - .toUnTagResource()
     * - .toUpdateConfiguredAudienceModel()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by Clean rooms collaboration id
     *
     * https://docs.aws.amazon.com/TBD
     *
     * Applies to actions:
     * - .toGetCollaborationConfiguredModelAlgorithmAssociation()
     * - .toGetCollaborationMLInputChannel()
     * - .toGetCollaborationTrainedModel()
     * - .toListCollaborationConfiguredModelAlgorithmAssociations()
     * - .toListCollaborationMLInputChannels()
     * - .toListCollaborationTrainedModelExportJobs()
     * - .toListCollaborationTrainedModelInferenceJobs()
     * - .toListCollaborationTrainedModels()
     * - .toStartAudienceGenerationJob()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifCollaborationId(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [cleanrooms-ml](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscleanroomsml.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
