"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cloudsearch = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [cloudsearch](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudsearch.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Cloudsearch extends shared_1.PolicyStatement {
    /**
     * Attaches resource tags to an Amazon CloudSearch domain
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_AddTags.html
     */
    toAddTags() {
        return this.to('AddTags');
    }
    /**
     * Indexes the search suggestions
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_BuildSuggesters.html
     */
    toBuildSuggesters() {
        return this.to('BuildSuggesters');
    }
    /**
     * Creates a new search domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_CreateDomain.html
     */
    toCreateDomain() {
        return this.to('CreateDomain');
    }
    /**
     * Configures an analysis scheme that can be applied to a text or text-array field to define language-specific text processing options
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DefineAnalysisScheme.html
     */
    toDefineAnalysisScheme() {
        return this.to('DefineAnalysisScheme');
    }
    /**
     * Configures an Expression for the search domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DefineExpression.html
     */
    toDefineExpression() {
        return this.to('DefineExpression');
    }
    /**
     * Configures an IndexField for the search domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DefineIndexField.html
     */
    toDefineIndexField() {
        return this.to('DefineIndexField');
    }
    /**
     * Configures a suggester for a domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DefineSuggester.html
     */
    toDefineSuggester() {
        return this.to('DefineSuggester');
    }
    /**
     * Deletes an analysis scheme
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DeleteAnalysisScheme.html
     */
    toDeleteAnalysisScheme() {
        return this.to('DeleteAnalysisScheme');
    }
    /**
     * Permanently deletes a search domain and all of its data
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DeleteDomain.html
     */
    toDeleteDomain() {
        return this.to('DeleteDomain');
    }
    /**
     * Removes an Expression from the search domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DeleteExpression.html
     */
    toDeleteExpression() {
        return this.to('DeleteExpression');
    }
    /**
     * Removes an IndexField from the search domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DeleteIndexField.html
     */
    toDeleteIndexField() {
        return this.to('DeleteIndexField');
    }
    /**
     * Deletes a suggester
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DeleteSuggester.html
     */
    toDeleteSuggester() {
        return this.to('DeleteSuggester');
    }
    /**
     * Gets the analysis schemes configured for a domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DescribeAnalysisSchemes.html
     */
    toDescribeAnalysisSchemes() {
        return this.to('DescribeAnalysisSchemes');
    }
    /**
     * Gets the availability options configured for a domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DescribeAvailabilityOptions.html
     */
    toDescribeAvailabilityOptions() {
        return this.to('DescribeAvailabilityOptions');
    }
    /**
     * Gets the domain endpoint options configured for a domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DescribeDomainEndpointOptions.html
     */
    toDescribeDomainEndpointOptions() {
        return this.to('DescribeDomainEndpointOptions');
    }
    /**
     * Gets information about the search domains owned by this account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DescribeDomains.html
     */
    toDescribeDomains() {
        return this.to('DescribeDomains');
    }
    /**
     * Gets the expressions configured for the search domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DescribeExpressions.html
     */
    toDescribeExpressions() {
        return this.to('DescribeExpressions');
    }
    /**
     * Gets information about the index fields configured for the search domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DescribeIndexFields.html
     */
    toDescribeIndexFields() {
        return this.to('DescribeIndexFields');
    }
    /**
     * Gets the scaling parameters configured for a domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DescribeScalingParameters.html
     */
    toDescribeScalingParameters() {
        return this.to('DescribeScalingParameters');
    }
    /**
     * Gets information about the access policies that control access to the domain's document and search endpoints
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DescribeServiceAccessPolicies.html
     */
    toDescribeServiceAccessPolicies() {
        return this.to('DescribeServiceAccessPolicies');
    }
    /**
     * Gets the suggesters configured for a domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DescribeSuggesters.html
     */
    toDescribeSuggesters() {
        return this.to('DescribeSuggesters');
    }
    /**
     * Tells the search domain to start indexing its documents using the latest indexing options
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_IndexDocuments.html
     */
    toIndexDocuments() {
        return this.to('IndexDocuments');
    }
    /**
     * Lists all search domains owned by an account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_ListDomainNames.html
     */
    toListDomainNames() {
        return this.to('ListDomainNames');
    }
    /**
     * Displays all of the resource tags for an Amazon CloudSearch domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_ListTags.html
     */
    toListTags() {
        return this.to('ListTags');
    }
    /**
     * Removes the specified resource tags from an Amazon ES domain
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_RemoveTags.html
     */
    toRemoveTags() {
        return this.to('RemoveTags');
    }
    /**
     * Configures the availability options for a domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_UpdateAvailabilityOptions.html
     */
    toUpdateAvailabilityOptions() {
        return this.to('UpdateAvailabilityOptions');
    }
    /**
     * Configures the domain endpoint options for a domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_UpdateDomainEndpointOptions.html
     */
    toUpdateDomainEndpointOptions() {
        return this.to('UpdateDomainEndpointOptions');
    }
    /**
     * Configures scaling parameters for a domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_UpdateScalingParameters.html
     */
    toUpdateScalingParameters() {
        return this.to('UpdateScalingParameters');
    }
    /**
     * Configures the access rules that control access to the domain's document and search endpoints
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_UpdateServiceAccessPolicies.html
     */
    toUpdateServiceAccessPolicies() {
        return this.to('UpdateServiceAccessPolicies');
    }
    /**
     * Allows access to the document service operations
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html#cloudsearch-actions
     */
    toDocument() {
        return this.to('document');
    }
    /**
     * Allows access to the search operations
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html#cloudsearch-actions
     */
    toSearch() {
        return this.to('search');
    }
    /**
     * Allows access to the suggest operations
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html#cloudsearch-actions
     */
    toSuggest() {
        return this.to('suggest');
    }
    /**
     * Adds a resource of type domain to the statement
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/creating-domains.html
     *
     * @param domainName - Identifier for the domainName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onDomain(domainName, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:cloudsearch:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:domain/${domainName}`);
    }
    /**
     * Statement provider for service [cloudsearch](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudsearch.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'cloudsearch';
        this.accessLevelList = {
            Tagging: [
                'AddTags',
                'RemoveTags'
            ],
            Write: [
                'BuildSuggesters',
                'CreateDomain',
                'DefineAnalysisScheme',
                'DefineExpression',
                'DefineIndexField',
                'DefineSuggester',
                'DeleteAnalysisScheme',
                'DeleteDomain',
                'DeleteExpression',
                'DeleteIndexField',
                'DeleteSuggester',
                'IndexDocuments',
                'UpdateAvailabilityOptions',
                'UpdateDomainEndpointOptions',
                'UpdateScalingParameters',
                'document'
            ],
            Read: [
                'DescribeAnalysisSchemes',
                'DescribeAvailabilityOptions',
                'DescribeDomainEndpointOptions',
                'DescribeExpressions',
                'DescribeIndexFields',
                'DescribeScalingParameters',
                'DescribeServiceAccessPolicies',
                'DescribeSuggesters',
                'ListTags',
                'search',
                'suggest'
            ],
            List: [
                'DescribeDomains',
                'ListDomainNames'
            ],
            'Permissions management': [
                'UpdateServiceAccessPolicies'
            ]
        };
    }
}
exports.Cloudsearch = Cloudsearch;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2xvdWRzZWFyY2guanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJjbG91ZHNlYXJjaC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFDQSx5Q0FBK0M7QUFHL0M7Ozs7R0FJRztBQUNILE1BQWEsV0FBWSxTQUFRLHdCQUFlO0lBRzlDOzs7Ozs7T0FNRztJQUNJLFNBQVM7UUFDZCxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDNUIsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGlCQUFpQjtRQUN0QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsaUJBQWlCLENBQUMsQ0FBQztJQUNwQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksY0FBYztRQUNuQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsY0FBYyxDQUFDLENBQUM7SUFDakMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHNCQUFzQjtRQUMzQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsc0JBQXNCLENBQUMsQ0FBQztJQUN6QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksa0JBQWtCO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO0lBQ3JDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxrQkFBa0I7UUFDdkIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGtCQUFrQixDQUFDLENBQUM7SUFDckMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGlCQUFpQjtRQUN0QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsaUJBQWlCLENBQUMsQ0FBQztJQUNwQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksc0JBQXNCO1FBQzNCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO0lBQ3pDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxjQUFjO1FBQ25CLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxjQUFjLENBQUMsQ0FBQztJQUNqQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksa0JBQWtCO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO0lBQ3JDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxrQkFBa0I7UUFDdkIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGtCQUFrQixDQUFDLENBQUM7SUFDckMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGlCQUFpQjtRQUN0QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsaUJBQWlCLENBQUMsQ0FBQztJQUNwQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0kseUJBQXlCO1FBQzlCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyx5QkFBeUIsQ0FBQyxDQUFDO0lBQzVDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSw2QkFBNkI7UUFDbEMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDZCQUE2QixDQUFDLENBQUM7SUFDaEQsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLCtCQUErQjtRQUNwQyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsK0JBQStCLENBQUMsQ0FBQztJQUNsRCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksaUJBQWlCO1FBQ3RCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDO0lBQ3BDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxxQkFBcUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHFCQUFxQixDQUFDLENBQUM7SUFDeEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHFCQUFxQjtRQUMxQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMscUJBQXFCLENBQUMsQ0FBQztJQUN4QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksMkJBQTJCO1FBQ2hDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQywyQkFBMkIsQ0FBQyxDQUFDO0lBQzlDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSwrQkFBK0I7UUFDcEMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLCtCQUErQixDQUFDLENBQUM7SUFDbEQsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLG9CQUFvQjtRQUN6QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsb0JBQW9CLENBQUMsQ0FBQztJQUN2QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksZ0JBQWdCO1FBQ3JCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO0lBQ25DLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxpQkFBaUI7UUFDdEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGlCQUFpQixDQUFDLENBQUM7SUFDcEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLFVBQVU7UUFDZixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDN0IsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLFlBQVk7UUFDakIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLFlBQVksQ0FBQyxDQUFDO0lBQy9CLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSwyQkFBMkI7UUFDaEMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDJCQUEyQixDQUFDLENBQUM7SUFDOUMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLDZCQUE2QjtRQUNsQyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsNkJBQTZCLENBQUMsQ0FBQztJQUNoRCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0kseUJBQXlCO1FBQzlCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyx5QkFBeUIsQ0FBQyxDQUFDO0lBQzVDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSw2QkFBNkI7UUFDbEMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDZCQUE2QixDQUFDLENBQUM7SUFDaEQsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLFVBQVU7UUFDZixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDN0IsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLFFBQVE7UUFDYixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsUUFBUSxDQUFDLENBQUM7SUFDM0IsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLFNBQVM7UUFDZCxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDNUIsQ0FBQztJQStDRDs7Ozs7Ozs7O09BU0c7SUFDSSxRQUFRLENBQUMsVUFBa0IsRUFBRSxPQUFnQixFQUFFLE1BQWUsRUFBRSxTQUFrQjtRQUN2RixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsT0FBUSxTQUFTLElBQUksSUFBSSxDQUFDLGdCQUFpQixnQkFBaUIsTUFBTSxJQUFJLElBQUksQ0FBQyxhQUFjLElBQUssT0FBTyxJQUFJLElBQUksQ0FBQyxjQUFlLFdBQVksVUFBVyxFQUFFLENBQUMsQ0FBQztJQUN6SyxDQUFDO0lBRUQ7OztPQUdHO0lBQ0gsWUFBWSxLQUFnQztRQUMxQyxLQUFLLENBQUMsS0FBSyxDQUFDLENBQUM7UUFsYVIsa0JBQWEsR0FBRyxhQUFhLENBQUM7UUFrVzNCLG9CQUFlLEdBQW9CO1lBQzNDLE9BQU8sRUFBRTtnQkFDUCxTQUFTO2dCQUNULFlBQVk7YUFDYjtZQUNELEtBQUssRUFBRTtnQkFDTCxpQkFBaUI7Z0JBQ2pCLGNBQWM7Z0JBQ2Qsc0JBQXNCO2dCQUN0QixrQkFBa0I7Z0JBQ2xCLGtCQUFrQjtnQkFDbEIsaUJBQWlCO2dCQUNqQixzQkFBc0I7Z0JBQ3RCLGNBQWM7Z0JBQ2Qsa0JBQWtCO2dCQUNsQixrQkFBa0I7Z0JBQ2xCLGlCQUFpQjtnQkFDakIsZ0JBQWdCO2dCQUNoQiwyQkFBMkI7Z0JBQzNCLDZCQUE2QjtnQkFDN0IseUJBQXlCO2dCQUN6QixVQUFVO2FBQ1g7WUFDRCxJQUFJLEVBQUU7Z0JBQ0oseUJBQXlCO2dCQUN6Qiw2QkFBNkI7Z0JBQzdCLCtCQUErQjtnQkFDL0IscUJBQXFCO2dCQUNyQixxQkFBcUI7Z0JBQ3JCLDJCQUEyQjtnQkFDM0IsK0JBQStCO2dCQUMvQixvQkFBb0I7Z0JBQ3BCLFVBQVU7Z0JBQ1YsUUFBUTtnQkFDUixTQUFTO2FBQ1Y7WUFDRCxJQUFJLEVBQUU7Z0JBQ0osaUJBQWlCO2dCQUNqQixpQkFBaUI7YUFDbEI7WUFDRCx3QkFBd0IsRUFBRTtnQkFDeEIsNkJBQTZCO2FBQzlCO1NBQ0YsQ0FBQztJQXNCRixDQUFDO0NBQ0Y7QUFyYUQsa0NBcWFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQWNjZXNzTGV2ZWxMaXN0IH0gZnJvbSAnLi4vLi4vc2hhcmVkL2FjY2Vzcy1sZXZlbCc7XG5pbXBvcnQgeyBQb2xpY3lTdGF0ZW1lbnQgfSBmcm9tICcuLi8uLi9zaGFyZWQnO1xuaW1wb3J0IHsgYXdzX2lhbSBhcyBpYW0gfSBmcm9tIFwiYXdzLWNkay1saWJcIjtcblxuLyoqXG4gKiBTdGF0ZW1lbnQgcHJvdmlkZXIgZm9yIHNlcnZpY2UgW2Nsb3Vkc2VhcmNoXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vc2VydmljZS1hdXRob3JpemF0aW9uL2xhdGVzdC9yZWZlcmVuY2UvbGlzdF9hbWF6b25jbG91ZHNlYXJjaC5odG1sKS5cbiAqXG4gKiBAcGFyYW0gc2lkIFtTSURdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9JQU0vbGF0ZXN0L1VzZXJHdWlkZS9yZWZlcmVuY2VfcG9saWNpZXNfZWxlbWVudHNfc2lkLmh0bWwpIG9mIHRoZSBzdGF0ZW1lbnRcbiAqL1xuZXhwb3J0IGNsYXNzIENsb3Vkc2VhcmNoIGV4dGVuZHMgUG9saWN5U3RhdGVtZW50IHtcbiAgcHVibGljIHNlcnZpY2VQcmVmaXggPSAnY2xvdWRzZWFyY2gnO1xuXG4gIC8qKlxuICAgKiBBdHRhY2hlcyByZXNvdXJjZSB0YWdzIHRvIGFuIEFtYXpvbiBDbG91ZFNlYXJjaCBkb21haW5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBUYWdnaW5nXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jbG91ZHNlYXJjaC9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvQVBJX0FkZFRhZ3MuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQWRkVGFncygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQWRkVGFncycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEluZGV4ZXMgdGhlIHNlYXJjaCBzdWdnZXN0aW9uc1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jbG91ZHNlYXJjaC9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvQVBJX0J1aWxkU3VnZ2VzdGVycy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9CdWlsZFN1Z2dlc3RlcnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0J1aWxkU3VnZ2VzdGVycycpO1xuICB9XG5cbiAgLyoqXG4gICAqIENyZWF0ZXMgYSBuZXcgc2VhcmNoIGRvbWFpblxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jbG91ZHNlYXJjaC9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvQVBJX0NyZWF0ZURvbWFpbi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9DcmVhdGVEb21haW4oKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0NyZWF0ZURvbWFpbicpO1xuICB9XG5cbiAgLyoqXG4gICAqIENvbmZpZ3VyZXMgYW4gYW5hbHlzaXMgc2NoZW1lIHRoYXQgY2FuIGJlIGFwcGxpZWQgdG8gYSB0ZXh0IG9yIHRleHQtYXJyYXkgZmllbGQgdG8gZGVmaW5lIGxhbmd1YWdlLXNwZWNpZmljIHRleHQgcHJvY2Vzc2luZyBvcHRpb25zXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2Nsb3Vkc2VhcmNoL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9BUElfRGVmaW5lQW5hbHlzaXNTY2hlbWUuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVmaW5lQW5hbHlzaXNTY2hlbWUoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0RlZmluZUFuYWx5c2lzU2NoZW1lJyk7XG4gIH1cblxuICAvKipcbiAgICogQ29uZmlndXJlcyBhbiBFeHByZXNzaW9uIGZvciB0aGUgc2VhcmNoIGRvbWFpblxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jbG91ZHNlYXJjaC9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvQVBJX0RlZmluZUV4cHJlc3Npb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVmaW5lRXhwcmVzc2lvbigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVmaW5lRXhwcmVzc2lvbicpO1xuICB9XG5cbiAgLyoqXG4gICAqIENvbmZpZ3VyZXMgYW4gSW5kZXhGaWVsZCBmb3IgdGhlIHNlYXJjaCBkb21haW5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY2xvdWRzZWFyY2gvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL0FQSV9EZWZpbmVJbmRleEZpZWxkLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0RlZmluZUluZGV4RmllbGQoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0RlZmluZUluZGV4RmllbGQnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBDb25maWd1cmVzIGEgc3VnZ2VzdGVyIGZvciBhIGRvbWFpblxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jbG91ZHNlYXJjaC9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvQVBJX0RlZmluZVN1Z2dlc3Rlci5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZWZpbmVTdWdnZXN0ZXIoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0RlZmluZVN1Z2dlc3RlcicpO1xuICB9XG5cbiAgLyoqXG4gICAqIERlbGV0ZXMgYW4gYW5hbHlzaXMgc2NoZW1lXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2Nsb3Vkc2VhcmNoL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9BUElfRGVsZXRlQW5hbHlzaXNTY2hlbWUuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVsZXRlQW5hbHlzaXNTY2hlbWUoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0RlbGV0ZUFuYWx5c2lzU2NoZW1lJyk7XG4gIH1cblxuICAvKipcbiAgICogUGVybWFuZW50bHkgZGVsZXRlcyBhIHNlYXJjaCBkb21haW4gYW5kIGFsbCBvZiBpdHMgZGF0YVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jbG91ZHNlYXJjaC9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvQVBJX0RlbGV0ZURvbWFpbi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZWxldGVEb21haW4oKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0RlbGV0ZURvbWFpbicpO1xuICB9XG5cbiAgLyoqXG4gICAqIFJlbW92ZXMgYW4gRXhwcmVzc2lvbiBmcm9tIHRoZSBzZWFyY2ggZG9tYWluXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2Nsb3Vkc2VhcmNoL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9BUElfRGVsZXRlRXhwcmVzc2lvbi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZWxldGVFeHByZXNzaW9uKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZWxldGVFeHByZXNzaW9uJyk7XG4gIH1cblxuICAvKipcbiAgICogUmVtb3ZlcyBhbiBJbmRleEZpZWxkIGZyb20gdGhlIHNlYXJjaCBkb21haW5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY2xvdWRzZWFyY2gvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL0FQSV9EZWxldGVJbmRleEZpZWxkLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0RlbGV0ZUluZGV4RmllbGQoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0RlbGV0ZUluZGV4RmllbGQnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBEZWxldGVzIGEgc3VnZ2VzdGVyXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2Nsb3Vkc2VhcmNoL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9BUElfRGVsZXRlU3VnZ2VzdGVyLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0RlbGV0ZVN1Z2dlc3RlcigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVsZXRlU3VnZ2VzdGVyJyk7XG4gIH1cblxuICAvKipcbiAgICogR2V0cyB0aGUgYW5hbHlzaXMgc2NoZW1lcyBjb25maWd1cmVkIGZvciBhIGRvbWFpblxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2Nsb3Vkc2VhcmNoL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9BUElfRGVzY3JpYmVBbmFseXNpc1NjaGVtZXMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVzY3JpYmVBbmFseXNpc1NjaGVtZXMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0Rlc2NyaWJlQW5hbHlzaXNTY2hlbWVzJyk7XG4gIH1cblxuICAvKipcbiAgICogR2V0cyB0aGUgYXZhaWxhYmlsaXR5IG9wdGlvbnMgY29uZmlndXJlZCBmb3IgYSBkb21haW5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jbG91ZHNlYXJjaC9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvQVBJX0Rlc2NyaWJlQXZhaWxhYmlsaXR5T3B0aW9ucy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZXNjcmliZUF2YWlsYWJpbGl0eU9wdGlvbnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0Rlc2NyaWJlQXZhaWxhYmlsaXR5T3B0aW9ucycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdldHMgdGhlIGRvbWFpbiBlbmRwb2ludCBvcHRpb25zIGNvbmZpZ3VyZWQgZm9yIGEgZG9tYWluXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY2xvdWRzZWFyY2gvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL0FQSV9EZXNjcmliZURvbWFpbkVuZHBvaW50T3B0aW9ucy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZXNjcmliZURvbWFpbkVuZHBvaW50T3B0aW9ucygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVzY3JpYmVEb21haW5FbmRwb2ludE9wdGlvbnMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHZXRzIGluZm9ybWF0aW9uIGFib3V0IHRoZSBzZWFyY2ggZG9tYWlucyBvd25lZCBieSB0aGlzIGFjY291bnRcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jbG91ZHNlYXJjaC9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvQVBJX0Rlc2NyaWJlRG9tYWlucy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZXNjcmliZURvbWFpbnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0Rlc2NyaWJlRG9tYWlucycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdldHMgdGhlIGV4cHJlc3Npb25zIGNvbmZpZ3VyZWQgZm9yIHRoZSBzZWFyY2ggZG9tYWluXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY2xvdWRzZWFyY2gvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL0FQSV9EZXNjcmliZUV4cHJlc3Npb25zLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0Rlc2NyaWJlRXhwcmVzc2lvbnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0Rlc2NyaWJlRXhwcmVzc2lvbnMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHZXRzIGluZm9ybWF0aW9uIGFib3V0IHRoZSBpbmRleCBmaWVsZHMgY29uZmlndXJlZCBmb3IgdGhlIHNlYXJjaCBkb21haW5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jbG91ZHNlYXJjaC9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvQVBJX0Rlc2NyaWJlSW5kZXhGaWVsZHMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVzY3JpYmVJbmRleEZpZWxkcygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVzY3JpYmVJbmRleEZpZWxkcycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdldHMgdGhlIHNjYWxpbmcgcGFyYW1ldGVycyBjb25maWd1cmVkIGZvciBhIGRvbWFpblxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2Nsb3Vkc2VhcmNoL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9BUElfRGVzY3JpYmVTY2FsaW5nUGFyYW1ldGVycy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZXNjcmliZVNjYWxpbmdQYXJhbWV0ZXJzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZXNjcmliZVNjYWxpbmdQYXJhbWV0ZXJzJyk7XG4gIH1cblxuICAvKipcbiAgICogR2V0cyBpbmZvcm1hdGlvbiBhYm91dCB0aGUgYWNjZXNzIHBvbGljaWVzIHRoYXQgY29udHJvbCBhY2Nlc3MgdG8gdGhlIGRvbWFpbidzIGRvY3VtZW50IGFuZCBzZWFyY2ggZW5kcG9pbnRzXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY2xvdWRzZWFyY2gvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL0FQSV9EZXNjcmliZVNlcnZpY2VBY2Nlc3NQb2xpY2llcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZXNjcmliZVNlcnZpY2VBY2Nlc3NQb2xpY2llcygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVzY3JpYmVTZXJ2aWNlQWNjZXNzUG9saWNpZXMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHZXRzIHRoZSBzdWdnZXN0ZXJzIGNvbmZpZ3VyZWQgZm9yIGEgZG9tYWluXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY2xvdWRzZWFyY2gvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL0FQSV9EZXNjcmliZVN1Z2dlc3RlcnMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVzY3JpYmVTdWdnZXN0ZXJzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZXNjcmliZVN1Z2dlc3RlcnMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBUZWxscyB0aGUgc2VhcmNoIGRvbWFpbiB0byBzdGFydCBpbmRleGluZyBpdHMgZG9jdW1lbnRzIHVzaW5nIHRoZSBsYXRlc3QgaW5kZXhpbmcgb3B0aW9uc1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jbG91ZHNlYXJjaC9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvQVBJX0luZGV4RG9jdW1lbnRzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0luZGV4RG9jdW1lbnRzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdJbmRleERvY3VtZW50cycpO1xuICB9XG5cbiAgLyoqXG4gICAqIExpc3RzIGFsbCBzZWFyY2ggZG9tYWlucyBvd25lZCBieSBhbiBhY2NvdW50XG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY2xvdWRzZWFyY2gvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL0FQSV9MaXN0RG9tYWluTmFtZXMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdERvbWFpbk5hbWVzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0RG9tYWluTmFtZXMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBEaXNwbGF5cyBhbGwgb2YgdGhlIHJlc291cmNlIHRhZ3MgZm9yIGFuIEFtYXpvbiBDbG91ZFNlYXJjaCBkb21haW5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jbG91ZHNlYXJjaC9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvQVBJX0xpc3RUYWdzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RUYWdzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0VGFncycpO1xuICB9XG5cbiAgLyoqXG4gICAqIFJlbW92ZXMgdGhlIHNwZWNpZmllZCByZXNvdXJjZSB0YWdzIGZyb20gYW4gQW1hem9uIEVTIGRvbWFpblxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFRhZ2dpbmdcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2Nsb3Vkc2VhcmNoL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9BUElfUmVtb3ZlVGFncy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9SZW1vdmVUYWdzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdSZW1vdmVUYWdzJyk7XG4gIH1cblxuICAvKipcbiAgICogQ29uZmlndXJlcyB0aGUgYXZhaWxhYmlsaXR5IG9wdGlvbnMgZm9yIGEgZG9tYWluXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2Nsb3Vkc2VhcmNoL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9BUElfVXBkYXRlQXZhaWxhYmlsaXR5T3B0aW9ucy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9VcGRhdGVBdmFpbGFiaWxpdHlPcHRpb25zKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdVcGRhdGVBdmFpbGFiaWxpdHlPcHRpb25zJyk7XG4gIH1cblxuICAvKipcbiAgICogQ29uZmlndXJlcyB0aGUgZG9tYWluIGVuZHBvaW50IG9wdGlvbnMgZm9yIGEgZG9tYWluXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2Nsb3Vkc2VhcmNoL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9BUElfVXBkYXRlRG9tYWluRW5kcG9pbnRPcHRpb25zLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1VwZGF0ZURvbWFpbkVuZHBvaW50T3B0aW9ucygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnVXBkYXRlRG9tYWluRW5kcG9pbnRPcHRpb25zJyk7XG4gIH1cblxuICAvKipcbiAgICogQ29uZmlndXJlcyBzY2FsaW5nIHBhcmFtZXRlcnMgZm9yIGEgZG9tYWluXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2Nsb3Vkc2VhcmNoL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9BUElfVXBkYXRlU2NhbGluZ1BhcmFtZXRlcnMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVXBkYXRlU2NhbGluZ1BhcmFtZXRlcnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1VwZGF0ZVNjYWxpbmdQYXJhbWV0ZXJzJyk7XG4gIH1cblxuICAvKipcbiAgICogQ29uZmlndXJlcyB0aGUgYWNjZXNzIHJ1bGVzIHRoYXQgY29udHJvbCBhY2Nlc3MgdG8gdGhlIGRvbWFpbidzIGRvY3VtZW50IGFuZCBzZWFyY2ggZW5kcG9pbnRzXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUGVybWlzc2lvbnMgbWFuYWdlbWVudFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY2xvdWRzZWFyY2gvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL0FQSV9VcGRhdGVTZXJ2aWNlQWNjZXNzUG9saWNpZXMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVXBkYXRlU2VydmljZUFjY2Vzc1BvbGljaWVzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdVcGRhdGVTZXJ2aWNlQWNjZXNzUG9saWNpZXMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBBbGxvd3MgYWNjZXNzIHRvIHRoZSBkb2N1bWVudCBzZXJ2aWNlIG9wZXJhdGlvbnNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY2xvdWRzZWFyY2gvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL2NvbmZpZ3VyaW5nLWFjY2Vzcy5odG1sI2Nsb3Vkc2VhcmNoLWFjdGlvbnNcbiAgICovXG4gIHB1YmxpYyB0b0RvY3VtZW50KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdkb2N1bWVudCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIEFsbG93cyBhY2Nlc3MgdG8gdGhlIHNlYXJjaCBvcGVyYXRpb25zXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY2xvdWRzZWFyY2gvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL2NvbmZpZ3VyaW5nLWFjY2Vzcy5odG1sI2Nsb3Vkc2VhcmNoLWFjdGlvbnNcbiAgICovXG4gIHB1YmxpYyB0b1NlYXJjaCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnc2VhcmNoJyk7XG4gIH1cblxuICAvKipcbiAgICogQWxsb3dzIGFjY2VzcyB0byB0aGUgc3VnZ2VzdCBvcGVyYXRpb25zXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY2xvdWRzZWFyY2gvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL2NvbmZpZ3VyaW5nLWFjY2Vzcy5odG1sI2Nsb3Vkc2VhcmNoLWFjdGlvbnNcbiAgICovXG4gIHB1YmxpYyB0b1N1Z2dlc3QoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ3N1Z2dlc3QnKTtcbiAgfVxuXG4gIHByb3RlY3RlZCBhY2Nlc3NMZXZlbExpc3Q6IEFjY2Vzc0xldmVsTGlzdCA9IHtcbiAgICBUYWdnaW5nOiBbXG4gICAgICAnQWRkVGFncycsXG4gICAgICAnUmVtb3ZlVGFncydcbiAgICBdLFxuICAgIFdyaXRlOiBbXG4gICAgICAnQnVpbGRTdWdnZXN0ZXJzJyxcbiAgICAgICdDcmVhdGVEb21haW4nLFxuICAgICAgJ0RlZmluZUFuYWx5c2lzU2NoZW1lJyxcbiAgICAgICdEZWZpbmVFeHByZXNzaW9uJyxcbiAgICAgICdEZWZpbmVJbmRleEZpZWxkJyxcbiAgICAgICdEZWZpbmVTdWdnZXN0ZXInLFxuICAgICAgJ0RlbGV0ZUFuYWx5c2lzU2NoZW1lJyxcbiAgICAgICdEZWxldGVEb21haW4nLFxuICAgICAgJ0RlbGV0ZUV4cHJlc3Npb24nLFxuICAgICAgJ0RlbGV0ZUluZGV4RmllbGQnLFxuICAgICAgJ0RlbGV0ZVN1Z2dlc3RlcicsXG4gICAgICAnSW5kZXhEb2N1bWVudHMnLFxuICAgICAgJ1VwZGF0ZUF2YWlsYWJpbGl0eU9wdGlvbnMnLFxuICAgICAgJ1VwZGF0ZURvbWFpbkVuZHBvaW50T3B0aW9ucycsXG4gICAgICAnVXBkYXRlU2NhbGluZ1BhcmFtZXRlcnMnLFxuICAgICAgJ2RvY3VtZW50J1xuICAgIF0sXG4gICAgUmVhZDogW1xuICAgICAgJ0Rlc2NyaWJlQW5hbHlzaXNTY2hlbWVzJyxcbiAgICAgICdEZXNjcmliZUF2YWlsYWJpbGl0eU9wdGlvbnMnLFxuICAgICAgJ0Rlc2NyaWJlRG9tYWluRW5kcG9pbnRPcHRpb25zJyxcbiAgICAgICdEZXNjcmliZUV4cHJlc3Npb25zJyxcbiAgICAgICdEZXNjcmliZUluZGV4RmllbGRzJyxcbiAgICAgICdEZXNjcmliZVNjYWxpbmdQYXJhbWV0ZXJzJyxcbiAgICAgICdEZXNjcmliZVNlcnZpY2VBY2Nlc3NQb2xpY2llcycsXG4gICAgICAnRGVzY3JpYmVTdWdnZXN0ZXJzJyxcbiAgICAgICdMaXN0VGFncycsXG4gICAgICAnc2VhcmNoJyxcbiAgICAgICdzdWdnZXN0J1xuICAgIF0sXG4gICAgTGlzdDogW1xuICAgICAgJ0Rlc2NyaWJlRG9tYWlucycsXG4gICAgICAnTGlzdERvbWFpbk5hbWVzJ1xuICAgIF0sXG4gICAgJ1Blcm1pc3Npb25zIG1hbmFnZW1lbnQnOiBbXG4gICAgICAnVXBkYXRlU2VydmljZUFjY2Vzc1BvbGljaWVzJ1xuICAgIF1cbiAgfTtcblxuICAvKipcbiAgICogQWRkcyBhIHJlc291cmNlIG9mIHR5cGUgZG9tYWluIHRvIHRoZSBzdGF0ZW1lbnRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2Nsb3Vkc2VhcmNoL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9jcmVhdGluZy1kb21haW5zLmh0bWxcbiAgICpcbiAgICogQHBhcmFtIGRvbWFpbk5hbWUgLSBJZGVudGlmaWVyIGZvciB0aGUgZG9tYWluTmFtZS5cbiAgICogQHBhcmFtIGFjY291bnQgLSBBY2NvdW50IG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gYCpgLCB1bmxlc3MgdXNpbmcgdGhlIENESywgd2hlcmUgdGhlIGRlZmF1bHQgaXMgdGhlIGN1cnJlbnQgU3RhY2sncyBhY2NvdW50LlxuICAgKiBAcGFyYW0gcmVnaW9uIC0gUmVnaW9uIG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gYCpgLCB1bmxlc3MgdXNpbmcgdGhlIENESywgd2hlcmUgdGhlIGRlZmF1bHQgaXMgdGhlIGN1cnJlbnQgU3RhY2sncyByZWdpb24uXG4gICAqIEBwYXJhbSBwYXJ0aXRpb24gLSBQYXJ0aXRpb24gb2YgdGhlIEFXUyBhY2NvdW50IFthd3MsIGF3cy1jbiwgYXdzLXVzLWdvdl07IGRlZmF1bHRzIHRvIGBhd3NgLCB1bmxlc3MgdXNpbmcgdGhlIENESywgd2hlcmUgdGhlIGRlZmF1bHQgaXMgdGhlIGN1cnJlbnQgU3RhY2sncyBwYXJ0aXRpb24uXG4gICAqL1xuICBwdWJsaWMgb25Eb21haW4oZG9tYWluTmFtZTogc3RyaW5nLCBhY2NvdW50Pzogc3RyaW5nLCByZWdpb24/OiBzdHJpbmcsIHBhcnRpdGlvbj86IHN0cmluZykge1xuICAgIHJldHVybiB0aGlzLm9uKGBhcm46JHsgcGFydGl0aW9uID8/IHRoaXMuZGVmYXVsdFBhcnRpdGlvbiB9OmNsb3Vkc2VhcmNoOiR7IHJlZ2lvbiA/PyB0aGlzLmRlZmF1bHRSZWdpb24gfTokeyBhY2NvdW50ID8/IHRoaXMuZGVmYXVsdEFjY291bnQgfTpkb21haW4vJHsgZG9tYWluTmFtZSB9YCk7XG4gIH1cblxuICAvKipcbiAgICogU3RhdGVtZW50IHByb3ZpZGVyIGZvciBzZXJ2aWNlIFtjbG91ZHNlYXJjaF0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3NlcnZpY2UtYXV0aG9yaXphdGlvbi9sYXRlc3QvcmVmZXJlbmNlL2xpc3RfYW1hem9uY2xvdWRzZWFyY2guaHRtbCkuXG4gICAqXG4gICAqL1xuICBjb25zdHJ1Y3Rvcihwcm9wcz86IGlhbS5Qb2xpY3lTdGF0ZW1lbnRQcm9wcykge1xuICAgIHN1cGVyKHByb3BzKTtcbiAgfVxufVxuIl19