import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [applicationinsights](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudwatchapplicationinsights.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Applicationinsights extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to add a workload
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/APIReference/API_AddWorkload.html
     */
    toAddWorkload(): this;
    /**
     * Grants permission to create an application from a resource group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/APIReference/API_CreateApplication.html
     */
    toCreateApplication(): this;
    /**
     * Grants permission to create a component from a group of resources
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/APIReference/API_CreateComponent.html
     */
    toCreateComponent(): this;
    /**
     * Grants permission to create log a pattern
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/APIReference/API_CreateLogPattern.html
     */
    toCreateLogPattern(): this;
    /**
     * Grants permission to delete an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/APIReference/API_DeleteApplication.html
     */
    toDeleteApplication(): this;
    /**
     * Grants permission to delete a component
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/APIReference/API_DeleteComponent.html
     */
    toDeleteComponent(): this;
    /**
     * Grants permission to delete a log pattern
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/APIReference/API_DeleteLogPattern.html
     */
    toDeleteLogPattern(): this;
    /**
     * Grants permission to describe an application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/APIReference/API_DescribeApplication.html
     */
    toDescribeApplication(): this;
    /**
     * Grants permission to describe a component
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/APIReference/API_DescribeComponent.html
     */
    toDescribeComponent(): this;
    /**
     * Grants permission to describe a component's configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/APIReference/API_DescribeComponentConfiguration.html
     */
    toDescribeComponentConfiguration(): this;
    /**
     * Grants permission to describe the recommended application component configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/APIReference/API_DescribeComponentConfigurationRecommendation.html
     */
    toDescribeComponentConfigurationRecommendation(): this;
    /**
     * Grants permission to describe a log pattern
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/APIReference/API_DescribeLogPattern.html
     */
    toDescribeLogPattern(): this;
    /**
     * Grants permission to describe an observation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/APIReference/API_DescribeObservation.html
     */
    toDescribeObservation(): this;
    /**
     * Grants permission to describe a problem
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/APIReference/API_DescribeProblem.html
     */
    toDescribeProblem(): this;
    /**
     * Grants permission to describe the observation in a problem
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/APIReference/API_DescribeProblemObservations.html
     */
    toDescribeProblemObservations(): this;
    /**
     * Grants permission to describe a workload
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/APIReference/API_DescribeWorkload.html
     */
    toDescribeWorkload(): this;
    /**
     * Grants permission to share Application Insights resources with a monitoring account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account-Setup.html#CloudWatch-Unified-Cross-Account-Setup-permissions
     */
    toLink(): this;
    /**
     * Grants permission to list all applications
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/APIReference/API_ListApplications.html
     */
    toListApplications(): this;
    /**
     * Grants permission to list an application's components
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/APIReference/API_ListComponents.html
     */
    toListComponents(): this;
    /**
     * Grants permission to list configuration history
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/APIReference/API_ListConfigurationHistory.html
     */
    toListConfigurationHistory(): this;
    /**
     * Grants permission to list log pattern sets for an application
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/APIReference/API_ListLogPatternSets.html
     */
    toListLogPatternSets(): this;
    /**
     * Grants permission to list log patterns
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/APIReference/API_ListLogPatterns.html
     */
    toListLogPatterns(): this;
    /**
     * Grants permission to list the problems in an application
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/APIReference/API_ListProblems.html
     */
    toListProblems(): this;
    /**
     * Grants permission to list tags for the resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to list workloads
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/APIReference/API_ListWorkloads.html
     */
    toListWorkloads(): this;
    /**
     * Grants permission to remove a workload
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/APIReference/API_RemoveWorkload.html
     */
    toRemoveWorkload(): this;
    /**
     * Grants permission to tag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to untag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/APIReference/API_UpdateApplication.html
     */
    toUpdateApplication(): this;
    /**
     * Grants permission to update a component
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/APIReference/API_UpdateComponent.html
     */
    toUpdateComponent(): this;
    /**
     * Grants permission to update a component's configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/APIReference/API_UpdateComponentConfiguration.html
     */
    toUpdateComponentConfiguration(): this;
    /**
     * Grants permission to update a log pattern
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/APIReference/API_UpdateLogPattern.html
     */
    toUpdateLogPattern(): this;
    /**
     * Grants permission to update a problem
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/APIReference/API_UpdateProblem.html
     */
    toUpdateProblem(): this;
    /**
     * Grants permission to update a workload
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/APIReference/API_UpdateWorkload.html
     */
    toUpdateWorkload(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Filters access by a tag key and value pair that is allowed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by a tag key and value pair of a resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by a list of tag keys that are allowed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [applicationinsights](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudwatchapplicationinsights.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
