import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [internetmonitor](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudwatchinternetmonitor.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Internetmonitor extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to create a monitor
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/internet-monitor/latest/api/API_CreateMonitor.html
     */
    toCreateMonitor(): this;
    /**
     * Grants permission to delete a monitor
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/internet-monitor/latest/api/API_DeleteMonitor.html
     */
    toDeleteMonitor(): this;
    /**
     * Grants permission to get information about a health event for a specified monitor
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/internet-monitor/latest/api/API_GetHealthEvent.html
     */
    toGetHealthEvent(): this;
    /**
     * Grants permission to get information about a specified internet event
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/internet-monitor/latest/api/API_GetInternetEvent.html
     */
    toGetInternetEvent(): this;
    /**
     * Grants permission to get information about a monitor
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/internet-monitor/latest/api/API_GetMonitor.html
     */
    toGetMonitor(): this;
    /**
     * Grants permission to get results for a data query for a monitor
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/internet-monitor/latest/api/API_GetQueryResults.html
     */
    toGetQueryResults(): this;
    /**
     * Grants permission to get status for a data query for a monitor
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/internet-monitor/latest/api/API_GetQueryStatus.html
     */
    toGetQueryStatus(): this;
    /**
     * Grants permission to share Internet Monitor resources with a monitoring account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account-Setup.html#CloudWatch-Unified-Cross-Account-Setup-permissions
     */
    toLink(): this;
    /**
     * Grants permission to list all health events for a monitor
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/internet-monitor/latest/api/API_ListHealthEvents.html
     */
    toListHealthEvents(): this;
    /**
     * Grants permission to list all internet events
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/internet-monitor/latest/api/API_ListInternetEvents.html
     */
    toListInternetEvents(): this;
    /**
     * Grants permission to list all monitors in an account and their statuses
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/internet-monitor/latest/api/API_ListMonitors.html
     */
    toListMonitors(): this;
    /**
     * Grants permission to list the tags for a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/internet-monitor/latest/api/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to start a data query for a monitor
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/internet-monitor/latest/api/API_StartQuery.html
     */
    toStartQuery(): this;
    /**
     * Grants permission to stop a data query for a monitor
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/internet-monitor/latest/api/API_StopQuery.html
     */
    toStopQuery(): this;
    /**
     * Grants permission to add tags to a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/internet-monitor/latest/api/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove tags from a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/internet-monitor/latest/api/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update a monitor
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/internet-monitor/latest/api/API_UpdateMonitor.html
     */
    toUpdateMonitor(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type HealthEvent to the statement
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-components.html
     *
     * @param monitorName - Identifier for the monitorName.
     * @param eventId - Identifier for the eventId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onHealthEvent(monitorName: string, eventId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Monitor to the statement
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-components.html
     *
     * @param monitorName - Identifier for the monitorName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onMonitor(monitorName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type InternetEvent to the statement
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-components.html
     *
     * @param internetEventId - Identifier for the internetEventId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onInternetEvent(internetEventId: string, account?: string, partition?: string): this;
    /**
     * Filters access by tag key-value pairs in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateMonitor()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by tag key-value pairs attached to the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to resource types:
     * - HealthEvent
     * - Monitor
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by tag keys in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateMonitor()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [internetmonitor](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudwatchinternetmonitor.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
