import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [networkmonitor](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudwatchnetworksyntheticmonitor.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Networkmonitor extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to create a monitor
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/networkmonitor/latest/APIReference/API_CreateMonitor.html
     */
    toCreateMonitor(): this;
    /**
     * Grants permission to create a probe
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/networkmonitor/latest/APIReference/API_CreateProbe.html
     */
    toCreateProbe(): this;
    /**
     * Grants permission to delete a monitor
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/networkmonitor/latest/APIReference/API_DeleteMonitor.html
     */
    toDeleteMonitor(): this;
    /**
     * Grants permission to delete a probe
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/networkmonitor/latest/APIReference/API_DeleteProbe.html
     */
    toDeleteProbe(): this;
    /**
     * Grants permission to get information about a monitor
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/networkmonitor/latest/APIReference/API_GetMonitor.html
     */
    toGetMonitor(): this;
    /**
     * Grants permission to get information about a probe
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/networkmonitor/latest/APIReference/API_GetProbe.html
     */
    toGetProbe(): this;
    /**
     * Grants permission to list all monitors in an account and their statuses
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/networkmonitor/latest/APIReference/API_ListMonitors.html
     */
    toListMonitors(): this;
    /**
     * Grants permission to list the tags for a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/networkmonitor/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to add tags to a resource
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/networkmonitor/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove tags from a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/networkmonitor/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update a monitor
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/networkmonitor/latest/APIReference/API_UpdateMonitor.html
     */
    toUpdateMonitor(): this;
    /**
     * Grants permission to update a probe
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/networkmonitor/latest/APIReference/API_UpdateProbe.html
     */
    toUpdateProbe(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type monitor to the statement
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/nw-monitor-working-with.html
     *
     * @param monitorName - Identifier for the monitorName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onMonitor(monitorName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type probe to the statement
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/nw-monitor-working-with.html
     *
     * @param probeId - Identifier for the probeId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onProbe(probeId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the tag key-value pairs in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tag key-value pairs attached to the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to resource types:
     * - monitor
     * - probe
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tag keys in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [networkmonitor](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudwatchnetworksyntheticmonitor.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
