"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Observabilityadmin = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [observabilityadmin](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudwatchobservabilityadminservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Observabilityadmin extends shared_1.PolicyStatement {
    /**
     * Grants permission to retrieve the Telemetry Config feature status for the account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ObservabilityAdmin/latest/APIReference/API_GetTelemetryEvaluationStatus.html
     */
    toGetTelemetryEvaluationStatus() {
        return this.to('GetTelemetryEvaluationStatus');
    }
    /**
     * Grants permission to retrieve the Telemetry Config feature status for the organization
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ObservabilityAdmin/latest/APIReference/API_GetTelemetryEvaluationStatusForOrganization.html
     */
    toGetTelemetryEvaluationStatusForOrganization() {
        return this.to('GetTelemetryEvaluationStatusForOrganization');
    }
    /**
     * Grants permission to retrieve telemetry configurations for resources associated with the account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ObservabilityAdmin/latest/APIReference/API_ListResourceTelemetry.html
     */
    toListResourceTelemetry() {
        return this.to('ListResourceTelemetry');
    }
    /**
     * Grants permission to retrieve telemetry configurations for resources associated with accounts in the organization
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ObservabilityAdmin/latest/APIReference/API_ListResourceTelemetryForOrganization.html
     */
    toListResourceTelemetryForOrganization() {
        return this.to('ListResourceTelemetryForOrganization');
    }
    /**
     * Grants permission to start the Telemetry Config feature for the account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ObservabilityAdmin/latest/APIReference/API_StartTelemetryEvaluation.html
     */
    toStartTelemetryEvaluation() {
        return this.to('StartTelemetryEvaluation');
    }
    /**
     * Grants permission to start the Telemetry Config feature for the organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ObservabilityAdmin/latest/APIReference/API_StartTelemetryEvaluationForOrganization.html
     */
    toStartTelemetryEvaluationForOrganization() {
        return this.to('StartTelemetryEvaluationForOrganization');
    }
    /**
     * Grants permission to stop the Telemetry Config feature for the account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ObservabilityAdmin/latest/APIReference/API_StopTelemetryEvaluation.html
     */
    toStopTelemetryEvaluation() {
        return this.to('StopTelemetryEvaluation');
    }
    /**
     * Grants permission to stop the Telemetry Config feature for the organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ObservabilityAdmin/latest/APIReference/API_StopTelemetryEvaluationForOrganization.html
     */
    toStopTelemetryEvaluationForOrganization() {
        return this.to('StopTelemetryEvaluationForOrganization');
    }
    /**
     * Statement provider for service [observabilityadmin](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudwatchobservabilityadminservice.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'observabilityadmin';
        this.accessLevelList = {
            Read: [
                'GetTelemetryEvaluationStatus',
                'GetTelemetryEvaluationStatusForOrganization',
                'ListResourceTelemetry',
                'ListResourceTelemetryForOrganization'
            ],
            Write: [
                'StartTelemetryEvaluation',
                'StartTelemetryEvaluationForOrganization',
                'StopTelemetryEvaluation',
                'StopTelemetryEvaluationForOrganization'
            ]
        };
    }
}
exports.Observabilityadmin = Observabilityadmin;
//# sourceMappingURL=data:application/json;base64,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