import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [controltower](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscontroltower.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Controltower extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to create a landing zone
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - controltower:TagResource
     *
     * https://docs.aws.amazon.com/controltower/latest/APIReference/API_CreateLandingZone.html
     */
    toCreateLandingZone(): this;
    /**
     * Grants permission to create an account managed by AWS Control Tower
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     */
    toCreateManagedAccount(): this;
    /**
     * Grants permission to delete AWS Control Tower landing zone
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/APIReference/API_DeleteLandingZone.html
     */
    toDeleteLandingZone(): this;
    /**
     * Grants permission to deregister an account created through the account factory from AWS Control Tower
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     */
    toDeregisterManagedAccount(): this;
    /**
     * Grants permission to deregister an organizational unit from AWS Control Tower management
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/organizations.html
     */
    toDeregisterOrganizationalUnit(): this;
    /**
     * Grants permission to describe the current account factory configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     */
    toDescribeAccountFactoryConfig(): this;
    /**
     * Grants permission to describe resources managed by core accounts in AWS Control Tower
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/how-control-tower-works.html#what-shared
     */
    toDescribeCoreService(): this;
    /**
     * Grants permission to describe a guardrail
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/controls.html
     */
    toDescribeGuardrail(): this;
    /**
     * Grants permission to describe a guardrail for a organizational unit
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/controls.html
     */
    toDescribeGuardrailForTarget(): this;
    /**
     * Grants permission to describe the current Landing Zone configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/step-two.html
     */
    toDescribeLandingZoneConfiguration(): this;
    /**
     * Grants permission to describe an account created through account factory
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     */
    toDescribeManagedAccount(): this;
    /**
     * Grants permission to describe an AWS Organizations organizational unit managed by AWS Control Tower
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/organizations.html
     */
    toDescribeManagedOrganizationalUnit(): this;
    /**
     * Grants permission to describe a Register Organizational Unit Operation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/about-extending-governance.html
     */
    toDescribeRegisterOrganizationalUnitOperation(): this;
    /**
     * Grants permission to describe the current AWS Control Tower IAM Identity Center configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/sso.html
     */
    toDescribeSingleSignOn(): this;
    /**
     * Grants permission to disable a Baseline on a target
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/APIReference/API_DisableBaseline.html
     */
    toDisableBaseline(): this;
    /**
     * Grants permission to remove a control from an organizational unit
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/APIReference/API_DisableControl.html
     */
    toDisableControl(): this;
    /**
     * Grants permission to disable a guardrail from an organizational unit
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/enable-controls-on-ou.html
     */
    toDisableGuardrail(): this;
    /**
     * Grants permission to enable a Baseline on a target
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - controltower:TagResource
     *
     * https://docs.aws.amazon.com/controltower/latest/APIReference/API_EnableBaseline.html
     */
    toEnableBaseline(): this;
    /**
     * Grants permission to activate a control for an organizational unit
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - controltower:TagResource
     *
     * https://docs.aws.amazon.com/controltower/latest/APIReference/API_EnableControl.html
     */
    toEnableControl(): this;
    /**
     * Grants permission to enable a guardrail to an organizational unit
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/enable-controls-on-ou.html
     */
    toEnableGuardrail(): this;
    /**
     * Grants permission to describe an account email and validate that it exists
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/accounts.html
     */
    toGetAccountInfo(): this;
    /**
     * Grants permission to list available updates for the current AWS Control Tower deployment
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/configuration-updates.html
     */
    toGetAvailableUpdates(): this;
    /**
     * Grants permission to get Baseline details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/APIReference/API_GetBaseline.html
     */
    toGetBaseline(): this;
    /**
     * Grants permission to get the current status of a particular Baseline operation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/APIReference/API_GetBaselineOperation.html
     */
    toGetBaselineOperation(): this;
    /**
     * Grants permission to get the current status of a particular EnabledControl or DisableControl operation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/APIReference/API_GetControlOperation.html
     */
    toGetControlOperation(): this;
    /**
     * Grants permission to get an enabled Baseline
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/APIReference/API_GetEnabledBaseline.html
     */
    toGetEnabledBaseline(): this;
    /**
     * Grants permission to get an enabled control from an organizational unit
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/APIReference/API_GetEnabledControl.html
     */
    toGetEnabledControl(): this;
    /**
     * Grants permission to get the current compliance status of a guardrail
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/controls.html
     */
    toGetGuardrailComplianceStatus(): this;
    /**
     * Grants permission to get the home region of the AWS Control Tower setup
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/how-control-tower-works.html#region-how
     */
    toGetHomeRegion(): this;
    /**
     * Grants permission to get the current status of the landing zone setup
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/APIReference/API_GetLandingZone.html
     */
    toGetLandingZone(): this;
    /**
     * Grants permission to get the current landing zone drift status
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/drift.html
     */
    toGetLandingZoneDriftStatus(): this;
    /**
     * Grants permission to get the current status of a particular landing zone operation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/APIReference/API_GetLandingZoneOperation.html
     */
    toGetLandingZoneOperation(): this;
    /**
     * Grants permission to get the current status of the landing zone setup
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/getting-started-with-control-tower.html#step-two
     */
    toGetLandingZoneStatus(): this;
    /**
     * Grants permission to list Baselines
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/APIReference/API_ListBaselines.html
     */
    toListBaselines(): this;
    /**
     * Grants permission to list all control operations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/APIReference/API_ListControlOperations.html
     */
    toListControlOperations(): this;
    /**
     * Grants permission to list the current directory groups available through IAM Identity Center
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/sso.html
     */
    toListDirectoryGroups(): this;
    /**
     * Grants permission to list occurrences of drift in AWS Control Tower
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/drift.html
     */
    toListDriftDetails(): this;
    /**
     * Grants permission to list enabled Baselines
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/APIReference/API_ListEnabledBaselines.html
     */
    toListEnabledBaselines(): this;
    /**
     * Grants permission to list all enabled controls in a specified organizational unit
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/APIReference/API_ListEnabledControls.html
     */
    toListEnabledControls(): this;
    /**
     * Grants permission to list currently enabled guardrails
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/controls.html
     */
    toListEnabledGuardrails(): this;
    /**
     * Grants permission to list Precheck details for an Organizational Unit
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/about-extending-governance.html
     */
    toListExtendGovernancePrecheckDetails(): this;
    /**
     * Grants permission to list the compliance of external AWS Config rules
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/review-compliance.html
     */
    toListExternalConfigRuleCompliance(): this;
    /**
     * Grants permission to list existing guardrail violations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/controls.html
     */
    toListGuardrailViolations(): this;
    /**
     * Grants permission to list all available guardrails
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/controls.html
     */
    toListGuardrails(): this;
    /**
     * Grants permission to list guardrails and their current state for a organizational unit
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/controls.html
     */
    toListGuardrailsForTarget(): this;
    /**
     * Grants permission to list all landing zone operations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/APIReference/API_ListLandingZoneOperations.html
     */
    toListLandingZoneOperations(): this;
    /**
     * Grants permission to list all landing zones
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/APIReference/API_ListLandingZones.html
     */
    toListLandingZones(): this;
    /**
     * Grants permission to list accounts managed through AWS Control Tower
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     */
    toListManagedAccounts(): this;
    /**
     * Grants permission to list managed accounts with a specified guardrail applied
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     */
    toListManagedAccountsForGuardrail(): this;
    /**
     * Grants permission to list managed accounts under an organizational unit
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     */
    toListManagedAccountsForParent(): this;
    /**
     * Grants permission to list organizational units managed by AWS Control Tower
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/organizations.html
     */
    toListManagedOrganizationalUnits(): this;
    /**
     * Grants permission to list managed organizational units that have a specified guardrail applied
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/organizations.html
     */
    toListManagedOrganizationalUnitsForGuardrail(): this;
    /**
     * Grants permission to list the tags for a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to set up an organizational unit to be managed by AWS Control Tower
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/organizations.html
     */
    toManageOrganizationalUnit(): this;
    /**
     * Grants permission to perform validations in an account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/getting-started-prereqs.html
     */
    toPerformPreLaunchChecks(): this;
    /**
     * Grants permission to reset an enabled Baseline
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/APIReference/API_ResetEnabledBaseline.html
     */
    toResetEnabledBaseline(): this;
    /**
     * Grants permission to reset an enabled control for an organizational unit
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/APIReference/API_ResetEnabledControl.html
     */
    toResetEnabledControl(): this;
    /**
     * Grants permission to reset a landing zone
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/APIReference/API_ResetLandingZone.html
     */
    toResetLandingZone(): this;
    /**
     * Grants permission to set up or update AWS Control Tower landing zone
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/getting-started-with-control-tower.html#step-two
     */
    toSetupLandingZone(): this;
    /**
     * Grants permission to add tags to a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/controltower/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove tags from a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/controltower/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update the account factory configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     */
    toUpdateAccountFactoryConfig(): this;
    /**
     * Grants permission to update an enabled Baseline
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/APIReference/API_UpdateEnabledBaseline.html
     */
    toUpdateEnabledBaseline(): this;
    /**
     * Grants permission to update an enabled control for an organizational unit
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/APIReference/API_UpdateEnabledControl.html
     */
    toUpdateEnabledControl(): this;
    /**
     * Grants permission to update a landing zone
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/APIReference/API_UpdateLandingZone.html
     */
    toUpdateLandingZone(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type EnabledControl to the statement
     *
     * https://docs.aws.amazon.com/controltower/latest/APIReference/API_EnableControl.html
     *
     * @param enabledControlId - Identifier for the enabledControlId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onEnabledControl(enabledControlId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Baseline to the statement
     *
     * https://docs.aws.amazon.com/controltower/latest/APIReference/API_GetBaseline.html
     *
     * @param baselineId - Identifier for the baselineId.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onBaseline(baselineId: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type EnabledBaseline to the statement
     *
     * https://docs.aws.amazon.com/controltower/latest/APIReference/API_EnableBaseline.html
     *
     * @param enabledBaselineId - Identifier for the enabledBaselineId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onEnabledBaseline(enabledBaselineId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type LandingZone to the statement
     *
     * https://docs.aws.amazon.com/controltower/latest/APIReference/API_CreateLandingZone.html
     *
     * @param landingZoneId - Identifier for the landingZoneId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onLandingZone(landingZoneId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the tags that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateLandingZone()
     * - .toEnableBaseline()
     * - .toEnableControl()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tags associated with the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to resource types:
     * - EnabledControl
     * - EnabledBaseline
     * - LandingZone
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tag keys that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateLandingZone()
     * - .toEnableBaseline()
     * - .toEnableControl()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [controltower](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscontroltower.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
