import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [elemental-activations](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awselementalappliancesandsoftwareactivationservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class ElementalActivations extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to complete the process of registering customer account for AWS Elemental Appliances and Software Purchases
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elemental-appliances-software/
     */
    toCompleteAccountRegistration(): this;
    /**
     * Grants permission to complete the process of uploading a Software file for AWS Elemental Appliances and Software Purchases
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elemental-appliances-software/
     */
    toCompleteFileUpload(): this;
    /**
     * Grants permission to confirm asset ownership
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elemental-appliances-software/
     */
    toConfirmAccount(): this;
    /**
     * Grants permission to download the kickstart files for AWS Elemental Appliances and Software purchases
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elemental-appliances-software/
     */
    toDownloadKickstart(): this;
    /**
     * Grants permission to download the Software files for AWS Elemental Appliances and Software Purchases
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elemental-appliances-software/
     */
    toDownloadSoftware(): this;
    /**
     * Grants permission to generate a software license for an AWS Elemental Appliances and Software purchase
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elemental-appliances-software/
     */
    toGenerateLicense(): this;
    /**
     * Grants permission to generate Software Licenses for AWS Elemental Appliances and Software Purchases
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elemental-appliances-software/
     */
    toGenerateLicenses(): this;
    /**
     * Grants permission to describe the software version of an artifact group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elemental-appliances-software/
     */
    toGetArtifactGroupSoftwareVersions(): this;
    /**
     * Grants permission to describe an asset
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elemental-appliances-software/
     */
    toGetAsset(): this;
    /**
     * Grants permission to describe assets associated to the requesting account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elemental-appliances-software/
     */
    toGetAssets(): this;
    /**
     * Grants permission to get all product advisories
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elemental-appliances-software/
     */
    toGetProductAdvisories(): this;
    /**
     * Grants permission to describe available software versions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elemental-appliances-software/
     */
    toGetSoftwareVersions(): this;
    /**
     * Grants permission to start the process of uploading a Software file for AWS Elemental Appliances and Software Purchases
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elemental-appliances-software/
     */
    toStartFileUpload(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Statement provider for service [elemental-activations](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awselementalappliancesandsoftwareactivationservice.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
