import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [social-messaging](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsendusermessagingsocial.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class SocialMessaging extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to associate a WhatsApp Business Account with your AWS account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/social-messaging/latest/APIReference/API_AssociateWhatsAppBusinessAccount.html
     */
    toAssociateWhatsAppBusinessAccount(): this;
    /**
     * Grants permission to delete a media object from WhatsApp
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/social-messaging/latest/APIReference/API_DeleteWhatsAppMessageMedia.html
     */
    toDeleteWhatsAppMessageMedia(): this;
    /**
     * Grants permission to disassociate a WhatsApp Business Account from your AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/social-messaging/latest/APIReference/API_DisassociateWhatsAppBusinessAccount.html
     */
    toDisassociateWhatsAppBusinessAccount(): this;
    /**
     * Grants permission to view the details of a WhatsApp Business Account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/social-messaging/latest/APIReference/API_GetLinkedWhatsAppBusinessAccount.html
     */
    toGetLinkedWhatsAppBusinessAccount(): this;
    /**
     * Grants permission to view the details of a phone number
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/social-messaging/latest/APIReference/API_GetLinkedWhatsAppBusinessAccountPhoneNumber.html
     */
    toGetLinkedWhatsAppBusinessAccountPhoneNumber(): this;
    /**
     * Grants permission to get a media object from WhatsApp
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/social-messaging/latest/APIReference/API_GetWhatsAppMessageMedia.html
     */
    toGetWhatsAppMessageMedia(): this;
    /**
     * Grants permission to view all of your WhatsApp Business Accounts
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/social-messaging/latest/APIReference/API_ListLinkedWhatsAppBusinessAccounts.html
     */
    toListLinkedWhatsAppBusinessAccounts(): this;
    /**
     * Grants permission to list tags for a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/social-messaging/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to upload a media object to WhatsApp
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/social-messaging/latest/APIReference/API_PostWhatsAppMessageMedia.html
     */
    toPostWhatsAppMessageMedia(): this;
    /**
     * Grants permission to update a WhatsApp Business Accounts event destination
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/social-messaging/latest/APIReference/API_PutWhatsAppBusinessAccountEventDestinations.html
     */
    toPutWhatsAppBusinessAccountEventDestinations(): this;
    /**
     * Grants permission to send a message through WhatsApp
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/social-messaging/latest/APIReference/API_SendWhatsAppMessage.html
     */
    toSendWhatsAppMessage(): this;
    /**
     * Grants permission to add a tag to a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/social-messaging/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove a tag from a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/social-messaging/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type phone-number-id to the statement
     *
     * https://docs.aws.amazon.com/social-messaging/latest/APIReference/API_WhatsAppPhoneNumberDetail.html
     *
     * @param originationPhoneNumberId - Identifier for the originationPhoneNumberId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onPhoneNumberId(originationPhoneNumberId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type waba to the statement
     *
     * https://docs.aws.amazon.com/social-messaging/latest/APIReference/API_LinkedWhatsAppBusinessAccountSummary.html
     *
     * @param wabaId - Identifier for the wabaId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onWaba(wabaId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the tags that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toAssociateWhatsAppBusinessAccount()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tags associated with the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to actions:
     * - .toAssociateWhatsAppBusinessAccount()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * Applies to resource types:
     * - phone-number-id
     * - waba
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tag keys that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toAssociateWhatsAppBusinessAccount()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [social-messaging](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsendusermessagingsocial.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
