import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [fis](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsfaultinjectionservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Fis extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to create an AWS FIS experiment template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/fis/latest/APIReference/API_CreateExperimentTemplate.html
     */
    toCreateExperimentTemplate(): this;
    /**
     * Grants permission to create an AWS FIS target account configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/fis/latest/APIReference/API_CreateTargetAccountConfiguration.html
     */
    toCreateTargetAccountConfiguration(): this;
    /**
     * Grants permission to delete the AWS FIS experiment template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/fis/latest/APIReference/API_DeleteExperimentTemplate.html
     */
    toDeleteExperimentTemplate(): this;
    /**
     * Grants permission to delete an AWS FIS target account configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/fis/latest/APIReference/API_DeleteTargetAccountConfiguration.html
     */
    toDeleteTargetAccountConfiguration(): this;
    /**
     * Grants permission to retrieve an AWS FIS action
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/fis/latest/APIReference/API_GetAction.html
     */
    toGetAction(): this;
    /**
     * Grants permission to retrieve an AWS FIS experiment
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/fis/latest/APIReference/API_GetExperiment.html
     */
    toGetExperiment(): this;
    /**
     * Grants permission to retrieve an AWS FIS target account configuration for an AWS FIS experiment
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/fis/latest/APIReference/API_GetExperimentTargetAccountConfiguration.html
     */
    toGetExperimentTargetAccountConfiguration(): this;
    /**
     * Grants permission to retrieve an AWS FIS Experiment Template
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/fis/latest/APIReference/API_GetExperimentTemplate.html
     */
    toGetExperimentTemplate(): this;
    /**
     * Grants permission to get information about the safety lever
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/fis/latest/APIReference/API_GetSafetyLever.html
     */
    toGetSafetyLever(): this;
    /**
     * Grants permission to retrieve an AWS FIS target account configuration for an AWS FIS experiment template
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/fis/latest/APIReference/API_GetTargetAccountConfiguration.html
     */
    toGetTargetAccountConfiguration(): this;
    /**
     * Grants permission to get information about the specified resource type
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/fis/latest/APIReference/API_GetTargetResourceType.html
     */
    toGetTargetResourceType(): this;
    /**
     * Grants permission to inject an API internal error on the provided AWS service from an FIS Experiment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifService()
     * - .ifOperations()
     * - .ifPercentage()
     * - .ifTargets()
     *
     * https://docs.aws.amazon.com/fis/latest/userguide/fis-actions-reference.html#fis-actions-reference-fis
     */
    toInjectApiInternalError(): this;
    /**
     * Grants permission to inject an API throttle error on the provided AWS service from an FIS Experiment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifService()
     * - .ifOperations()
     * - .ifPercentage()
     * - .ifTargets()
     *
     * https://docs.aws.amazon.com/fis/latest/userguide/fis-actions-reference.html#fis-actions-reference-fis
     */
    toInjectApiThrottleError(): this;
    /**
     * Grants permission to inject an API unavailable error on the provided AWS service from an FIS Experiment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifService()
     * - .ifOperations()
     * - .ifPercentage()
     * - .ifTargets()
     *
     * https://docs.aws.amazon.com/fis/latest/userguide/fis-actions-reference.html#fis-actions-reference-fis
     */
    toInjectApiUnavailableError(): this;
    /**
     * Grants permission to list all available AWS FIS actions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/fis/latest/APIReference/API_ListActions.html
     */
    toListActions(): this;
    /**
     * Grants permission to list resolved targets for AWS FIS experiments
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/fis/latest/APIReference/API_ListExperimentResolvedTargets.html
     */
    toListExperimentResolvedTargets(): this;
    /**
     * Grants permission to list target account configurations for AWS FIS experiments
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/fis/latest/APIReference/API_ListExperimentTargetAccountConfigurations.html
     */
    toListExperimentTargetAccountConfigurations(): this;
    /**
     * Grants permission to list all available AWS FIS experiment templates
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/fis/latest/APIReference/API_ListExperimentTemplates.html
     */
    toListExperimentTemplates(): this;
    /**
     * Grants permission to list all available AWS FIS experiments
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/fis/latest/APIReference/API_ListExperiments.html
     */
    toListExperiments(): this;
    /**
     * Grants permission to list the tags for an AWS FIS resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/fis/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to list target account configurations for AWS FIS experiment templates
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/fis/latest/APIReference/API_ListTargetAccountConfigurations.html
     */
    toListTargetAccountConfigurations(): this;
    /**
     * Grants permission to list the resource types
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/fis/latest/APIReference/API_ListTargetResourceTypes.html
     */
    toListTargetResourceTypes(): this;
    /**
     * Grants permission to run an AWS FIS experiment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     *
     * https://docs.aws.amazon.com/fis/latest/APIReference/API_StartExperiment.html
     */
    toStartExperiment(): this;
    /**
     * Grants permission to stop an AWS FIS experiment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/fis/latest/APIReference/API_StopExperiment.html
     */
    toStopExperiment(): this;
    /**
     * Grants permission to tag AWS FIS resources
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/fis/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to untag AWS FIS resources
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/fis/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update the specified AWS FIS experiment template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/fis/latest/APIReference/API_UpdateExperimentTemplate.html
     */
    toUpdateExperimentTemplate(): this;
    /**
     * Grants permission to update the state of the safety lever
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/fis/latest/APIReference/API_UpdateSafetyLeverState.html
     */
    toUpdateSafetyLeverState(): this;
    /**
     * Grants permission to update an AWS FIS target account configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/fis/latest/APIReference/API_UpdateTargetAccountConfiguration.html
     */
    toUpdateTargetAccountConfiguration(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type action to the statement
     *
     * https://docs.aws.amazon.com/fis/latest/userguide/actions.html
     *
     * @param id - Identifier for the id.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAction(id: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type experiment to the statement
     *
     * https://docs.aws.amazon.com/fis/latest/userguide/experiments.html
     *
     * @param id - Identifier for the id.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onExperiment(id: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type experiment-template to the statement
     *
     * https://docs.aws.amazon.com/fis/latest/userguide/working-with-templates.html
     *
     * @param id - Identifier for the id.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onExperimentTemplate(id: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type safety-lever to the statement
     *
     * https://docs.aws.amazon.com/fis/latest/userguide/safety-lever.html
     *
     * @param id - Identifier for the id.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onSafetyLever(id: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by a tag key and value pair that is allowed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateExperimentTemplate()
     * - .toStartExperiment()
     * - .toTagResource()
     * - .toUpdateExperimentTemplate()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by a tag key and value pair of a resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to actions:
     * - .toGetAction()
     * - .toGetExperiment()
     * - .toGetExperimentTemplate()
     *
     * Applies to resource types:
     * - action
     * - experiment
     * - experiment-template
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by a list of tag keys that are allowed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateExperimentTemplate()
     * - .toStartExperiment()
     * - .toTagResource()
     * - .toUntagResource()
     * - .toUpdateExperimentTemplate()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the list of operations on the AWS service that is being affected by the AWS FIS action
     *
     * https://docs.aws.amazon.com/fis/latest/userguide/security_iam_service-with-iam.html
     *
     * Applies to actions:
     * - .toInjectApiInternalError()
     * - .toInjectApiThrottleError()
     * - .toInjectApiUnavailableError()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifOperations(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the percentage of calls being affected by the AWS FIS action
     *
     * https://docs.aws.amazon.com/fis/latest/userguide/security_iam_service-with-iam.html
     *
     * Applies to actions:
     * - .toInjectApiInternalError()
     * - .toInjectApiThrottleError()
     * - .toInjectApiUnavailableError()
     *
     * @param value The value(s) to check
     * @param operator Works with [numeric operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric). **Default:** `NumericEquals`
     */
    ifPercentage(value: number | number[], operator?: Operator | string): this;
    /**
     * Filters access by the AWS service that is being affected by the AWS FIS action
     *
     * https://docs.aws.amazon.com/fis/latest/userguide/security_iam_service-with-iam.html
     *
     * Applies to actions:
     * - .toInjectApiInternalError()
     * - .toInjectApiThrottleError()
     * - .toInjectApiUnavailableError()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifService(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the list of resource ARNs being targeted by the AWS FIS action
     *
     * https://docs.aws.amazon.com/fis/latest/userguide/security_iam_service-with-iam.html
     *
     * Applies to actions:
     * - .toInjectApiInternalError()
     * - .toInjectApiThrottleError()
     * - .toInjectApiUnavailableError()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifTargets(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [fis](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsfaultinjectionservice.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
