import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [forecast](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonforecast.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Forecast extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to create an auto predictor
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_CreateAutoPredictor.html
     */
    toCreateAutoPredictor(): this;
    /**
     * Grants permission to create a dataset
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDataset.html
     */
    toCreateDataset(): this;
    /**
     * Grants permission to create a dataset group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDatasetGroup.html
     */
    toCreateDatasetGroup(): this;
    /**
     * Grants permission to create a dataset import job
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDatasetImportJob.html
     */
    toCreateDatasetImportJob(): this;
    /**
     * Grants permission to create an explainability
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_CreateExplainability.html
     */
    toCreateExplainability(): this;
    /**
     * Grants permission to create an explainability export using an explainability resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_CreateExplainabilityExport.html
     */
    toCreateExplainabilityExport(): this;
    /**
     * Grants permission to create a forecast
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_CreateForecast.html
     */
    toCreateForecast(): this;
    /**
     * Grants permission to create an endpoint using a Predictor resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/what-is-forecast.html
     */
    toCreateForecastEndpoint(): this;
    /**
     * Grants permission to create a forecast export job using a forecast resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_CreateForecastExportJob.html
     */
    toCreateForecastExportJob(): this;
    /**
     * Grants permission to create an monitor using a Predictor resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_CreateMonitor.html
     */
    toCreateMonitor(): this;
    /**
     * Grants permission to create a predictor
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_CreatePredictor.html
     */
    toCreatePredictor(): this;
    /**
     * Grants permission to create a predictor backtest export job using a predictor
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_CreatePredictorBacktestExportJob.html
     */
    toCreatePredictorBacktestExportJob(): this;
    /**
     * Grants permission to create a what-if analysis
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_CreateWhatIfAnalysis.html
     */
    toCreateWhatIfAnalysis(): this;
    /**
     * Grants permission to create a what-if forecast
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_CreateWhatIfForecast.html
     */
    toCreateWhatIfForecast(): this;
    /**
     * Grants permission to create a what-if forecast export using what-if forecast resources
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_CreateWhatIfForecastExport.html
     */
    toCreateWhatIfForecastExport(): this;
    /**
     * Grants permission to delete a dataset
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_DeleteDataset.html
     */
    toDeleteDataset(): this;
    /**
     * Grants permission to delete a dataset group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_DeleteDatasetGroup.html
     */
    toDeleteDatasetGroup(): this;
    /**
     * Grants permission to delete a dataset import job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_DeleteDatasetImportJob.html
     */
    toDeleteDatasetImportJob(): this;
    /**
     * Grants permission to delete an explainability
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_DeleteExplainability.html
     */
    toDeleteExplainability(): this;
    /**
     * Grants permission to delete an explainability export
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_DeleteExplainabilityExport.html
     */
    toDeleteExplainabilityExport(): this;
    /**
     * Grants permission to delete a forecast
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_DeleteForecast.html
     */
    toDeleteForecast(): this;
    /**
     * Grants permission to delete an endpoint resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/what-is-forecast.html
     */
    toDeleteForecastEndpoint(): this;
    /**
     * Grants permission to delete a forecast export job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_DeleteForecastExportJob.html
     */
    toDeleteForecastExportJob(): this;
    /**
     * Grants permission to delete a monitor resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_DeleteMonitor.html
     */
    toDeleteMonitor(): this;
    /**
     * Grants permission to delete a predictor
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_DeletePredictor.html
     */
    toDeletePredictor(): this;
    /**
     * Grants permission to delete a predictor backtest export job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_DeletePredictorBacktestExportJob.html
     */
    toDeletePredictorBacktestExportJob(): this;
    /**
     * Grants permission to delete a resource and its child resources
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_DeleteResourceTree.html
     */
    toDeleteResourceTree(): this;
    /**
     * Grants permission to delete a what-if analysis
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_DeleteWhatIfAnalysis.html
     */
    toDeleteWhatIfAnalysis(): this;
    /**
     * Grants permission to delete a what-if forecast
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_DeleteWhatIfForecast.html
     */
    toDeleteWhatIfForecast(): this;
    /**
     * Grants permission to delete a what-if forecast export
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_DeleteWhatIfForecastExport.html
     */
    toDeleteWhatIfForecastExport(): this;
    /**
     * Grants permission to describe an auto predictor
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeAutoPredictor.html
     */
    toDescribeAutoPredictor(): this;
    /**
     * Grants permission to describe a dataset
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeDataset.html
     */
    toDescribeDataset(): this;
    /**
     * Grants permission to describe a dataset group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeDatasetGroup.html
     */
    toDescribeDatasetGroup(): this;
    /**
     * Grants permission to describe a dataset import job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeDatasetImportJob.html
     */
    toDescribeDatasetImportJob(): this;
    /**
     * Grants permission to describe an explainability
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeExplainability.html
     */
    toDescribeExplainability(): this;
    /**
     * Grants permission to describe an explainability export
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeExplainabilityExport.html
     */
    toDescribeExplainabilityExport(): this;
    /**
     * Grants permission to describe a forecast
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeForecast.html
     */
    toDescribeForecast(): this;
    /**
     * Grants permission to describe an endpoint resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/what-is-forecast.html
     */
    toDescribeForecastEndpoint(): this;
    /**
     * Grants permission to describe a forecast export job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeForecastExportJob.html
     */
    toDescribeForecastExportJob(): this;
    /**
     * Grants permission to describe an monitor resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeMonitor.html
     */
    toDescribeMonitor(): this;
    /**
     * Grants permission to describe a predictor
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_DescribePredictor.html
     */
    toDescribePredictor(): this;
    /**
     * Grants permission to describe a predictor backtest export job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_DescribePredictorBacktestExportJob.html
     */
    toDescribePredictorBacktestExportJob(): this;
    /**
     * Grants permission to describe a what-if analysis
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeWhatIfAnalysis.html
     */
    toDescribeWhatIfAnalysis(): this;
    /**
     * Grants permission to describe a what-if forecast
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeWhatIfForecast.html
     */
    toDescribeWhatIfForecast(): this;
    /**
     * Grants permission to describe a what-if forecast export
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeWhatIfForecastExport.html
     */
    toDescribeWhatIfForecastExport(): this;
    /**
     * Grants permission to get the Accuracy Metrics for a predictor
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_GetAccuracyMetrics.html
     */
    toGetAccuracyMetrics(): this;
    /**
     * Grants permission to get the forecast context of a timeseries for an endpoint
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/what-is-forecast.html
     */
    toGetRecentForecastContext(): this;
    /**
     * Grants permission to invoke the endpoint to get forecast for a timeseries
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/what-is-forecast.html
     */
    toInvokeForecastEndpoint(): this;
    /**
     * Grants permission to list all the dataset groups
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_ListDatasetGroups.html
     */
    toListDatasetGroups(): this;
    /**
     * Grants permission to list all the dataset import jobs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_ListDatasetImportJobs.html
     */
    toListDatasetImportJobs(): this;
    /**
     * Grants permission to list all the datasets
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_ListDatasets.html
     */
    toListDatasets(): this;
    /**
     * Grants permission to list all the explainabilities
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_ListExplainabilities.html
     */
    toListExplainabilities(): this;
    /**
     * Grants permission to list all the explainability exports
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_ListExplainabilityExports.html
     */
    toListExplainabilityExports(): this;
    /**
     * Grants permission to list all the forecast export jobs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_ListForecastExportJobs.html
     */
    toListForecastExportJobs(): this;
    /**
     * Grants permission to list all the forecasts
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_ListForecasts.html
     */
    toListForecasts(): this;
    /**
     * Grants permission to list all the monitor evaluation result for a monitor
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_ListMonitorEvaluations.html
     */
    toListMonitorEvaluations(): this;
    /**
     * Grants permission to list all the monitor resources
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_ListMonitors.html
     */
    toListMonitors(): this;
    /**
     * Grants permission to list all the predictor backtest export jobs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_ListPredictorBacktestExportJobs.html
     */
    toListPredictorBacktestExportJobs(): this;
    /**
     * Grants permission to list all the predictors
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_ListPredictors.html
     */
    toListPredictors(): this;
    /**
     * Grants permission to list the tags for an Amazon Forecast resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to list all the what-if analyses
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_ListWhatIfAnalyses.html
     */
    toListWhatIfAnalyses(): this;
    /**
     * Grants permission to list all the what-if forecast exports
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_ListWhatIfForecastExports.html
     */
    toListWhatIfForecastExports(): this;
    /**
     * Grants permission to list all the what-if forecasts
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_ListWhatIfForecasts.html
     */
    toListWhatIfForecasts(): this;
    /**
     * Grants permission to retrieve a forecast for a single item
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_forecastquery_QueryForecast.html
     */
    toQueryForecast(): this;
    /**
     * Grants permission to retrieve a what-if forecast for a single item
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_forecastquery_QueryWhatIfForecast.html
     */
    toQueryWhatIfForecast(): this;
    /**
     * Grants permission to resume Amazon Forecast resource jobs
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_ResumeResource.html
     */
    toResumeResource(): this;
    /**
     * Grants permission to stop Amazon Forecast resource jobs
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_StopResource.html
     */
    toStopResource(): this;
    /**
     * Grants permission to associate the specified tags to a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to delete the specified tags for a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update a dataset group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_UpdateDatasetGroup.html
     */
    toUpdateDatasetGroup(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type dataset to the statement
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDataset.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDataset(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type datasetGroup to the statement
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDatasetGroup.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDatasetGroup(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type datasetImportJob to the statement
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDatasetImportJob.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDatasetImportJob(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type algorithm to the statement
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/aws-forecast-choosing-recipes.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onAlgorithm(resourceId: string, partition?: string): this;
    /**
     * Adds a resource of type predictor to the statement
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_CreatePredictor.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onPredictor(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type predictorBacktestExportJob to the statement
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_CreatePredictorBacktestExportJob.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onPredictorBacktestExportJob(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type forecast to the statement
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_CreateForecast.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onForecast(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type forecastExport to the statement
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_CreateForecastExportJob.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onForecastExport(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type explainability to the statement
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_CreateExplainability.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onExplainability(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type explainabilityExport to the statement
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_CreateExplainabilityExport.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onExplainabilityExport(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type monitor to the statement
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_CreateMonitor.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onMonitor(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type whatIfAnalysis to the statement
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_CreateWhatIfAnalysis.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onWhatIfAnalysis(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type whatIfForecast to the statement
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_CreateWhatIfForecast.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onWhatIfForecast(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type whatIfForecastExport to the statement
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_CreateWhatIfForecastExport.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onWhatIfForecastExport(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type endpoint to the statement
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/what-is-forecast.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onEndpoint(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the tags that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateAutoPredictor()
     * - .toCreateDataset()
     * - .toCreateDatasetGroup()
     * - .toCreateDatasetImportJob()
     * - .toCreateExplainability()
     * - .toCreateExplainabilityExport()
     * - .toCreateForecast()
     * - .toCreateForecastEndpoint()
     * - .toCreateForecastExportJob()
     * - .toCreateMonitor()
     * - .toCreatePredictor()
     * - .toCreatePredictorBacktestExportJob()
     * - .toCreateWhatIfAnalysis()
     * - .toCreateWhatIfForecast()
     * - .toCreateWhatIfForecastExport()
     * - .toResumeResource()
     * - .toStopResource()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tags associated with the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to resource types:
     * - dataset
     * - datasetGroup
     * - datasetImportJob
     * - predictor
     * - predictorBacktestExportJob
     * - forecast
     * - forecastExport
     * - explainability
     * - explainabilityExport
     * - monitor
     * - whatIfAnalysis
     * - whatIfForecast
     * - whatIfForecastExport
     * - endpoint
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tag keys that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateAutoPredictor()
     * - .toCreateDataset()
     * - .toCreateDatasetGroup()
     * - .toCreateDatasetImportJob()
     * - .toCreateExplainability()
     * - .toCreateExplainabilityExport()
     * - .toCreateForecast()
     * - .toCreateForecastEndpoint()
     * - .toCreateForecastExportJob()
     * - .toCreateMonitor()
     * - .toCreatePredictor()
     * - .toCreatePredictorBacktestExportJob()
     * - .toCreateWhatIfAnalysis()
     * - .toCreateWhatIfForecast()
     * - .toCreateWhatIfForecastExport()
     * - .toResumeResource()
     * - .toStopResource()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [forecast](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonforecast.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
