import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [identitystore-auth](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsidentitystoreauth.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class IdentitystoreAuth extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to delete a batch of specified sessions
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/manage-app-session.html
     */
    toBatchDeleteSession(): this;
    /**
     * Grants permission to return session attributes for a batch of specified sessions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/manage-app-session.html
     */
    toBatchGetSession(): this;
    /**
     * Grants permission to retrieve a list of active sessions for the specified user
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/manage-app-session.html
     */
    toListSessions(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Statement provider for service [identitystore-auth](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsidentitystoreauth.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
