import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [lakeformation](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awslakeformation.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Lakeformation extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to attach Lake Formation tags to catalog resources
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_AddLFTagsToResource.html
     */
    toAddLFTagsToResource(): this;
    /**
     * Grants permission to data lake permissions to one or more principals in a batch
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_BatchGrantPermissions.html
     */
    toBatchGrantPermissions(): this;
    /**
     * Grants permission to revoke data lake permissions from one or more principals in a batch
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_BatchRevokePermissions.html
     */
    toBatchRevokePermissions(): this;
    /**
     * Grants permission to cancel the given transaction
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_CancelTransaction.html
     */
    toCancelTransaction(): this;
    /**
     * Grants permission to commit the given transaction
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_CommitTransaction.html
     */
    toCommitTransaction(): this;
    /**
     * Grants permission to create a Lake Formation data cell filter
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_CreateDataCellsFilter.html
     */
    toCreateDataCellsFilter(): this;
    /**
     * Grants permission to create a Lake Formation tag
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_CreateLFTag.html
     */
    toCreateLFTag(): this;
    /**
     * Grants permission to create a Lake Formation tag expression
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_CreateLFTagExpression.html
     */
    toCreateLFTagExpression(): this;
    /**
     * Grants permission to create an IAM Identity Center connection with Lake Formation to allow IAM Identity Center users and groups to access Data Catalog resources
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_CreateLakeFormationIdentityCenterConfiguration.html
     */
    toCreateLakeFormationIdentityCenterConfiguration(): this;
    /**
     * Grants permission to enforce Lake Formation permissions for the given databases, tables, and principals
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_CreateLakeFormationOptIn.html
     */
    toCreateLakeFormationOptIn(): this;
    /**
     * Grants permission to delete a Lake Formation data cell filter
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_DeleteDataCellsFilter.html
     */
    toDeleteDataCellsFilter(): this;
    /**
     * Grants permission to delete a Lake Formation tag
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_DeleteLFTag.html
     */
    toDeleteLFTag(): this;
    /**
     * Grants permission to delete a Lake Formation expression
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_DeleteLFTagExpression.html
     */
    toDeleteLFTagExpression(): this;
    /**
     * Grants permission to delete an IAM Identity Center connection with Lake Formation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_DeleteLakeFormationIdentityCenterConfiguration.html
     */
    toDeleteLakeFormationIdentityCenterConfiguration(): this;
    /**
     * Grants permission to remove the Lake Formation permissions enforcement of the given databases, tables, and principals
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_DeleteLakeFormationOptIn.html
     */
    toDeleteLakeFormationOptIn(): this;
    /**
     * Grants permission to delete the specified objects if the transaction is canceled
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_DeleteObjectsOnCancel.html
     */
    toDeleteObjectsOnCancel(): this;
    /**
     * Grants permission to deregister a registered location
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_DeregisterResource.html
     */
    toDeregisterResource(): this;
    /**
     * Grants permission to describe the IAM Identity Center connection with Lake Formation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_DescribeLakeFormationIdentityCenterConfiguration.html
     */
    toDescribeLakeFormationIdentityCenterConfiguration(): this;
    /**
     * Grants permission to describe a registered location
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_DescribeResource.html
     */
    toDescribeResource(): this;
    /**
     * Grants permission to get status of the given transaction
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_DescribeTransaction.html
     */
    toDescribeTransaction(): this;
    /**
     * Grants permission to extend the timeout of the given transaction
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_ExtendTransaction.html
     */
    toExtendTransaction(): this;
    /**
     * Grants permission to virtual data lake access
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifEnabledOnlyForMetaDataAccess()
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/access-control-underlying-data.html
     */
    toGetDataAccess(): this;
    /**
     * Grants permission to retrieve a Lake Formation data cell filter
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_GetDataCellsFilter.html
     */
    toGetDataCellsFilter(): this;
    /**
     * Grants permission to retrieve the identity of the invoking principal
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_GetDataLakePrincipal.html
     */
    toGetDataLakePrincipal(): this;
    /**
     * Grants permission to retrieve data lake settings such as the list of data lake administrators and database and table default permissions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_GetDataLakeSettings.html
     */
    toGetDataLakeSettings(): this;
    /**
     * Grants permission to retrieve permissions attached to resources in the given path
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_GetEffectivePermissionsForPath.html
     */
    toGetEffectivePermissionsForPath(): this;
    /**
     * Grants permission to retrieve a Lake Formation tag
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_GetLFTag.html
     */
    toGetLFTag(): this;
    /**
     * Grants permission to retrieve a Lake Formation tag expression
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_GetLFTagExpression.html
     */
    toGetLFTagExpression(): this;
    /**
     * Grants permission to retrieve the state of the given query
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - lakeformation:StartQueryPlanning
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_GetQueryState.html
     */
    toGetQueryState(): this;
    /**
     * Grants permission to retrieve the statistics for the given query
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - lakeformation:StartQueryPlanning
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_GetQueryStatistics.html
     */
    toGetQueryStatistics(): this;
    /**
     * Grants permission to retrieve lakeformation tags on a catalog resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_GetResourceLFTags.html
     */
    toGetResourceLFTags(): this;
    /**
     * Grants permission to retrieve objects from a table
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_GetTableObjects.html
     */
    toGetTableObjects(): this;
    /**
     * Grants permission to retrieve the results for the given work units
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - lakeformation:GetWorkUnits
     * - lakeformation:StartQueryPlanning
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_GetWorkUnitResults.html
     */
    toGetWorkUnitResults(): this;
    /**
     * Grants permission to retrieve the work units for the given query
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - lakeformation:StartQueryPlanning
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_GetWorkUnits.html
     */
    toGetWorkUnits(): this;
    /**
     * Grants permission to data lake permissions to a principal
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_GrantPermissions.html
     */
    toGrantPermissions(): this;
    /**
     * Grants permission to list cell filters
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_ListDataCellsFilter.html
     */
    toListDataCellsFilter(): this;
    /**
     * Grants permission to list Lake Foramtion tag expressions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_ListLFTagExpressions.html
     */
    toListLFTagExpressions(): this;
    /**
     * Grants permission to list Lake Formation tags
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_ListLFTags.html
     */
    toListLFTags(): this;
    /**
     * Grants permission to retrieve the current list of resources and principals that are opt in to enforce Lake Formation permissions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_ListLakeFormationOptIns.html
     */
    toListLakeFormationOptIns(): this;
    /**
     * Grants permission to list permissions filtered by principal or resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_ListPermissions.html
     */
    toListPermissions(): this;
    /**
     * Grants permission to List registered locations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_ListResources.html
     */
    toListResources(): this;
    /**
     * Grants permission to list all the storage optimizers for the Governed table
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_ListTableStorageOptimizers.html
     */
    toListTableStorageOptimizers(): this;
    /**
     * Grants permission to list all transactions in the system
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_ListTransactions.html
     */
    toListTransactions(): this;
    /**
     * Grants permission to overwrite data lake settings such as the list of data lake administrators and database and table default permissions
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_PutDataLakeSettings.html
     */
    toPutDataLakeSettings(): this;
    /**
     * Grants permission to register a new location to be managed by Lake Formation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_RegisterResource.html
     */
    toRegisterResource(): this;
    /**
     * Grants permission to register a new location to be managed by Lake Formation, with privileged access
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_RegisterResource.html
     */
    toRegisterResourceWithPrivilegedAccess(): this;
    /**
     * Grants permission to remove lakeformation tags from catalog resources
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_RemoveLFTagsFromResource.html
     */
    toRemoveLFTagsFromResource(): this;
    /**
     * Grants permission to revoke data lake permissions from a principal
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_RevokePermissions.html
     */
    toRevokePermissions(): this;
    /**
     * Grants permission to list catalog databases with Lake Formation tags
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_SearchTablesByLFTags.html
     */
    toSearchDatabasesByLFTags(): this;
    /**
     * Grants permission to list catalog tables with Lake Formation tags
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_SearchTablesByLFTags.html
     */
    toSearchTablesByLFTags(): this;
    /**
     * Grants permission to initiate the planning of the given query
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_StartQueryPlanning.html
     */
    toStartQueryPlanning(): this;
    /**
     * Grants permission to start a new transaction
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_StartTransaction.html
     */
    toStartTransaction(): this;
    /**
     * Grants permission to update a Lake Formation data cell filter
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_UpdateDataCellsFilter.html
     */
    toUpdateDataCellsFilter(): this;
    /**
     * Grants permission to update a Lake Formation tag
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_UpdateLFTag.html
     */
    toUpdateLFTag(): this;
    /**
     * Grants permission to update a Lake Formation expression
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_UpdateLFTagExpression.html
     */
    toUpdateLFTagExpression(): this;
    /**
     * Grants permission to update the IAM Identity Center connection parameters
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_UpdateLakeFormationIdentityCenterConfiguration.html
     */
    toUpdateLakeFormationIdentityCenterConfiguration(): this;
    /**
     * Grants permission to update a registered location
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_UpdateResource.html
     */
    toUpdateResource(): this;
    /**
     * Grants permission to add or delete the specified objects to or from a table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_UpdateTableObjects.html
     */
    toUpdateTableObjects(): this;
    /**
     * Grants permission to update the configuration of the storage optimizer for the Governed table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_UpdateTableStorageOptimizer.html
     */
    toUpdateTableStorageOptimizer(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Filters access by the presence of the key configured for role's identity-based policy
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awslakeformation.html#awslakeformation-policy-keys
     *
     * Applies to actions:
     * - .toGetDataAccess()
     *
     * @param value `true` or `false`. **Default:** `true`
     */
    ifEnabledOnlyForMetaDataAccess(value?: boolean): this;
    /**
     * Statement provider for service [lakeformation](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awslakeformation.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
