"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Lakeformation = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [lakeformation](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awslakeformation.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Lakeformation extends shared_1.PolicyStatement {
    /**
     * Grants permission to attach Lake Formation tags to catalog resources
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_AddLFTagsToResource.html
     */
    toAddLFTagsToResource() {
        return this.to('AddLFTagsToResource');
    }
    /**
     * Grants permission to data lake permissions to one or more principals in a batch
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_BatchGrantPermissions.html
     */
    toBatchGrantPermissions() {
        return this.to('BatchGrantPermissions');
    }
    /**
     * Grants permission to revoke data lake permissions from one or more principals in a batch
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_BatchRevokePermissions.html
     */
    toBatchRevokePermissions() {
        return this.to('BatchRevokePermissions');
    }
    /**
     * Grants permission to cancel the given transaction
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_CancelTransaction.html
     */
    toCancelTransaction() {
        return this.to('CancelTransaction');
    }
    /**
     * Grants permission to commit the given transaction
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_CommitTransaction.html
     */
    toCommitTransaction() {
        return this.to('CommitTransaction');
    }
    /**
     * Grants permission to create a Lake Formation data cell filter
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_CreateDataCellsFilter.html
     */
    toCreateDataCellsFilter() {
        return this.to('CreateDataCellsFilter');
    }
    /**
     * Grants permission to create a Lake Formation tag
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_CreateLFTag.html
     */
    toCreateLFTag() {
        return this.to('CreateLFTag');
    }
    /**
     * Grants permission to create a Lake Formation tag expression
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_CreateLFTagExpression.html
     */
    toCreateLFTagExpression() {
        return this.to('CreateLFTagExpression');
    }
    /**
     * Grants permission to create an IAM Identity Center connection with Lake Formation to allow IAM Identity Center users and groups to access Data Catalog resources
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_CreateLakeFormationIdentityCenterConfiguration.html
     */
    toCreateLakeFormationIdentityCenterConfiguration() {
        return this.to('CreateLakeFormationIdentityCenterConfiguration');
    }
    /**
     * Grants permission to enforce Lake Formation permissions for the given databases, tables, and principals
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_CreateLakeFormationOptIn.html
     */
    toCreateLakeFormationOptIn() {
        return this.to('CreateLakeFormationOptIn');
    }
    /**
     * Grants permission to delete a Lake Formation data cell filter
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_DeleteDataCellsFilter.html
     */
    toDeleteDataCellsFilter() {
        return this.to('DeleteDataCellsFilter');
    }
    /**
     * Grants permission to delete a Lake Formation tag
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_DeleteLFTag.html
     */
    toDeleteLFTag() {
        return this.to('DeleteLFTag');
    }
    /**
     * Grants permission to delete a Lake Formation expression
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_DeleteLFTagExpression.html
     */
    toDeleteLFTagExpression() {
        return this.to('DeleteLFTagExpression');
    }
    /**
     * Grants permission to delete an IAM Identity Center connection with Lake Formation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_DeleteLakeFormationIdentityCenterConfiguration.html
     */
    toDeleteLakeFormationIdentityCenterConfiguration() {
        return this.to('DeleteLakeFormationIdentityCenterConfiguration');
    }
    /**
     * Grants permission to remove the Lake Formation permissions enforcement of the given databases, tables, and principals
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_DeleteLakeFormationOptIn.html
     */
    toDeleteLakeFormationOptIn() {
        return this.to('DeleteLakeFormationOptIn');
    }
    /**
     * Grants permission to delete the specified objects if the transaction is canceled
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_DeleteObjectsOnCancel.html
     */
    toDeleteObjectsOnCancel() {
        return this.to('DeleteObjectsOnCancel');
    }
    /**
     * Grants permission to deregister a registered location
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_DeregisterResource.html
     */
    toDeregisterResource() {
        return this.to('DeregisterResource');
    }
    /**
     * Grants permission to describe the IAM Identity Center connection with Lake Formation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_DescribeLakeFormationIdentityCenterConfiguration.html
     */
    toDescribeLakeFormationIdentityCenterConfiguration() {
        return this.to('DescribeLakeFormationIdentityCenterConfiguration');
    }
    /**
     * Grants permission to describe a registered location
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_DescribeResource.html
     */
    toDescribeResource() {
        return this.to('DescribeResource');
    }
    /**
     * Grants permission to get status of the given transaction
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_DescribeTransaction.html
     */
    toDescribeTransaction() {
        return this.to('DescribeTransaction');
    }
    /**
     * Grants permission to extend the timeout of the given transaction
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_ExtendTransaction.html
     */
    toExtendTransaction() {
        return this.to('ExtendTransaction');
    }
    /**
     * Grants permission to virtual data lake access
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifEnabledOnlyForMetaDataAccess()
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/access-control-underlying-data.html
     */
    toGetDataAccess() {
        return this.to('GetDataAccess');
    }
    /**
     * Grants permission to retrieve a Lake Formation data cell filter
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_GetDataCellsFilter.html
     */
    toGetDataCellsFilter() {
        return this.to('GetDataCellsFilter');
    }
    /**
     * Grants permission to retrieve the identity of the invoking principal
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_GetDataLakePrincipal.html
     */
    toGetDataLakePrincipal() {
        return this.to('GetDataLakePrincipal');
    }
    /**
     * Grants permission to retrieve data lake settings such as the list of data lake administrators and database and table default permissions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_GetDataLakeSettings.html
     */
    toGetDataLakeSettings() {
        return this.to('GetDataLakeSettings');
    }
    /**
     * Grants permission to retrieve permissions attached to resources in the given path
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_GetEffectivePermissionsForPath.html
     */
    toGetEffectivePermissionsForPath() {
        return this.to('GetEffectivePermissionsForPath');
    }
    /**
     * Grants permission to retrieve a Lake Formation tag
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_GetLFTag.html
     */
    toGetLFTag() {
        return this.to('GetLFTag');
    }
    /**
     * Grants permission to retrieve a Lake Formation tag expression
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_GetLFTagExpression.html
     */
    toGetLFTagExpression() {
        return this.to('GetLFTagExpression');
    }
    /**
     * Grants permission to retrieve the state of the given query
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - lakeformation:StartQueryPlanning
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_GetQueryState.html
     */
    toGetQueryState() {
        return this.to('GetQueryState');
    }
    /**
     * Grants permission to retrieve the statistics for the given query
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - lakeformation:StartQueryPlanning
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_GetQueryStatistics.html
     */
    toGetQueryStatistics() {
        return this.to('GetQueryStatistics');
    }
    /**
     * Grants permission to retrieve lakeformation tags on a catalog resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_GetResourceLFTags.html
     */
    toGetResourceLFTags() {
        return this.to('GetResourceLFTags');
    }
    /**
     * Grants permission to retrieve objects from a table
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_GetTableObjects.html
     */
    toGetTableObjects() {
        return this.to('GetTableObjects');
    }
    /**
     * Grants permission to retrieve the results for the given work units
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - lakeformation:GetWorkUnits
     * - lakeformation:StartQueryPlanning
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_GetWorkUnitResults.html
     */
    toGetWorkUnitResults() {
        return this.to('GetWorkUnitResults');
    }
    /**
     * Grants permission to retrieve the work units for the given query
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - lakeformation:StartQueryPlanning
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_GetWorkUnits.html
     */
    toGetWorkUnits() {
        return this.to('GetWorkUnits');
    }
    /**
     * Grants permission to data lake permissions to a principal
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_GrantPermissions.html
     */
    toGrantPermissions() {
        return this.to('GrantPermissions');
    }
    /**
     * Grants permission to list cell filters
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_ListDataCellsFilter.html
     */
    toListDataCellsFilter() {
        return this.to('ListDataCellsFilter');
    }
    /**
     * Grants permission to list Lake Foramtion tag expressions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_ListLFTagExpressions.html
     */
    toListLFTagExpressions() {
        return this.to('ListLFTagExpressions');
    }
    /**
     * Grants permission to list Lake Formation tags
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_ListLFTags.html
     */
    toListLFTags() {
        return this.to('ListLFTags');
    }
    /**
     * Grants permission to retrieve the current list of resources and principals that are opt in to enforce Lake Formation permissions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_ListLakeFormationOptIns.html
     */
    toListLakeFormationOptIns() {
        return this.to('ListLakeFormationOptIns');
    }
    /**
     * Grants permission to list permissions filtered by principal or resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_ListPermissions.html
     */
    toListPermissions() {
        return this.to('ListPermissions');
    }
    /**
     * Grants permission to List registered locations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_ListResources.html
     */
    toListResources() {
        return this.to('ListResources');
    }
    /**
     * Grants permission to list all the storage optimizers for the Governed table
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_ListTableStorageOptimizers.html
     */
    toListTableStorageOptimizers() {
        return this.to('ListTableStorageOptimizers');
    }
    /**
     * Grants permission to list all transactions in the system
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_ListTransactions.html
     */
    toListTransactions() {
        return this.to('ListTransactions');
    }
    /**
     * Grants permission to overwrite data lake settings such as the list of data lake administrators and database and table default permissions
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_PutDataLakeSettings.html
     */
    toPutDataLakeSettings() {
        return this.to('PutDataLakeSettings');
    }
    /**
     * Grants permission to register a new location to be managed by Lake Formation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_RegisterResource.html
     */
    toRegisterResource() {
        return this.to('RegisterResource');
    }
    /**
     * Grants permission to register a new location to be managed by Lake Formation, with privileged access
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_RegisterResource.html
     */
    toRegisterResourceWithPrivilegedAccess() {
        return this.to('RegisterResourceWithPrivilegedAccess');
    }
    /**
     * Grants permission to remove lakeformation tags from catalog resources
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_RemoveLFTagsFromResource.html
     */
    toRemoveLFTagsFromResource() {
        return this.to('RemoveLFTagsFromResource');
    }
    /**
     * Grants permission to revoke data lake permissions from a principal
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_RevokePermissions.html
     */
    toRevokePermissions() {
        return this.to('RevokePermissions');
    }
    /**
     * Grants permission to list catalog databases with Lake Formation tags
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_SearchTablesByLFTags.html
     */
    toSearchDatabasesByLFTags() {
        return this.to('SearchDatabasesByLFTags');
    }
    /**
     * Grants permission to list catalog tables with Lake Formation tags
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_SearchTablesByLFTags.html
     */
    toSearchTablesByLFTags() {
        return this.to('SearchTablesByLFTags');
    }
    /**
     * Grants permission to initiate the planning of the given query
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_StartQueryPlanning.html
     */
    toStartQueryPlanning() {
        return this.to('StartQueryPlanning');
    }
    /**
     * Grants permission to start a new transaction
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_StartTransaction.html
     */
    toStartTransaction() {
        return this.to('StartTransaction');
    }
    /**
     * Grants permission to update a Lake Formation data cell filter
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_UpdateDataCellsFilter.html
     */
    toUpdateDataCellsFilter() {
        return this.to('UpdateDataCellsFilter');
    }
    /**
     * Grants permission to update a Lake Formation tag
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_UpdateLFTag.html
     */
    toUpdateLFTag() {
        return this.to('UpdateLFTag');
    }
    /**
     * Grants permission to update a Lake Formation expression
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_UpdateLFTagExpression.html
     */
    toUpdateLFTagExpression() {
        return this.to('UpdateLFTagExpression');
    }
    /**
     * Grants permission to update the IAM Identity Center connection parameters
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_UpdateLakeFormationIdentityCenterConfiguration.html
     */
    toUpdateLakeFormationIdentityCenterConfiguration() {
        return this.to('UpdateLakeFormationIdentityCenterConfiguration');
    }
    /**
     * Grants permission to update a registered location
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_UpdateResource.html
     */
    toUpdateResource() {
        return this.to('UpdateResource');
    }
    /**
     * Grants permission to add or delete the specified objects to or from a table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_UpdateTableObjects.html
     */
    toUpdateTableObjects() {
        return this.to('UpdateTableObjects');
    }
    /**
     * Grants permission to update the configuration of the storage optimizer for the Governed table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/APIReference/API_UpdateTableStorageOptimizer.html
     */
    toUpdateTableStorageOptimizer() {
        return this.to('UpdateTableStorageOptimizer');
    }
    /**
     * Filters access by the presence of the key configured for role's identity-based policy
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awslakeformation.html#awslakeformation-policy-keys
     *
     * Applies to actions:
     * - .toGetDataAccess()
     *
     * @param value `true` or `false`. **Default:** `true`
     */
    ifEnabledOnlyForMetaDataAccess(value) {
        return this.if(`EnabledOnlyForMetaDataAccess`, (typeof value !== 'undefined' ? value : true), 'Bool');
    }
    /**
     * Statement provider for service [lakeformation](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awslakeformation.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'lakeformation';
        this.accessLevelList = {
            Tagging: [
                'AddLFTagsToResource',
                'RemoveLFTagsFromResource'
            ],
            'Permissions management': [
                'BatchGrantPermissions',
                'BatchRevokePermissions',
                'GrantPermissions',
                'PutDataLakeSettings',
                'RevokePermissions'
            ],
            Write: [
                'CancelTransaction',
                'CommitTransaction',
                'CreateDataCellsFilter',
                'CreateLFTag',
                'CreateLFTagExpression',
                'CreateLakeFormationIdentityCenterConfiguration',
                'CreateLakeFormationOptIn',
                'DeleteDataCellsFilter',
                'DeleteLFTag',
                'DeleteLFTagExpression',
                'DeleteLakeFormationIdentityCenterConfiguration',
                'DeleteLakeFormationOptIn',
                'DeleteObjectsOnCancel',
                'DeregisterResource',
                'ExtendTransaction',
                'GetDataAccess',
                'RegisterResource',
                'RegisterResourceWithPrivilegedAccess',
                'StartQueryPlanning',
                'StartTransaction',
                'UpdateDataCellsFilter',
                'UpdateLFTag',
                'UpdateLFTagExpression',
                'UpdateLakeFormationIdentityCenterConfiguration',
                'UpdateResource',
                'UpdateTableObjects',
                'UpdateTableStorageOptimizer'
            ],
            Read: [
                'DescribeLakeFormationIdentityCenterConfiguration',
                'DescribeResource',
                'DescribeTransaction',
                'GetDataCellsFilter',
                'GetDataLakePrincipal',
                'GetDataLakeSettings',
                'GetEffectivePermissionsForPath',
                'GetLFTag',
                'GetLFTagExpression',
                'GetQueryState',
                'GetQueryStatistics',
                'GetResourceLFTags',
                'GetTableObjects',
                'GetWorkUnitResults',
                'GetWorkUnits',
                'ListLFTagExpressions',
                'ListLFTags',
                'SearchDatabasesByLFTags',
                'SearchTablesByLFTags'
            ],
            List: [
                'ListDataCellsFilter',
                'ListLakeFormationOptIns',
                'ListPermissions',
                'ListResources',
                'ListTableStorageOptimizers',
                'ListTransactions'
            ]
        };
    }
}
exports.Lakeformation = Lakeformation;
//# sourceMappingURL=data:application/json;base64,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