import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [lex-v2](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlexv2.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class LexV2 extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to create new items in an existing custom vocabulary
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_BatchCreateCustomVocabularyItem.html
     */
    toBatchCreateCustomVocabularyItem(): this;
    /**
     * Grants permission to delete existing items in an existing custom vocabulary
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_BatchDeleteCustomVocabularyItem.html
     */
    toBatchDeleteCustomVocabularyItem(): this;
    /**
     * Grants permission to update existing items in an existing custom vocabulary
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_BatchUpdateCustomVocabularyItem.html
     */
    toBatchUpdateCustomVocabularyItem(): this;
    /**
     * Grants permission to build an existing bot locale in a bot
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_BuildBotLocale.html
     */
    toBuildBotLocale(): this;
    /**
     * Grants permission to create a new bot and a test bot alias pointing to the DRAFT bot version
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_CreateBot.html
     */
    toCreateBot(): this;
    /**
     * Grants permission to create a new bot alias in a bot
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_CreateBotAlias.html
     */
    toCreateBotAlias(): this;
    /**
     * Grants permission to create a bot channel in an existing bot
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/deploying-messaging-platform.html
     */
    toCreateBotChannel(): this;
    /**
     * Grants permission to create a new bot locale in an existing bot
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_CreateBotLocale.html
     */
    toCreateBotLocale(): this;
    /**
     * Grants permission to create bot replica for a bot
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_CreateBotReplica.html
     */
    toCreateBotReplica(): this;
    /**
     * Grants permission to create a new version of an existing bot
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_CreateBotVersion.html
     */
    toCreateBotVersion(): this;
    /**
     * Grants permission to create a new custom vocabulary in an existing bot locale
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/vocab.html
     */
    toCreateCustomVocabulary(): this;
    /**
     * Grants permission to create an export for an existing resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_CreateExport.html
     */
    toCreateExport(): this;
    /**
     * Grants permission to create a new intent in an existing bot locale
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_CreateIntent.html
     */
    toCreateIntent(): this;
    /**
     * Grants permission to create a new resource policy for a Lex resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_CreateResourcePolicy.html
     */
    toCreateResourcePolicy(): this;
    /**
     * Grants permission to create a new slot in an intent
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_CreateSlot.html
     */
    toCreateSlot(): this;
    /**
     * Grants permission to create a new slot type in an existing bot locale
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_CreateSlotType.html
     */
    toCreateSlotType(): this;
    /**
     * Grants permission to import a new test-set
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/create-test-set-from-CSV.html
     */
    toCreateTestSet(): this;
    /**
     * Grants permission to create a test set discrepancy report
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_CreateTestSetDiscrepancyReport.html
     */
    toCreateTestSetDiscrepancyReport(): this;
    /**
     * Grants permission to create an upload url for import file
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_CreateUploadUrl.html
     */
    toCreateUploadUrl(): this;
    /**
     * Grants permission to delete an existing bot
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - lex:DeleteBotAlias
     * - lex:DeleteBotChannel
     * - lex:DeleteBotLocale
     * - lex:DeleteBotVersion
     * - lex:DeleteIntent
     * - lex:DeleteSlot
     * - lex:DeleteSlotType
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DeleteBot.html
     */
    toDeleteBot(): this;
    /**
     * Grants permission to delete an existing bot alias in a bot
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DeleteBotAlias.html
     */
    toDeleteBotAlias(): this;
    /**
     * Grants permission to delete an existing bot channel
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/deploying-messaging-platform.html
     */
    toDeleteBotChannel(): this;
    /**
     * Grants permission to delete an existing bot locale in a bot
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - lex:DeleteIntent
     * - lex:DeleteSlot
     * - lex:DeleteSlotType
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DeleteBotLocale.html
     */
    toDeleteBotLocale(): this;
    /**
     * Grants permission to delete an existing bot replica
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DeleteBotReplica.html
     */
    toDeleteBotReplica(): this;
    /**
     * Grants permission to delete an existing bot version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DeleteBotVersion.html
     */
    toDeleteBotVersion(): this;
    /**
     * Grants permission to delete an existing custom vocabulary in a bot locale
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DeleteCustomVocabulary.html
     */
    toDeleteCustomVocabulary(): this;
    /**
     * Grants permission to delete an existing export
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DeleteExport.html
     */
    toDeleteExport(): this;
    /**
     * Grants permission to delete an existing import
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DeleteImport.html
     */
    toDeleteImport(): this;
    /**
     * Grants permission to delete an existing intent in a bot locale
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DeleteIntent.html
     */
    toDeleteIntent(): this;
    /**
     * Grants permission to delete an existing resource policy for a Lex resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DeleteResourcePolicy.html
     */
    toDeleteResourcePolicy(): this;
    /**
     * Grants permission to delete session information for a bot alias and user ID
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_runtime_DeleteSession.html
     */
    toDeleteSession(): this;
    /**
     * Grants permission to delete an existing slot in an intent
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DeleteSlot.html
     */
    toDeleteSlot(): this;
    /**
     * Grants permission to delete an existing slot type in a bot locale
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DeleteSlotType.html
     */
    toDeleteSlotType(): this;
    /**
     * Grants permission to delete an existing test set
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DeleteTestSet.html
     */
    toDeleteTestSet(): this;
    /**
     * Grants permission to delete utterance data for a bot
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DeleteUtterances.html
     */
    toDeleteUtterances(): this;
    /**
     * Grants permission to retrieve an existing bot
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeBot.html
     */
    toDescribeBot(): this;
    /**
     * Grants permission to retrieve an existing bot alias
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeBotAlias.html
     */
    toDescribeBotAlias(): this;
    /**
     * Grants permission to retrieve an existing bot channel
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/deploying-messaging-platform.html
     */
    toDescribeBotChannel(): this;
    /**
     * Grants permission to retrieve an existing bot locale
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeBotLocale.html
     */
    toDescribeBotLocale(): this;
    /**
     * Grants permission to retrieve metadata information about a bot recommendation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeBotRecommendation.html
     */
    toDescribeBotRecommendation(): this;
    /**
     * Grants permission to retrieve an existing bot replica
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeBotReplica.html
     */
    toDescribeBotReplica(): this;
    /**
     * Grants permission to retrieve metadata information for a bot resource generation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeBotResourceGeneration.html
     */
    toDescribeBotResourceGeneration(): this;
    /**
     * Grants permission to retrieve an existing bot version
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeBotVersion.html
     */
    toDescribeBotVersion(): this;
    /**
     * Grants permission to retrieve an existing custom vocabulary
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/vocab.html
     */
    toDescribeCustomVocabulary(): this;
    /**
     * Grants permission to retrieve metadata of an existing custom vocabulary
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeCustomVocabularyMetadata.html
     */
    toDescribeCustomVocabularyMetadata(): this;
    /**
     * Grants permission to retrieve an existing export
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - lex:DescribeBot
     * - lex:DescribeBotLocale
     * - lex:DescribeIntent
     * - lex:DescribeSlot
     * - lex:DescribeSlotType
     * - lex:ListBotLocales
     * - lex:ListIntents
     * - lex:ListSlotTypes
     * - lex:ListSlots
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeExport.html
     */
    toDescribeExport(): this;
    /**
     * Grants permission to retrieve an existing import
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeImport.html
     */
    toDescribeImport(): this;
    /**
     * Grants permission to retrieve an existing intent
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeIntent.html
     */
    toDescribeIntent(): this;
    /**
     * Grants permission to retrieve an existing resource policy for a Lex resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeResourcePolicy.html
     */
    toDescribeResourcePolicy(): this;
    /**
     * Grants permission to retrieve an existing slot
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeSlot.html
     */
    toDescribeSlot(): this;
    /**
     * Grants permission to retrieve an existing slot type
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeSlotType.html
     */
    toDescribeSlotType(): this;
    /**
     * Grants permission to retrieve test execution metadata
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeTestExecution.html
     */
    toDescribeTestExecution(): this;
    /**
     * Grants permission to retrieve an existing test set
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeTestSet.html
     */
    toDescribeTestSet(): this;
    /**
     * Grants permission to retrieve test set discrepancy report metadata
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeTestSetDiscrepancyReport.html
     */
    toDescribeTestSetDiscrepancyReport(): this;
    /**
     * Grants permission to retrieve test set generation metadata
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeTestSetGeneration.html
     */
    toDescribeTestSetGeneration(): this;
    /**
     * Grants permission to generate supported fields or elements for a bot
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_GenerateBotElement.html
     */
    toGenerateBotElement(): this;
    /**
     * Grants permission to retrieve session information for a bot alias and user ID
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_runtime_GetSession.html
     */
    toGetSession(): this;
    /**
     * Grants permission to retrieve artifacts URL for a test execution
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_GetTestExecutionArtifactsUrl.html
     */
    toGetTestExecutionArtifactsUrl(): this;
    /**
     * Grants permission to list utterances and statistics for a bot
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListAggregatedUtterances.html
     */
    toListAggregatedUtterances(): this;
    /**
     * Grants permission to list alias replicas in a bot replica
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListBotAliasReplicas.html
     */
    toListBotAliasReplicas(): this;
    /**
     * Grants permission to list bot aliases in an bot
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListBotAliases.html
     */
    toListBotAliases(): this;
    /**
     * Grants permission to list bot channels
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/deploying-messaging-platform.html
     */
    toListBotChannels(): this;
    /**
     * Grants permission to list bot locales in a bot
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListBotLocales.html
     */
    toListBotLocales(): this;
    /**
     * Grants permission to get a list of bot recommendations that meet the specified criteria
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListBotRecommendations.html
     */
    toListBotRecommendations(): this;
    /**
     * Grants permission to list replicas of a bot
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListBotReplicas.html
     */
    toListBotReplicas(): this;
    /**
     * Grants permission to list the resource generations for a bot
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListBotResourceGenerations.html
     */
    toListBotResourceGenerations(): this;
    /**
     * Grants permission to list version replicas in a bot replica
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListBotVersionReplicas.html
     */
    toListBotVersionReplicas(): this;
    /**
     * Grants permission to list existing bot versions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListBotVersions.html
     */
    toListBotVersions(): this;
    /**
     * Grants permission to list existing bots
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListBots.html
     */
    toListBots(): this;
    /**
     * Grants permission to list built-in intents
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListBuiltInIntents.html
     */
    toListBuiltInIntents(): this;
    /**
     * Grants permission to list built-in slot types
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListBuiltInSlotTypes.html
     */
    toListBuiltInSlotTypes(): this;
    /**
     * Grants permission to list items of an existing custom vocabulary
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListCustomVocabularyItems.html
     */
    toListCustomVocabularyItems(): this;
    /**
     * Grants permission to list existing exports
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListExports.html
     */
    toListExports(): this;
    /**
     * Grants permission to list existing imports
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListImports.html
     */
    toListImports(): this;
    /**
     * Grants permission to list intent analytics metrics for a bot
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListIntentMetrics.html
     */
    toListIntentMetrics(): this;
    /**
     * Grants permission to list intent path analytics for a bot
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListIntentPaths.html
     */
    toListIntentPaths(): this;
    /**
     * Grants permission to list intentStage analytics metrics for a bot
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListIntentStageMetrics.html
     */
    toListIntentStageMetrics(): this;
    /**
     * Grants permission to list intents in a bot
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListIntents.html
     */
    toListIntents(): this;
    /**
     * Grants permission to get a list of recommended intents provided by the bot recommendation
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListRecommendedIntents.html
     */
    toListRecommendedIntents(): this;
    /**
     * Grants permission to list session analytics data for a bot
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListSessionAnalyticsData.html
     */
    toListSessionAnalyticsData(): this;
    /**
     * Grants permission to list session analytics metrics for a bot
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListSessionMetrics.html
     */
    toListSessionMetrics(): this;
    /**
     * Grants permission to list slot types in a bot
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListSlotTypes.html
     */
    toListSlotTypes(): this;
    /**
     * Grants permission to list slots in an intent
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListSlots.html
     */
    toListSlots(): this;
    /**
     * Grants permission to lists tags for a Lex resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to retrieve test results data for a test execution
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - lex:ListTestSetRecords
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListTestExecutionResultItems.html
     */
    toListTestExecutionResultItems(): this;
    /**
     * Grants permission to list test executions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListTestExecutions.html
     */
    toListTestExecutions(): this;
    /**
     * Grants permission to retrieve records inside an existing test set
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListTestSetRecords.html
     */
    toListTestSetRecords(): this;
    /**
     * Grants permission to list test sets
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListTestSets.html
     */
    toListTestSets(): this;
    /**
     * Grants permission to create a new session or modify an existing session for a bot alias and user ID
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_runtime_PutSession.html
     */
    toPutSession(): this;
    /**
     * Grants permission to send user input (text-only) to an bot alias
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_runtime_RecognizeText.html
     */
    toRecognizeText(): this;
    /**
     * Grants permission to send user input (text or speech) to an bot alias
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_runtime_RecognizeUtterance.html
     */
    toRecognizeUtterance(): this;
    /**
     * Grants permission to search for associated transcripts that meet the specified criteria
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_SearchAssociatedTranscripts.html
     */
    toSearchAssociatedTranscripts(): this;
    /**
     * Grants permission to start a bot recommendation for an existing bot locale
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_StartBotRecommendation.html
     */
    toStartBotRecommendation(): this;
    /**
     * Grants permission to start a resource generation for an existing bot locale
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_StartBotResourceGeneration.html
     */
    toStartBotResourceGeneration(): this;
    /**
     * Grants permission to stream user input (speech/text/DTMF) to a bot alias
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_runtime_StartConversation.html
     */
    toStartConversation(): this;
    /**
     * Grants permission to start a new import with the uploaded import file
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * Dependent actions:
     * - lex:CreateBot
     * - lex:CreateBotLocale
     * - lex:CreateCustomVocabulary
     * - lex:CreateIntent
     * - lex:CreateSlot
     * - lex:CreateSlotType
     * - lex:CreateTestSet
     * - lex:DeleteBotLocale
     * - lex:DeleteCustomVocabulary
     * - lex:DeleteIntent
     * - lex:DeleteSlot
     * - lex:DeleteSlotType
     * - lex:UpdateBot
     * - lex:UpdateBotLocale
     * - lex:UpdateCustomVocabulary
     * - lex:UpdateIntent
     * - lex:UpdateSlot
     * - lex:UpdateSlotType
     * - lex:UpdateTestSet
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_StartImport.html
     */
    toStartImport(): this;
    /**
     * Grants permission to start a test execution using a test set
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_StartTestExecution.html
     */
    toStartTestExecution(): this;
    /**
     * Grants permission to generate a test set
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_StartTestSetGeneration.html
     */
    toStartTestSetGeneration(): this;
    /**
     * Grants permission to stop a bot recommendation for an existing bot locale
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_StopBotRecommendation.html
     */
    toStopBotRecommendation(): this;
    /**
     * Grants permission to add or overwrite tags of a Lex resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove tags from a Lex resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update an existing bot
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_UpdateBot.html
     */
    toUpdateBot(): this;
    /**
     * Grants permission to update an existing bot alias
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_UpdateBotAlias.html
     */
    toUpdateBotAlias(): this;
    /**
     * Grants permission to update an existing bot locale
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_UpdateBotLocale.html
     */
    toUpdateBotLocale(): this;
    /**
     * Grants permission to update an existing bot recommendation request
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_UpdateBotRecommendation.html
     */
    toUpdateBotRecommendation(): this;
    /**
     * Grants permission to update an existing custom vocabulary
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/vocab.html
     */
    toUpdateCustomVocabulary(): this;
    /**
     * Grants permission to update an existing export
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_UpdateExport.html
     */
    toUpdateExport(): this;
    /**
     * Grants permission to update an existing intent
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_UpdateIntent.html
     */
    toUpdateIntent(): this;
    /**
     * Grants permission to update an existing resource policy for a Lex resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_UpdateResourcePolicy.html
     */
    toUpdateResourcePolicy(): this;
    /**
     * Grants permission to update an existing slot
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_UpdateSlot.html
     */
    toUpdateSlot(): this;
    /**
     * Grants permission to update an existing slot type
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_UpdateSlotType.html
     */
    toUpdateSlotType(): this;
    /**
     * Grants permission to update an existing test set
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/APIReference/API_UpdateTestSet.html
     */
    toUpdateTestSet(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type bot to the statement
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/how-it-works.html
     *
     * @param botId - Identifier for the botId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onBot(botId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type bot alias to the statement
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/how-it-works.html
     *
     * @param botId - Identifier for the botId.
     * @param botAliasId - Identifier for the botAliasId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onBotAlias(botId: string, botAliasId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type test set to the statement
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/test-workbench.html
     *
     * @param testSetId - Identifier for the testSetId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onTestSet(testSetId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the tags in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateBot()
     * - .toCreateBotAlias()
     * - .toStartImport()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tags attached to a Lex resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to resource types:
     * - bot
     * - bot alias
     * - test set
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the set of tag keys in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateBot()
     * - .toCreateBotAlias()
     * - .toStartImport()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [lex-v2](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlexv2.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
