import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [geo-routes](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlocationserviceroutes.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class GeoRoutes extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to determine destinations or service areas reachable within a specified time
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_CalculateIsolines.html
     */
    toCalculateIsolines(): this;
    /**
     * Grants permission to calculate routing matrice which providing travel time and distances between sets of origins and destinations
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_CalculateRouteMatrix.html
     */
    toCalculateRouteMatrix(): this;
    /**
     * Grants permission to calculates routes between two or more locations
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_CalculateRoutes.html
     */
    toCalculateRoutes(): this;
    /**
     * Grants permission to calculate the most efficient sequence for visiting multiple waypoints or locations along a route
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_OptimizeWaypoints.html
     */
    toOptimizeWaypoints(): this;
    /**
     * Grants permission to enhances the accuracy of geographic positioning by aligning GPS coordinates to the nearest road segments on a digital map
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_SnapToRoads.html
     */
    toSnapToRoads(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type provider to the statement
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/Welcome.html
     *
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onProvider(region?: string, partition?: string): this;
    /**
     * Statement provider for service [geo-routes](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlocationserviceroutes.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
