"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Lookoutequipment = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [lookoutequipment](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlookoutforequipment.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Lookoutequipment extends shared_1.PolicyStatement {
    /**
     * Grants permission to create a dataset
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/API_CreateDataset.html
     */
    toCreateDataset() {
        return this.to('CreateDataset');
    }
    /**
     * Grants permission to create an inference scheduler for a trained model
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/API_CreateInferenceScheduler.html
     */
    toCreateInferenceScheduler() {
        return this.to('CreateInferenceScheduler');
    }
    /**
     * Grants permission to create a label
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/API_CreateLabel.html
     */
    toCreateLabel() {
        return this.to('CreateLabel');
    }
    /**
     * Grants permission to create a label group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/API_CreateLabelGroup.html
     */
    toCreateLabelGroup() {
        return this.to('CreateLabelGroup');
    }
    /**
     * Grants permission to create a model that is trained on a dataset
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/API_CreateModel.html
     */
    toCreateModel() {
        return this.to('CreateModel');
    }
    /**
     * Grants permission to create a retraining scheduler for a trained model
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/API_CreateRetrainingScheduler.html
     */
    toCreateRetrainingScheduler() {
        return this.to('CreateRetrainingScheduler');
    }
    /**
     * Grants permission to delete a dataset
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/API_DeleteDataset.html
     */
    toDeleteDataset() {
        return this.to('DeleteDataset');
    }
    /**
     * Grants permission to delete an inference scheduler
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/API_DeleteInferenceScheduler.html
     */
    toDeleteInferenceScheduler() {
        return this.to('DeleteInferenceScheduler');
    }
    /**
     * Grants permission to delete a label
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/API_DeleteLabel.html
     */
    toDeleteLabel() {
        return this.to('DeleteLabel');
    }
    /**
     * Grants permission to delete a label group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/API_DeleteLabelGroup.html
     */
    toDeleteLabelGroup() {
        return this.to('DeleteLabelGroup');
    }
    /**
     * Grants permission to delete a model
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/API_DeleteModel.html
     */
    toDeleteModel() {
        return this.to('DeleteModel');
    }
    /**
     * Grants permission to delete a resource policy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/API_DeleteResourcePolicy.html
     */
    toDeleteResourcePolicy() {
        return this.to('DeleteResourcePolicy');
    }
    /**
     * Grants permission to delete a retraining scheduler of a trained model
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/API_DeleteRetrainingScheduler.html
     */
    toDeleteRetrainingScheduler() {
        return this.to('DeleteRetrainingScheduler');
    }
    /**
     * Grants permission to describe a data ingestion job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/API_DescribeDataIngestionJob.html
     */
    toDescribeDataIngestionJob() {
        return this.to('DescribeDataIngestionJob');
    }
    /**
     * Grants permission to describe a dataset
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/API_DescribeDataset.html
     */
    toDescribeDataset() {
        return this.to('DescribeDataset');
    }
    /**
     * Grants permission to describe an inference scheduler
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/API_DescribeInferenceScheduler.html
     */
    toDescribeInferenceScheduler() {
        return this.to('DescribeInferenceScheduler');
    }
    /**
     * Grants permission to describe a label group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/API_DescribeLabelGroup.html
     */
    toDescribeLabelGroup() {
        return this.to('DescribeLabelGroup');
    }
    /**
     * Grants permission to describe a model
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/API_DescribeModel.html
     */
    toDescribeModel() {
        return this.to('DescribeModel');
    }
    /**
     * Grants permission to describe a model version
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/API_DescribeModelVersion.html
     */
    toDescribeModelVersion() {
        return this.to('DescribeModelVersion');
    }
    /**
     * Grants permission to describe a resource policy
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/API_DescribeResourcePolicy.html
     */
    toDescribeResourcePolicy() {
        return this.to('DescribeResourcePolicy');
    }
    /**
     * Grants permission to describe a retraining scheduler of a trained model
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/API_DescribeRetrainingScheduler.html
     */
    toDescribeRetrainingScheduler() {
        return this.to('DescribeRetrainingScheduler');
    }
    /**
     * Grants permission to describe a label
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/API_DescribeLabel.html
     */
    toDescribelabel() {
        return this.to('Describelabel');
    }
    /**
     * Grants permission to import a dataset
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/API_ImportDataset.html
     */
    toImportDataset() {
        return this.to('ImportDataset');
    }
    /**
     * Grants permission to import a model version
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifIsImportingData()
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/API_ImportModelVersion.html
     */
    toImportModelVersion() {
        return this.to('ImportModelVersion');
    }
    /**
     * Grants permission to list the data ingestion jobs in your account or for a particular dataset
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/API_ListDataIngestionJobs.html
     */
    toListDataIngestionJobs() {
        return this.to('ListDataIngestionJobs');
    }
    /**
     * Grants permission to list the datasets in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/API_ListDatasets.html
     */
    toListDatasets() {
        return this.to('ListDatasets');
    }
    /**
     * Grants permission to list the inference events for an inference scheduler
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/API_ListInferenceEvents.html
     */
    toListInferenceEvents() {
        return this.to('ListInferenceEvents');
    }
    /**
     * Grants permission to list the inference executions for an inference scheduler
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/API_ListInferenceExecutions.html
     */
    toListInferenceExecutions() {
        return this.to('ListInferenceExecutions');
    }
    /**
     * Grants permission to list the inference schedulers in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/API_ListInferenceSchedulers.html
     */
    toListInferenceSchedulers() {
        return this.to('ListInferenceSchedulers');
    }
    /**
     * Grants permission to list the label groups in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/API_ListLabelGroups.html
     */
    toListLabelGroups() {
        return this.to('ListLabelGroups');
    }
    /**
     * Grants permission to list the labels in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/API_ListLabels.html
     */
    toListLabels() {
        return this.to('ListLabels');
    }
    /**
     * Grants permission to list the model versions in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/API_ListModelVersions.html
     */
    toListModelVersions() {
        return this.to('ListModelVersions');
    }
    /**
     * Grants permission to list the models in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/API_ListModels.html
     */
    toListModels() {
        return this.to('ListModels');
    }
    /**
     * Grants permission to list the retraining schedulers in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/API_ListRetrainingSchedulers.html
     */
    toListRetrainingSchedulers() {
        return this.to('ListRetrainingSchedulers');
    }
    /**
     * Grants permission to list the sensor statistics for a particular dataset or an ingestion job
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/API_ListSensorStatistics.html
     */
    toListSensorStatistics() {
        return this.to('ListSensorStatistics');
    }
    /**
     * Grants permission to list the tags for a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to put a resource policy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/API_PutResourcePolicy.html
     */
    toPutResourcePolicy() {
        return this.to('PutResourcePolicy');
    }
    /**
     * Grants permission to start a data ingestion job for a dataset
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/API_StartDataIngestionJob.html
     */
    toStartDataIngestionJob() {
        return this.to('StartDataIngestionJob');
    }
    /**
     * Grants permission to start an inference scheduler
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/API_StartInferenceScheduler.html
     */
    toStartInferenceScheduler() {
        return this.to('StartInferenceScheduler');
    }
    /**
     * Grants permission to start a retraining scheduler of a trained model
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/API_StartRetrainingScheduler.html
     */
    toStartRetrainingScheduler() {
        return this.to('StartRetrainingScheduler');
    }
    /**
     * Grants permission to stop an inference scheduler
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/API_StopInferenceScheduler.html
     */
    toStopInferenceScheduler() {
        return this.to('StopInferenceScheduler');
    }
    /**
     * Grants permission to stop a retraining scheduler of a trained model
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/API_StopRetrainingScheduler.html
     */
    toStopRetrainingScheduler() {
        return this.to('StopRetrainingScheduler');
    }
    /**
     * Grants permission to tag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to untag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to set the active model version for a given machine learning model
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/API_UpdateActiveModelVersion.html
     */
    toUpdateActiveModelVersion() {
        return this.to('UpdateActiveModelVersion');
    }
    /**
     * Grants permission to update an inference scheduler
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/API_UpdateInferenceScheduler.html
     */
    toUpdateInferenceScheduler() {
        return this.to('UpdateInferenceScheduler');
    }
    /**
     * Grants permission to update a label group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/API_UpdateLabelGroup.html
     */
    toUpdateLabelGroup() {
        return this.to('UpdateLabelGroup');
    }
    /**
     * Grants permission to update a trained model
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/API_UpdateModel.html
     */
    toUpdateModel() {
        return this.to('UpdateModel');
    }
    /**
     * Grants permission to update a retraining scheduler of a trained model
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/API_UpdateRetrainingScheduler.html
     */
    toUpdateRetrainingScheduler() {
        return this.to('UpdateRetrainingScheduler');
    }
    /**
     * Adds a resource of type dataset to the statement
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/dataset.html
     *
     * @param datasetName - Identifier for the datasetName.
     * @param datasetId - Identifier for the datasetId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDataset(datasetName, datasetId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:lookoutequipment:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:dataset/${datasetName}/${datasetId}`);
    }
    /**
     * Adds a resource of type model to the statement
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/model.html
     *
     * @param modelName - Identifier for the modelName.
     * @param modelId - Identifier for the modelId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onModel(modelName, modelId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:lookoutequipment:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:model/${modelName}/${modelId}`);
    }
    /**
     * Adds a resource of type model-version to the statement
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/model-version.html
     *
     * @param modelName - Identifier for the modelName.
     * @param modelId - Identifier for the modelId.
     * @param modelVersionNumber - Identifier for the modelVersionNumber.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onModelVersion(modelName, modelId, modelVersionNumber, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:lookoutequipment:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:model/${modelName}/${modelId}/model-version/${modelVersionNumber}`);
    }
    /**
     * Adds a resource of type inference-scheduler to the statement
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/inference-scheduler.html
     *
     * @param inferenceSchedulerName - Identifier for the inferenceSchedulerName.
     * @param inferenceSchedulerId - Identifier for the inferenceSchedulerId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onInferenceScheduler(inferenceSchedulerName, inferenceSchedulerId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:lookoutequipment:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:inference-scheduler/${inferenceSchedulerName}/${inferenceSchedulerId}`);
    }
    /**
     * Adds a resource of type label-group to the statement
     *
     * https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/label-group.html
     *
     * @param labelGroupName - Identifier for the labelGroupName.
     * @param labelGroupId - Identifier for the labelGroupId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onLabelGroup(labelGroupName, labelGroupId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:lookoutequipment:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:label-group/${labelGroupName}/${labelGroupId}`);
    }
    /**
     * Filters access by the presence of tag key-value pairs in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateDataset()
     * - .toCreateInferenceScheduler()
     * - .toCreateLabelGroup()
     * - .toCreateModel()
     * - .toImportDataset()
     * - .toImportModelVersion()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey, value, operator) {
        return this.if(`aws:RequestTag/${tagKey}`, value, operator ?? 'StringLike');
    }
    /**
     * Filters access by tag key-value pairs attached to the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to resource types:
     * - dataset
     * - model
     * - model-version
     * - inference-scheduler
     * - label-group
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey, value, operator) {
        return this.if(`aws:ResourceTag/${tagKey}`, value, operator ?? 'StringLike');
    }
    /**
     * Filters access by the presence of tag keys in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateDataset()
     * - .toCreateInferenceScheduler()
     * - .toCreateLabelGroup()
     * - .toCreateModel()
     * - .toImportDataset()
     * - .toImportModelVersion()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value, operator) {
        return this.if(`aws:TagKeys`, value, operator ?? 'StringLike');
    }
    /**
     * Filters access by the import strategy of underlying data
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-isimportingdata
     *
     * Applies to actions:
     * - .toImportModelVersion()
     *
     * @param value `true` or `false`. **Default:** `true`
     */
    ifIsImportingData(value) {
        return this.if(`IsImportingData`, (typeof value !== 'undefined' ? value : true), 'Bool');
    }
    /**
     * Statement provider for service [lookoutequipment](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlookoutforequipment.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'lookoutequipment';
        this.accessLevelList = {
            Write: [
                'CreateDataset',
                'CreateInferenceScheduler',
                'CreateLabel',
                'CreateLabelGroup',
                'CreateModel',
                'CreateRetrainingScheduler',
                'DeleteDataset',
                'DeleteInferenceScheduler',
                'DeleteLabel',
                'DeleteLabelGroup',
                'DeleteModel',
                'DeleteResourcePolicy',
                'DeleteRetrainingScheduler',
                'ImportDataset',
                'ImportModelVersion',
                'PutResourcePolicy',
                'StartDataIngestionJob',
                'StartInferenceScheduler',
                'StartRetrainingScheduler',
                'StopInferenceScheduler',
                'StopRetrainingScheduler',
                'UpdateActiveModelVersion',
                'UpdateInferenceScheduler',
                'UpdateLabelGroup',
                'UpdateModel',
                'UpdateRetrainingScheduler'
            ],
            Read: [
                'DescribeDataIngestionJob',
                'DescribeDataset',
                'DescribeInferenceScheduler',
                'DescribeLabelGroup',
                'DescribeModel',
                'DescribeModelVersion',
                'DescribeResourcePolicy',
                'DescribeRetrainingScheduler',
                'Describelabel',
                'ListInferenceEvents',
                'ListInferenceExecutions',
                'ListTagsForResource'
            ],
            List: [
                'ListDataIngestionJobs',
                'ListDatasets',
                'ListInferenceSchedulers',
                'ListLabelGroups',
                'ListLabels',
                'ListModelVersions',
                'ListModels',
                'ListRetrainingSchedulers',
                'ListSensorStatistics'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
}
exports.Lookoutequipment = Lookoutequipment;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibG9va291dGZvcmVxdWlwbWVudC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImxvb2tvdXRmb3JlcXVpcG1lbnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQ0EseUNBQXlEO0FBR3pEOzs7O0dBSUc7QUFDSCxNQUFhLGdCQUFpQixTQUFRLHdCQUFlO0lBR25EOzs7Ozs7Ozs7O09BVUc7SUFDSSxlQUFlO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxlQUFlLENBQUMsQ0FBQztJQUNsQyxDQUFDO0lBRUQ7Ozs7Ozs7Ozs7T0FVRztJQUNJLDBCQUEwQjtRQUMvQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsMEJBQTBCLENBQUMsQ0FBQztJQUM3QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksYUFBYTtRQUNsQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsYUFBYSxDQUFDLENBQUM7SUFDaEMsQ0FBQztJQUVEOzs7Ozs7Ozs7O09BVUc7SUFDSSxrQkFBa0I7UUFDdkIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGtCQUFrQixDQUFDLENBQUM7SUFDckMsQ0FBQztJQUVEOzs7Ozs7Ozs7O09BVUc7SUFDSSxhQUFhO1FBQ2xCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxhQUFhLENBQUMsQ0FBQztJQUNoQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksMkJBQTJCO1FBQ2hDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQywyQkFBMkIsQ0FBQyxDQUFDO0lBQzlDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxlQUFlO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxlQUFlLENBQUMsQ0FBQztJQUNsQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksMEJBQTBCO1FBQy9CLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQywwQkFBMEIsQ0FBQyxDQUFDO0lBQzdDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxhQUFhO1FBQ2xCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxhQUFhLENBQUMsQ0FBQztJQUNoQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksa0JBQWtCO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO0lBQ3JDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxhQUFhO1FBQ2xCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxhQUFhLENBQUMsQ0FBQztJQUNoQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksc0JBQXNCO1FBQzNCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO0lBQ3pDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSwyQkFBMkI7UUFDaEMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDJCQUEyQixDQUFDLENBQUM7SUFDOUMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLDBCQUEwQjtRQUMvQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsMEJBQTBCLENBQUMsQ0FBQztJQUM3QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksaUJBQWlCO1FBQ3RCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDO0lBQ3BDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSw0QkFBNEI7UUFDakMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDRCQUE0QixDQUFDLENBQUM7SUFDL0MsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLG9CQUFvQjtRQUN6QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsb0JBQW9CLENBQUMsQ0FBQztJQUN2QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksZUFBZTtRQUNwQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsZUFBZSxDQUFDLENBQUM7SUFDbEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHNCQUFzQjtRQUMzQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsc0JBQXNCLENBQUMsQ0FBQztJQUN6QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksd0JBQXdCO1FBQzdCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyx3QkFBd0IsQ0FBQyxDQUFDO0lBQzNDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSw2QkFBNkI7UUFDbEMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDZCQUE2QixDQUFDLENBQUM7SUFDaEQsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGVBQWU7UUFDcEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGVBQWUsQ0FBQyxDQUFDO0lBQ2xDLENBQUM7SUFFRDs7Ozs7Ozs7OztPQVVHO0lBQ0ksZUFBZTtRQUNwQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsZUFBZSxDQUFDLENBQUM7SUFDbEMsQ0FBQztJQUVEOzs7Ozs7Ozs7OztPQVdHO0lBQ0ksb0JBQW9CO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO0lBQ3ZDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSx1QkFBdUI7UUFDNUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHVCQUF1QixDQUFDLENBQUM7SUFDMUMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGNBQWM7UUFDbkIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGNBQWMsQ0FBQyxDQUFDO0lBQ2pDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxxQkFBcUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHFCQUFxQixDQUFDLENBQUM7SUFDeEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHlCQUF5QjtRQUM5QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMseUJBQXlCLENBQUMsQ0FBQztJQUM1QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0kseUJBQXlCO1FBQzlCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyx5QkFBeUIsQ0FBQyxDQUFDO0lBQzVDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxpQkFBaUI7UUFDdEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGlCQUFpQixDQUFDLENBQUM7SUFDcEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLFlBQVk7UUFDakIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLFlBQVksQ0FBQyxDQUFDO0lBQy9CLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxtQkFBbUI7UUFDeEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLG1CQUFtQixDQUFDLENBQUM7SUFDdEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLFlBQVk7UUFDakIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLFlBQVksQ0FBQyxDQUFDO0lBQy9CLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSwwQkFBMEI7UUFDL0IsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDBCQUEwQixDQUFDLENBQUM7SUFDN0MsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHNCQUFzQjtRQUMzQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsc0JBQXNCLENBQUMsQ0FBQztJQUN6QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0kscUJBQXFCO1FBQzFCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO0lBQ3hDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxtQkFBbUI7UUFDeEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLG1CQUFtQixDQUFDLENBQUM7SUFDdEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHVCQUF1QjtRQUM1QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsdUJBQXVCLENBQUMsQ0FBQztJQUMxQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0kseUJBQXlCO1FBQzlCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyx5QkFBeUIsQ0FBQyxDQUFDO0lBQzVDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSwwQkFBMEI7UUFDL0IsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDBCQUEwQixDQUFDLENBQUM7SUFDN0MsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHdCQUF3QjtRQUM3QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsd0JBQXdCLENBQUMsQ0FBQztJQUMzQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0kseUJBQXlCO1FBQzlCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyx5QkFBeUIsQ0FBQyxDQUFDO0lBQzVDLENBQUM7SUFFRDs7Ozs7Ozs7OztPQVVHO0lBQ0ksYUFBYTtRQUNsQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsYUFBYSxDQUFDLENBQUM7SUFDaEMsQ0FBQztJQUVEOzs7Ozs7Ozs7T0FTRztJQUNJLGVBQWU7UUFDcEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGVBQWUsQ0FBQyxDQUFDO0lBQ2xDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSwwQkFBMEI7UUFDL0IsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDBCQUEwQixDQUFDLENBQUM7SUFDN0MsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLDBCQUEwQjtRQUMvQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsMEJBQTBCLENBQUMsQ0FBQztJQUM3QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksa0JBQWtCO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO0lBQ3JDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxhQUFhO1FBQ2xCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxhQUFhLENBQUMsQ0FBQztJQUNoQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksMkJBQTJCO1FBQ2hDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQywyQkFBMkIsQ0FBQyxDQUFDO0lBQzlDLENBQUM7SUE4REQ7Ozs7Ozs7Ozs7Ozs7T0FhRztJQUNJLFNBQVMsQ0FBQyxXQUFtQixFQUFFLFNBQWlCLEVBQUUsT0FBZ0IsRUFBRSxNQUFlLEVBQUUsU0FBa0I7UUFDNUcsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLE9BQVEsU0FBUyxJQUFJLElBQUksQ0FBQyxnQkFBaUIscUJBQXNCLE1BQU0sSUFBSSxJQUFJLENBQUMsYUFBYyxJQUFLLE9BQU8sSUFBSSxJQUFJLENBQUMsY0FBZSxZQUFhLFdBQVksSUFBSyxTQUFVLEVBQUUsQ0FBQyxDQUFDO0lBQy9MLENBQUM7SUFFRDs7Ozs7Ozs7Ozs7OztPQWFHO0lBQ0ksT0FBTyxDQUFDLFNBQWlCLEVBQUUsT0FBZSxFQUFFLE9BQWdCLEVBQUUsTUFBZSxFQUFFLFNBQWtCO1FBQ3RHLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxPQUFRLFNBQVMsSUFBSSxJQUFJLENBQUMsZ0JBQWlCLHFCQUFzQixNQUFNLElBQUksSUFBSSxDQUFDLGFBQWMsSUFBSyxPQUFPLElBQUksSUFBSSxDQUFDLGNBQWUsVUFBVyxTQUFVLElBQUssT0FBUSxFQUFFLENBQUMsQ0FBQztJQUN6TCxDQUFDO0lBRUQ7Ozs7Ozs7Ozs7Ozs7O09BY0c7SUFDSSxjQUFjLENBQUMsU0FBaUIsRUFBRSxPQUFlLEVBQUUsa0JBQTBCLEVBQUUsT0FBZ0IsRUFBRSxNQUFlLEVBQUUsU0FBa0I7UUFDekksT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLE9BQVEsU0FBUyxJQUFJLElBQUksQ0FBQyxnQkFBaUIscUJBQXNCLE1BQU0sSUFBSSxJQUFJLENBQUMsYUFBYyxJQUFLLE9BQU8sSUFBSSxJQUFJLENBQUMsY0FBZSxVQUFXLFNBQVUsSUFBSyxPQUFRLGtCQUFtQixrQkFBbUIsRUFBRSxDQUFDLENBQUM7SUFDL04sQ0FBQztJQUVEOzs7Ozs7Ozs7Ozs7O09BYUc7SUFDSSxvQkFBb0IsQ0FBQyxzQkFBOEIsRUFBRSxvQkFBNEIsRUFBRSxPQUFnQixFQUFFLE1BQWUsRUFBRSxTQUFrQjtRQUM3SSxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsT0FBUSxTQUFTLElBQUksSUFBSSxDQUFDLGdCQUFpQixxQkFBc0IsTUFBTSxJQUFJLElBQUksQ0FBQyxhQUFjLElBQUssT0FBTyxJQUFJLElBQUksQ0FBQyxjQUFlLHdCQUF5QixzQkFBdUIsSUFBSyxvQkFBcUIsRUFBRSxDQUFDLENBQUM7SUFDak8sQ0FBQztJQUVEOzs7Ozs7Ozs7Ozs7O09BYUc7SUFDSSxZQUFZLENBQUMsY0FBc0IsRUFBRSxZQUFvQixFQUFFLE9BQWdCLEVBQUUsTUFBZSxFQUFFLFNBQWtCO1FBQ3JILE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxPQUFRLFNBQVMsSUFBSSxJQUFJLENBQUMsZ0JBQWlCLHFCQUFzQixNQUFNLElBQUksSUFBSSxDQUFDLGFBQWMsSUFBSyxPQUFPLElBQUksSUFBSSxDQUFDLGNBQWUsZ0JBQWlCLGNBQWUsSUFBSyxZQUFhLEVBQUUsQ0FBQyxDQUFDO0lBQ3pNLENBQUM7SUFFRDs7Ozs7Ozs7Ozs7Ozs7Ozs7T0FpQkc7SUFDSSxlQUFlLENBQUMsTUFBYyxFQUFFLEtBQXdCLEVBQUUsUUFBNEI7UUFDM0YsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGtCQUFtQixNQUFPLEVBQUUsRUFBRSxLQUFLLEVBQUUsUUFBUSxJQUFJLFlBQVksQ0FBQyxDQUFDO0lBQ2hGLENBQUM7SUFFRDs7Ozs7Ozs7Ozs7Ozs7O09BZUc7SUFDSSxnQkFBZ0IsQ0FBQyxNQUFjLEVBQUUsS0FBd0IsRUFBRSxRQUE0QjtRQUM1RixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsbUJBQW9CLE1BQU8sRUFBRSxFQUFFLEtBQUssRUFBRSxRQUFRLElBQUksWUFBWSxDQUFDLENBQUM7SUFDakYsQ0FBQztJQUVEOzs7Ozs7Ozs7Ozs7Ozs7OztPQWlCRztJQUNJLFlBQVksQ0FBQyxLQUF3QixFQUFFLFFBQTRCO1FBQ3hFLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxhQUFhLEVBQUUsS0FBSyxFQUFFLFFBQVEsSUFBSSxZQUFZLENBQUMsQ0FBQztJQUNqRSxDQUFDO0lBRUQ7Ozs7Ozs7OztPQVNHO0lBQ0ksaUJBQWlCLENBQUMsS0FBZTtRQUN0QyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsaUJBQWlCLEVBQUUsQ0FBQyxPQUFPLEtBQUssS0FBSyxXQUFXLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLEVBQUUsTUFBTSxDQUFDLENBQUM7SUFDM0YsQ0FBQztJQUVEOzs7T0FHRztJQUNILFlBQVksS0FBZ0M7UUFDMUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBdnlCUixrQkFBYSxHQUFHLGtCQUFrQixDQUFDO1FBNmpCaEMsb0JBQWUsR0FBb0I7WUFDM0MsS0FBSyxFQUFFO2dCQUNMLGVBQWU7Z0JBQ2YsMEJBQTBCO2dCQUMxQixhQUFhO2dCQUNiLGtCQUFrQjtnQkFDbEIsYUFBYTtnQkFDYiwyQkFBMkI7Z0JBQzNCLGVBQWU7Z0JBQ2YsMEJBQTBCO2dCQUMxQixhQUFhO2dCQUNiLGtCQUFrQjtnQkFDbEIsYUFBYTtnQkFDYixzQkFBc0I7Z0JBQ3RCLDJCQUEyQjtnQkFDM0IsZUFBZTtnQkFDZixvQkFBb0I7Z0JBQ3BCLG1CQUFtQjtnQkFDbkIsdUJBQXVCO2dCQUN2Qix5QkFBeUI7Z0JBQ3pCLDBCQUEwQjtnQkFDMUIsd0JBQXdCO2dCQUN4Qix5QkFBeUI7Z0JBQ3pCLDBCQUEwQjtnQkFDMUIsMEJBQTBCO2dCQUMxQixrQkFBa0I7Z0JBQ2xCLGFBQWE7Z0JBQ2IsMkJBQTJCO2FBQzVCO1lBQ0QsSUFBSSxFQUFFO2dCQUNKLDBCQUEwQjtnQkFDMUIsaUJBQWlCO2dCQUNqQiw0QkFBNEI7Z0JBQzVCLG9CQUFvQjtnQkFDcEIsZUFBZTtnQkFDZixzQkFBc0I7Z0JBQ3RCLHdCQUF3QjtnQkFDeEIsNkJBQTZCO2dCQUM3QixlQUFlO2dCQUNmLHFCQUFxQjtnQkFDckIseUJBQXlCO2dCQUN6QixxQkFBcUI7YUFDdEI7WUFDRCxJQUFJLEVBQUU7Z0JBQ0osdUJBQXVCO2dCQUN2QixjQUFjO2dCQUNkLHlCQUF5QjtnQkFDekIsaUJBQWlCO2dCQUNqQixZQUFZO2dCQUNaLG1CQUFtQjtnQkFDbkIsWUFBWTtnQkFDWiwwQkFBMEI7Z0JBQzFCLHNCQUFzQjthQUN2QjtZQUNELE9BQU8sRUFBRTtnQkFDUCxhQUFhO2dCQUNiLGVBQWU7YUFDaEI7U0FDRixDQUFDO0lBaUxGLENBQUM7Q0FDRjtBQTF5QkQsNENBMHlCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEFjY2Vzc0xldmVsTGlzdCB9IGZyb20gJy4uLy4uL3NoYXJlZC9hY2Nlc3MtbGV2ZWwnO1xuaW1wb3J0IHsgUG9saWN5U3RhdGVtZW50LCBPcGVyYXRvciB9IGZyb20gJy4uLy4uL3NoYXJlZCc7XG5pbXBvcnQgeyBhd3NfaWFtIGFzIGlhbSB9IGZyb20gXCJhd3MtY2RrLWxpYlwiO1xuXG4vKipcbiAqIFN0YXRlbWVudCBwcm92aWRlciBmb3Igc2VydmljZSBbbG9va291dGVxdWlwbWVudF0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3NlcnZpY2UtYXV0aG9yaXphdGlvbi9sYXRlc3QvcmVmZXJlbmNlL2xpc3RfYW1hem9ubG9va291dGZvcmVxdWlwbWVudC5odG1sKS5cbiAqXG4gKiBAcGFyYW0gc2lkIFtTSURdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9JQU0vbGF0ZXN0L1VzZXJHdWlkZS9yZWZlcmVuY2VfcG9saWNpZXNfZWxlbWVudHNfc2lkLmh0bWwpIG9mIHRoZSBzdGF0ZW1lbnRcbiAqL1xuZXhwb3J0IGNsYXNzIExvb2tvdXRlcXVpcG1lbnQgZXh0ZW5kcyBQb2xpY3lTdGF0ZW1lbnQge1xuICBwdWJsaWMgc2VydmljZVByZWZpeCA9ICdsb29rb3V0ZXF1aXBtZW50JztcblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gY3JlYXRlIGEgZGF0YXNldFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmQXdzUmVxdWVzdFRhZygpXG4gICAqIC0gLmlmQXdzVGFnS2V5cygpXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9sb29rb3V0LWZvci1lcXVpcG1lbnQvbGF0ZXN0L3VnL0FQSV9DcmVhdGVEYXRhc2V0Lmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0NyZWF0ZURhdGFzZXQoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0NyZWF0ZURhdGFzZXQnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBjcmVhdGUgYW4gaW5mZXJlbmNlIHNjaGVkdWxlciBmb3IgYSB0cmFpbmVkIG1vZGVsXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NSZXF1ZXN0VGFnKClcbiAgICogLSAuaWZBd3NUYWdLZXlzKClcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2xvb2tvdXQtZm9yLWVxdWlwbWVudC9sYXRlc3QvdWcvQVBJX0NyZWF0ZUluZmVyZW5jZVNjaGVkdWxlci5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9DcmVhdGVJbmZlcmVuY2VTY2hlZHVsZXIoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0NyZWF0ZUluZmVyZW5jZVNjaGVkdWxlcicpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGNyZWF0ZSBhIGxhYmVsXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2xvb2tvdXQtZm9yLWVxdWlwbWVudC9sYXRlc3QvdWcvQVBJX0NyZWF0ZUxhYmVsLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0NyZWF0ZUxhYmVsKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdDcmVhdGVMYWJlbCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGNyZWF0ZSBhIGxhYmVsIGdyb3VwXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NSZXF1ZXN0VGFnKClcbiAgICogLSAuaWZBd3NUYWdLZXlzKClcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2xvb2tvdXQtZm9yLWVxdWlwbWVudC9sYXRlc3QvdWcvQVBJX0NyZWF0ZUxhYmVsR3JvdXAuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQ3JlYXRlTGFiZWxHcm91cCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQ3JlYXRlTGFiZWxHcm91cCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGNyZWF0ZSBhIG1vZGVsIHRoYXQgaXMgdHJhaW5lZCBvbiBhIGRhdGFzZXRcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1JlcXVlc3RUYWcoKVxuICAgKiAtIC5pZkF3c1RhZ0tleXMoKVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbG9va291dC1mb3ItZXF1aXBtZW50L2xhdGVzdC91Zy9BUElfQ3JlYXRlTW9kZWwuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQ3JlYXRlTW9kZWwoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0NyZWF0ZU1vZGVsJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gY3JlYXRlIGEgcmV0cmFpbmluZyBzY2hlZHVsZXIgZm9yIGEgdHJhaW5lZCBtb2RlbFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9sb29rb3V0LWZvci1lcXVpcG1lbnQvbGF0ZXN0L3VnL0FQSV9DcmVhdGVSZXRyYWluaW5nU2NoZWR1bGVyLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0NyZWF0ZVJldHJhaW5pbmdTY2hlZHVsZXIoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0NyZWF0ZVJldHJhaW5pbmdTY2hlZHVsZXInKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBkZWxldGUgYSBkYXRhc2V0XG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2xvb2tvdXQtZm9yLWVxdWlwbWVudC9sYXRlc3QvdWcvQVBJX0RlbGV0ZURhdGFzZXQuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVsZXRlRGF0YXNldCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVsZXRlRGF0YXNldCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGRlbGV0ZSBhbiBpbmZlcmVuY2Ugc2NoZWR1bGVyXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2xvb2tvdXQtZm9yLWVxdWlwbWVudC9sYXRlc3QvdWcvQVBJX0RlbGV0ZUluZmVyZW5jZVNjaGVkdWxlci5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZWxldGVJbmZlcmVuY2VTY2hlZHVsZXIoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0RlbGV0ZUluZmVyZW5jZVNjaGVkdWxlcicpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGRlbGV0ZSBhIGxhYmVsXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2xvb2tvdXQtZm9yLWVxdWlwbWVudC9sYXRlc3QvdWcvQVBJX0RlbGV0ZUxhYmVsLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0RlbGV0ZUxhYmVsKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZWxldGVMYWJlbCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGRlbGV0ZSBhIGxhYmVsIGdyb3VwXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2xvb2tvdXQtZm9yLWVxdWlwbWVudC9sYXRlc3QvdWcvQVBJX0RlbGV0ZUxhYmVsR3JvdXAuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVsZXRlTGFiZWxHcm91cCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVsZXRlTGFiZWxHcm91cCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGRlbGV0ZSBhIG1vZGVsXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2xvb2tvdXQtZm9yLWVxdWlwbWVudC9sYXRlc3QvdWcvQVBJX0RlbGV0ZU1vZGVsLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0RlbGV0ZU1vZGVsKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZWxldGVNb2RlbCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGRlbGV0ZSBhIHJlc291cmNlIHBvbGljeVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9sb29rb3V0LWZvci1lcXVpcG1lbnQvbGF0ZXN0L3VnL0FQSV9EZWxldGVSZXNvdXJjZVBvbGljeS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZWxldGVSZXNvdXJjZVBvbGljeSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVsZXRlUmVzb3VyY2VQb2xpY3knKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBkZWxldGUgYSByZXRyYWluaW5nIHNjaGVkdWxlciBvZiBhIHRyYWluZWQgbW9kZWxcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbG9va291dC1mb3ItZXF1aXBtZW50L2xhdGVzdC91Zy9BUElfRGVsZXRlUmV0cmFpbmluZ1NjaGVkdWxlci5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZWxldGVSZXRyYWluaW5nU2NoZWR1bGVyKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZWxldGVSZXRyYWluaW5nU2NoZWR1bGVyJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZGVzY3JpYmUgYSBkYXRhIGluZ2VzdGlvbiBqb2JcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9sb29rb3V0LWZvci1lcXVpcG1lbnQvbGF0ZXN0L3VnL0FQSV9EZXNjcmliZURhdGFJbmdlc3Rpb25Kb2IuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVzY3JpYmVEYXRhSW5nZXN0aW9uSm9iKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZXNjcmliZURhdGFJbmdlc3Rpb25Kb2InKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBkZXNjcmliZSBhIGRhdGFzZXRcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9sb29rb3V0LWZvci1lcXVpcG1lbnQvbGF0ZXN0L3VnL0FQSV9EZXNjcmliZURhdGFzZXQuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVzY3JpYmVEYXRhc2V0KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZXNjcmliZURhdGFzZXQnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBkZXNjcmliZSBhbiBpbmZlcmVuY2Ugc2NoZWR1bGVyXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbG9va291dC1mb3ItZXF1aXBtZW50L2xhdGVzdC91Zy9BUElfRGVzY3JpYmVJbmZlcmVuY2VTY2hlZHVsZXIuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVzY3JpYmVJbmZlcmVuY2VTY2hlZHVsZXIoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0Rlc2NyaWJlSW5mZXJlbmNlU2NoZWR1bGVyJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZGVzY3JpYmUgYSBsYWJlbCBncm91cFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2xvb2tvdXQtZm9yLWVxdWlwbWVudC9sYXRlc3QvdWcvQVBJX0Rlc2NyaWJlTGFiZWxHcm91cC5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZXNjcmliZUxhYmVsR3JvdXAoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0Rlc2NyaWJlTGFiZWxHcm91cCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGRlc2NyaWJlIGEgbW9kZWxcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9sb29rb3V0LWZvci1lcXVpcG1lbnQvbGF0ZXN0L3VnL0FQSV9EZXNjcmliZU1vZGVsLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0Rlc2NyaWJlTW9kZWwoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0Rlc2NyaWJlTW9kZWwnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBkZXNjcmliZSBhIG1vZGVsIHZlcnNpb25cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9sb29rb3V0LWZvci1lcXVpcG1lbnQvbGF0ZXN0L3VnL0FQSV9EZXNjcmliZU1vZGVsVmVyc2lvbi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZXNjcmliZU1vZGVsVmVyc2lvbigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVzY3JpYmVNb2RlbFZlcnNpb24nKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBkZXNjcmliZSBhIHJlc291cmNlIHBvbGljeVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2xvb2tvdXQtZm9yLWVxdWlwbWVudC9sYXRlc3QvdWcvQVBJX0Rlc2NyaWJlUmVzb3VyY2VQb2xpY3kuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVzY3JpYmVSZXNvdXJjZVBvbGljeSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVzY3JpYmVSZXNvdXJjZVBvbGljeScpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGRlc2NyaWJlIGEgcmV0cmFpbmluZyBzY2hlZHVsZXIgb2YgYSB0cmFpbmVkIG1vZGVsXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbG9va291dC1mb3ItZXF1aXBtZW50L2xhdGVzdC91Zy9BUElfRGVzY3JpYmVSZXRyYWluaW5nU2NoZWR1bGVyLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0Rlc2NyaWJlUmV0cmFpbmluZ1NjaGVkdWxlcigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVzY3JpYmVSZXRyYWluaW5nU2NoZWR1bGVyJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZGVzY3JpYmUgYSBsYWJlbFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2xvb2tvdXQtZm9yLWVxdWlwbWVudC9sYXRlc3QvdWcvQVBJX0Rlc2NyaWJlTGFiZWwuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVzY3JpYmVsYWJlbCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVzY3JpYmVsYWJlbCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGltcG9ydCBhIGRhdGFzZXRcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1JlcXVlc3RUYWcoKVxuICAgKiAtIC5pZkF3c1RhZ0tleXMoKVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbG9va291dC1mb3ItZXF1aXBtZW50L2xhdGVzdC91Zy9BUElfSW1wb3J0RGF0YXNldC5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9JbXBvcnREYXRhc2V0KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdJbXBvcnREYXRhc2V0Jyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gaW1wb3J0IGEgbW9kZWwgdmVyc2lvblxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmQXdzUmVxdWVzdFRhZygpXG4gICAqIC0gLmlmQXdzVGFnS2V5cygpXG4gICAqIC0gLmlmSXNJbXBvcnRpbmdEYXRhKClcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2xvb2tvdXQtZm9yLWVxdWlwbWVudC9sYXRlc3QvdWcvQVBJX0ltcG9ydE1vZGVsVmVyc2lvbi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9JbXBvcnRNb2RlbFZlcnNpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0ltcG9ydE1vZGVsVmVyc2lvbicpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGxpc3QgdGhlIGRhdGEgaW5nZXN0aW9uIGpvYnMgaW4geW91ciBhY2NvdW50IG9yIGZvciBhIHBhcnRpY3VsYXIgZGF0YXNldFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2xvb2tvdXQtZm9yLWVxdWlwbWVudC9sYXRlc3QvdWcvQVBJX0xpc3REYXRhSW5nZXN0aW9uSm9icy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0RGF0YUluZ2VzdGlvbkpvYnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3REYXRhSW5nZXN0aW9uSm9icycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGxpc3QgdGhlIGRhdGFzZXRzIGluIHlvdXIgYWNjb3VudFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2xvb2tvdXQtZm9yLWVxdWlwbWVudC9sYXRlc3QvdWcvQVBJX0xpc3REYXRhc2V0cy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0RGF0YXNldHMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3REYXRhc2V0cycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGxpc3QgdGhlIGluZmVyZW5jZSBldmVudHMgZm9yIGFuIGluZmVyZW5jZSBzY2hlZHVsZXJcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9sb29rb3V0LWZvci1lcXVpcG1lbnQvbGF0ZXN0L3VnL0FQSV9MaXN0SW5mZXJlbmNlRXZlbnRzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RJbmZlcmVuY2VFdmVudHMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3RJbmZlcmVuY2VFdmVudHMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBsaXN0IHRoZSBpbmZlcmVuY2UgZXhlY3V0aW9ucyBmb3IgYW4gaW5mZXJlbmNlIHNjaGVkdWxlclxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2xvb2tvdXQtZm9yLWVxdWlwbWVudC9sYXRlc3QvdWcvQVBJX0xpc3RJbmZlcmVuY2VFeGVjdXRpb25zLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RJbmZlcmVuY2VFeGVjdXRpb25zKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0SW5mZXJlbmNlRXhlY3V0aW9ucycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGxpc3QgdGhlIGluZmVyZW5jZSBzY2hlZHVsZXJzIGluIHlvdXIgYWNjb3VudFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2xvb2tvdXQtZm9yLWVxdWlwbWVudC9sYXRlc3QvdWcvQVBJX0xpc3RJbmZlcmVuY2VTY2hlZHVsZXJzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RJbmZlcmVuY2VTY2hlZHVsZXJzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0SW5mZXJlbmNlU2NoZWR1bGVycycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGxpc3QgdGhlIGxhYmVsIGdyb3VwcyBpbiB5b3VyIGFjY291bnRcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9sb29rb3V0LWZvci1lcXVpcG1lbnQvbGF0ZXN0L3VnL0FQSV9MaXN0TGFiZWxHcm91cHMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdExhYmVsR3JvdXBzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0TGFiZWxHcm91cHMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBsaXN0IHRoZSBsYWJlbHMgaW4geW91ciBhY2NvdW50XG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbG9va291dC1mb3ItZXF1aXBtZW50L2xhdGVzdC91Zy9BUElfTGlzdExhYmVscy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0TGFiZWxzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0TGFiZWxzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gbGlzdCB0aGUgbW9kZWwgdmVyc2lvbnMgaW4geW91ciBhY2NvdW50XG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbG9va291dC1mb3ItZXF1aXBtZW50L2xhdGVzdC91Zy9BUElfTGlzdE1vZGVsVmVyc2lvbnMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdE1vZGVsVmVyc2lvbnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3RNb2RlbFZlcnNpb25zJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gbGlzdCB0aGUgbW9kZWxzIGluIHlvdXIgYWNjb3VudFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2xvb2tvdXQtZm9yLWVxdWlwbWVudC9sYXRlc3QvdWcvQVBJX0xpc3RNb2RlbHMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdE1vZGVscygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdE1vZGVscycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGxpc3QgdGhlIHJldHJhaW5pbmcgc2NoZWR1bGVycyBpbiB5b3VyIGFjY291bnRcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9sb29rb3V0LWZvci1lcXVpcG1lbnQvbGF0ZXN0L3VnL0FQSV9MaXN0UmV0cmFpbmluZ1NjaGVkdWxlcnMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdFJldHJhaW5pbmdTY2hlZHVsZXJzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0UmV0cmFpbmluZ1NjaGVkdWxlcnMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBsaXN0IHRoZSBzZW5zb3Igc3RhdGlzdGljcyBmb3IgYSBwYXJ0aWN1bGFyIGRhdGFzZXQgb3IgYW4gaW5nZXN0aW9uIGpvYlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2xvb2tvdXQtZm9yLWVxdWlwbWVudC9sYXRlc3QvdWcvQVBJX0xpc3RTZW5zb3JTdGF0aXN0aWNzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RTZW5zb3JTdGF0aXN0aWNzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0U2Vuc29yU3RhdGlzdGljcycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGxpc3QgdGhlIHRhZ3MgZm9yIGEgcmVzb3VyY2VcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9sb29rb3V0LWZvci1lcXVpcG1lbnQvbGF0ZXN0L3VnL0FQSV9MaXN0VGFnc0ZvclJlc291cmNlLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RUYWdzRm9yUmVzb3VyY2UoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3RUYWdzRm9yUmVzb3VyY2UnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBwdXQgYSByZXNvdXJjZSBwb2xpY3lcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbG9va291dC1mb3ItZXF1aXBtZW50L2xhdGVzdC91Zy9BUElfUHV0UmVzb3VyY2VQb2xpY3kuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvUHV0UmVzb3VyY2VQb2xpY3koKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1B1dFJlc291cmNlUG9saWN5Jyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gc3RhcnQgYSBkYXRhIGluZ2VzdGlvbiBqb2IgZm9yIGEgZGF0YXNldFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9sb29rb3V0LWZvci1lcXVpcG1lbnQvbGF0ZXN0L3VnL0FQSV9TdGFydERhdGFJbmdlc3Rpb25Kb2IuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvU3RhcnREYXRhSW5nZXN0aW9uSm9iKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdTdGFydERhdGFJbmdlc3Rpb25Kb2InKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBzdGFydCBhbiBpbmZlcmVuY2Ugc2NoZWR1bGVyXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2xvb2tvdXQtZm9yLWVxdWlwbWVudC9sYXRlc3QvdWcvQVBJX1N0YXJ0SW5mZXJlbmNlU2NoZWR1bGVyLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1N0YXJ0SW5mZXJlbmNlU2NoZWR1bGVyKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdTdGFydEluZmVyZW5jZVNjaGVkdWxlcicpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHN0YXJ0IGEgcmV0cmFpbmluZyBzY2hlZHVsZXIgb2YgYSB0cmFpbmVkIG1vZGVsXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2xvb2tvdXQtZm9yLWVxdWlwbWVudC9sYXRlc3QvdWcvQVBJX1N0YXJ0UmV0cmFpbmluZ1NjaGVkdWxlci5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9TdGFydFJldHJhaW5pbmdTY2hlZHVsZXIoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1N0YXJ0UmV0cmFpbmluZ1NjaGVkdWxlcicpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHN0b3AgYW4gaW5mZXJlbmNlIHNjaGVkdWxlclxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9sb29rb3V0LWZvci1lcXVpcG1lbnQvbGF0ZXN0L3VnL0FQSV9TdG9wSW5mZXJlbmNlU2NoZWR1bGVyLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1N0b3BJbmZlcmVuY2VTY2hlZHVsZXIoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1N0b3BJbmZlcmVuY2VTY2hlZHVsZXInKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBzdG9wIGEgcmV0cmFpbmluZyBzY2hlZHVsZXIgb2YgYSB0cmFpbmVkIG1vZGVsXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2xvb2tvdXQtZm9yLWVxdWlwbWVudC9sYXRlc3QvdWcvQVBJX1N0b3BSZXRyYWluaW5nU2NoZWR1bGVyLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1N0b3BSZXRyYWluaW5nU2NoZWR1bGVyKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdTdG9wUmV0cmFpbmluZ1NjaGVkdWxlcicpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHRhZyBhIHJlc291cmNlXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogVGFnZ2luZ1xuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1JlcXVlc3RUYWcoKVxuICAgKiAtIC5pZkF3c1RhZ0tleXMoKVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbG9va291dC1mb3ItZXF1aXBtZW50L2xhdGVzdC91Zy9BUElfVGFnUmVzb3VyY2UuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVGFnUmVzb3VyY2UoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1RhZ1Jlc291cmNlJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gdW50YWcgYSByZXNvdXJjZVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFRhZ2dpbmdcbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NUYWdLZXlzKClcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2xvb2tvdXQtZm9yLWVxdWlwbWVudC9sYXRlc3QvdWcvQVBJX1VudGFnUmVzb3VyY2UuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVW50YWdSZXNvdXJjZSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnVW50YWdSZXNvdXJjZScpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHNldCB0aGUgYWN0aXZlIG1vZGVsIHZlcnNpb24gZm9yIGEgZ2l2ZW4gbWFjaGluZSBsZWFybmluZyBtb2RlbFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9sb29rb3V0LWZvci1lcXVpcG1lbnQvbGF0ZXN0L3VnL0FQSV9VcGRhdGVBY3RpdmVNb2RlbFZlcnNpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVXBkYXRlQWN0aXZlTW9kZWxWZXJzaW9uKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdVcGRhdGVBY3RpdmVNb2RlbFZlcnNpb24nKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byB1cGRhdGUgYW4gaW5mZXJlbmNlIHNjaGVkdWxlclxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9sb29rb3V0LWZvci1lcXVpcG1lbnQvbGF0ZXN0L3VnL0FQSV9VcGRhdGVJbmZlcmVuY2VTY2hlZHVsZXIuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVXBkYXRlSW5mZXJlbmNlU2NoZWR1bGVyKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdVcGRhdGVJbmZlcmVuY2VTY2hlZHVsZXInKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byB1cGRhdGUgYSBsYWJlbCBncm91cFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9sb29rb3V0LWZvci1lcXVpcG1lbnQvbGF0ZXN0L3VnL0FQSV9VcGRhdGVMYWJlbEdyb3VwLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1VwZGF0ZUxhYmVsR3JvdXAoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1VwZGF0ZUxhYmVsR3JvdXAnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byB1cGRhdGUgYSB0cmFpbmVkIG1vZGVsXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2xvb2tvdXQtZm9yLWVxdWlwbWVudC9sYXRlc3QvdWcvQVBJX1VwZGF0ZU1vZGVsLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1VwZGF0ZU1vZGVsKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdVcGRhdGVNb2RlbCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHVwZGF0ZSBhIHJldHJhaW5pbmcgc2NoZWR1bGVyIG9mIGEgdHJhaW5lZCBtb2RlbFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9sb29rb3V0LWZvci1lcXVpcG1lbnQvbGF0ZXN0L3VnL0FQSV9VcGRhdGVSZXRyYWluaW5nU2NoZWR1bGVyLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1VwZGF0ZVJldHJhaW5pbmdTY2hlZHVsZXIoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1VwZGF0ZVJldHJhaW5pbmdTY2hlZHVsZXInKTtcbiAgfVxuXG4gIHByb3RlY3RlZCBhY2Nlc3NMZXZlbExpc3Q6IEFjY2Vzc0xldmVsTGlzdCA9IHtcbiAgICBXcml0ZTogW1xuICAgICAgJ0NyZWF0ZURhdGFzZXQnLFxuICAgICAgJ0NyZWF0ZUluZmVyZW5jZVNjaGVkdWxlcicsXG4gICAgICAnQ3JlYXRlTGFiZWwnLFxuICAgICAgJ0NyZWF0ZUxhYmVsR3JvdXAnLFxuICAgICAgJ0NyZWF0ZU1vZGVsJyxcbiAgICAgICdDcmVhdGVSZXRyYWluaW5nU2NoZWR1bGVyJyxcbiAgICAgICdEZWxldGVEYXRhc2V0JyxcbiAgICAgICdEZWxldGVJbmZlcmVuY2VTY2hlZHVsZXInLFxuICAgICAgJ0RlbGV0ZUxhYmVsJyxcbiAgICAgICdEZWxldGVMYWJlbEdyb3VwJyxcbiAgICAgICdEZWxldGVNb2RlbCcsXG4gICAgICAnRGVsZXRlUmVzb3VyY2VQb2xpY3knLFxuICAgICAgJ0RlbGV0ZVJldHJhaW5pbmdTY2hlZHVsZXInLFxuICAgICAgJ0ltcG9ydERhdGFzZXQnLFxuICAgICAgJ0ltcG9ydE1vZGVsVmVyc2lvbicsXG4gICAgICAnUHV0UmVzb3VyY2VQb2xpY3knLFxuICAgICAgJ1N0YXJ0RGF0YUluZ2VzdGlvbkpvYicsXG4gICAgICAnU3RhcnRJbmZlcmVuY2VTY2hlZHVsZXInLFxuICAgICAgJ1N0YXJ0UmV0cmFpbmluZ1NjaGVkdWxlcicsXG4gICAgICAnU3RvcEluZmVyZW5jZVNjaGVkdWxlcicsXG4gICAgICAnU3RvcFJldHJhaW5pbmdTY2hlZHVsZXInLFxuICAgICAgJ1VwZGF0ZUFjdGl2ZU1vZGVsVmVyc2lvbicsXG4gICAgICAnVXBkYXRlSW5mZXJlbmNlU2NoZWR1bGVyJyxcbiAgICAgICdVcGRhdGVMYWJlbEdyb3VwJyxcbiAgICAgICdVcGRhdGVNb2RlbCcsXG4gICAgICAnVXBkYXRlUmV0cmFpbmluZ1NjaGVkdWxlcidcbiAgICBdLFxuICAgIFJlYWQ6IFtcbiAgICAgICdEZXNjcmliZURhdGFJbmdlc3Rpb25Kb2InLFxuICAgICAgJ0Rlc2NyaWJlRGF0YXNldCcsXG4gICAgICAnRGVzY3JpYmVJbmZlcmVuY2VTY2hlZHVsZXInLFxuICAgICAgJ0Rlc2NyaWJlTGFiZWxHcm91cCcsXG4gICAgICAnRGVzY3JpYmVNb2RlbCcsXG4gICAgICAnRGVzY3JpYmVNb2RlbFZlcnNpb24nLFxuICAgICAgJ0Rlc2NyaWJlUmVzb3VyY2VQb2xpY3knLFxuICAgICAgJ0Rlc2NyaWJlUmV0cmFpbmluZ1NjaGVkdWxlcicsXG4gICAgICAnRGVzY3JpYmVsYWJlbCcsXG4gICAgICAnTGlzdEluZmVyZW5jZUV2ZW50cycsXG4gICAgICAnTGlzdEluZmVyZW5jZUV4ZWN1dGlvbnMnLFxuICAgICAgJ0xpc3RUYWdzRm9yUmVzb3VyY2UnXG4gICAgXSxcbiAgICBMaXN0OiBbXG4gICAgICAnTGlzdERhdGFJbmdlc3Rpb25Kb2JzJyxcbiAgICAgICdMaXN0RGF0YXNldHMnLFxuICAgICAgJ0xpc3RJbmZlcmVuY2VTY2hlZHVsZXJzJyxcbiAgICAgICdMaXN0TGFiZWxHcm91cHMnLFxuICAgICAgJ0xpc3RMYWJlbHMnLFxuICAgICAgJ0xpc3RNb2RlbFZlcnNpb25zJyxcbiAgICAgICdMaXN0TW9kZWxzJyxcbiAgICAgICdMaXN0UmV0cmFpbmluZ1NjaGVkdWxlcnMnLFxuICAgICAgJ0xpc3RTZW5zb3JTdGF0aXN0aWNzJ1xuICAgIF0sXG4gICAgVGFnZ2luZzogW1xuICAgICAgJ1RhZ1Jlc291cmNlJyxcbiAgICAgICdVbnRhZ1Jlc291cmNlJ1xuICAgIF1cbiAgfTtcblxuICAvKipcbiAgICogQWRkcyBhIHJlc291cmNlIG9mIHR5cGUgZGF0YXNldCB0byB0aGUgc3RhdGVtZW50XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9sb29rb3V0LWZvci1lcXVpcG1lbnQvbGF0ZXN0L3VnL2RhdGFzZXQuaHRtbFxuICAgKlxuICAgKiBAcGFyYW0gZGF0YXNldE5hbWUgLSBJZGVudGlmaWVyIGZvciB0aGUgZGF0YXNldE5hbWUuXG4gICAqIEBwYXJhbSBkYXRhc2V0SWQgLSBJZGVudGlmaWVyIGZvciB0aGUgZGF0YXNldElkLlxuICAgKiBAcGFyYW0gYWNjb3VudCAtIEFjY291bnQgb2YgdGhlIHJlc291cmNlOyBkZWZhdWx0cyB0byBgKmAsIHVubGVzcyB1c2luZyB0aGUgQ0RLLCB3aGVyZSB0aGUgZGVmYXVsdCBpcyB0aGUgY3VycmVudCBTdGFjaydzIGFjY291bnQuXG4gICAqIEBwYXJhbSByZWdpb24gLSBSZWdpb24gb2YgdGhlIHJlc291cmNlOyBkZWZhdWx0cyB0byBgKmAsIHVubGVzcyB1c2luZyB0aGUgQ0RLLCB3aGVyZSB0aGUgZGVmYXVsdCBpcyB0aGUgY3VycmVudCBTdGFjaydzIHJlZ2lvbi5cbiAgICogQHBhcmFtIHBhcnRpdGlvbiAtIFBhcnRpdGlvbiBvZiB0aGUgQVdTIGFjY291bnQgW2F3cywgYXdzLWNuLCBhd3MtdXMtZ292XTsgZGVmYXVsdHMgdG8gYGF3c2AsIHVubGVzcyB1c2luZyB0aGUgQ0RLLCB3aGVyZSB0aGUgZGVmYXVsdCBpcyB0aGUgY3VycmVudCBTdGFjaydzIHBhcnRpdGlvbi5cbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NSZXNvdXJjZVRhZygpXG4gICAqL1xuICBwdWJsaWMgb25EYXRhc2V0KGRhdGFzZXROYW1lOiBzdHJpbmcsIGRhdGFzZXRJZDogc3RyaW5nLCBhY2NvdW50Pzogc3RyaW5nLCByZWdpb24/OiBzdHJpbmcsIHBhcnRpdGlvbj86IHN0cmluZykge1xuICAgIHJldHVybiB0aGlzLm9uKGBhcm46JHsgcGFydGl0aW9uID8/IHRoaXMuZGVmYXVsdFBhcnRpdGlvbiB9Omxvb2tvdXRlcXVpcG1lbnQ6JHsgcmVnaW9uID8/IHRoaXMuZGVmYXVsdFJlZ2lvbiB9OiR7IGFjY291bnQgPz8gdGhpcy5kZWZhdWx0QWNjb3VudCB9OmRhdGFzZXQvJHsgZGF0YXNldE5hbWUgfS8keyBkYXRhc2V0SWQgfWApO1xuICB9XG5cbiAgLyoqXG4gICAqIEFkZHMgYSByZXNvdXJjZSBvZiB0eXBlIG1vZGVsIHRvIHRoZSBzdGF0ZW1lbnRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2xvb2tvdXQtZm9yLWVxdWlwbWVudC9sYXRlc3QvdWcvbW9kZWwuaHRtbFxuICAgKlxuICAgKiBAcGFyYW0gbW9kZWxOYW1lIC0gSWRlbnRpZmllciBmb3IgdGhlIG1vZGVsTmFtZS5cbiAgICogQHBhcmFtIG1vZGVsSWQgLSBJZGVudGlmaWVyIGZvciB0aGUgbW9kZWxJZC5cbiAgICogQHBhcmFtIGFjY291bnQgLSBBY2NvdW50IG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gYCpgLCB1bmxlc3MgdXNpbmcgdGhlIENESywgd2hlcmUgdGhlIGRlZmF1bHQgaXMgdGhlIGN1cnJlbnQgU3RhY2sncyBhY2NvdW50LlxuICAgKiBAcGFyYW0gcmVnaW9uIC0gUmVnaW9uIG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gYCpgLCB1bmxlc3MgdXNpbmcgdGhlIENESywgd2hlcmUgdGhlIGRlZmF1bHQgaXMgdGhlIGN1cnJlbnQgU3RhY2sncyByZWdpb24uXG4gICAqIEBwYXJhbSBwYXJ0aXRpb24gLSBQYXJ0aXRpb24gb2YgdGhlIEFXUyBhY2NvdW50IFthd3MsIGF3cy1jbiwgYXdzLXVzLWdvdl07IGRlZmF1bHRzIHRvIGBhd3NgLCB1bmxlc3MgdXNpbmcgdGhlIENESywgd2hlcmUgdGhlIGRlZmF1bHQgaXMgdGhlIGN1cnJlbnQgU3RhY2sncyBwYXJ0aXRpb24uXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmQXdzUmVzb3VyY2VUYWcoKVxuICAgKi9cbiAgcHVibGljIG9uTW9kZWwobW9kZWxOYW1lOiBzdHJpbmcsIG1vZGVsSWQ6IHN0cmluZywgYWNjb3VudD86IHN0cmluZywgcmVnaW9uPzogc3RyaW5nLCBwYXJ0aXRpb24/OiBzdHJpbmcpIHtcbiAgICByZXR1cm4gdGhpcy5vbihgYXJuOiR7IHBhcnRpdGlvbiA/PyB0aGlzLmRlZmF1bHRQYXJ0aXRpb24gfTpsb29rb3V0ZXF1aXBtZW50OiR7IHJlZ2lvbiA/PyB0aGlzLmRlZmF1bHRSZWdpb24gfTokeyBhY2NvdW50ID8/IHRoaXMuZGVmYXVsdEFjY291bnQgfTptb2RlbC8keyBtb2RlbE5hbWUgfS8keyBtb2RlbElkIH1gKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBBZGRzIGEgcmVzb3VyY2Ugb2YgdHlwZSBtb2RlbC12ZXJzaW9uIHRvIHRoZSBzdGF0ZW1lbnRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2xvb2tvdXQtZm9yLWVxdWlwbWVudC9sYXRlc3QvdWcvbW9kZWwtdmVyc2lvbi5odG1sXG4gICAqXG4gICAqIEBwYXJhbSBtb2RlbE5hbWUgLSBJZGVudGlmaWVyIGZvciB0aGUgbW9kZWxOYW1lLlxuICAgKiBAcGFyYW0gbW9kZWxJZCAtIElkZW50aWZpZXIgZm9yIHRoZSBtb2RlbElkLlxuICAgKiBAcGFyYW0gbW9kZWxWZXJzaW9uTnVtYmVyIC0gSWRlbnRpZmllciBmb3IgdGhlIG1vZGVsVmVyc2lvbk51bWJlci5cbiAgICogQHBhcmFtIGFjY291bnQgLSBBY2NvdW50IG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gYCpgLCB1bmxlc3MgdXNpbmcgdGhlIENESywgd2hlcmUgdGhlIGRlZmF1bHQgaXMgdGhlIGN1cnJlbnQgU3RhY2sncyBhY2NvdW50LlxuICAgKiBAcGFyYW0gcmVnaW9uIC0gUmVnaW9uIG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gYCpgLCB1bmxlc3MgdXNpbmcgdGhlIENESywgd2hlcmUgdGhlIGRlZmF1bHQgaXMgdGhlIGN1cnJlbnQgU3RhY2sncyByZWdpb24uXG4gICAqIEBwYXJhbSBwYXJ0aXRpb24gLSBQYXJ0aXRpb24gb2YgdGhlIEFXUyBhY2NvdW50IFthd3MsIGF3cy1jbiwgYXdzLXVzLWdvdl07IGRlZmF1bHRzIHRvIGBhd3NgLCB1bmxlc3MgdXNpbmcgdGhlIENESywgd2hlcmUgdGhlIGRlZmF1bHQgaXMgdGhlIGN1cnJlbnQgU3RhY2sncyBwYXJ0aXRpb24uXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmQXdzUmVzb3VyY2VUYWcoKVxuICAgKi9cbiAgcHVibGljIG9uTW9kZWxWZXJzaW9uKG1vZGVsTmFtZTogc3RyaW5nLCBtb2RlbElkOiBzdHJpbmcsIG1vZGVsVmVyc2lvbk51bWJlcjogc3RyaW5nLCBhY2NvdW50Pzogc3RyaW5nLCByZWdpb24/OiBzdHJpbmcsIHBhcnRpdGlvbj86IHN0cmluZykge1xuICAgIHJldHVybiB0aGlzLm9uKGBhcm46JHsgcGFydGl0aW9uID8/IHRoaXMuZGVmYXVsdFBhcnRpdGlvbiB9Omxvb2tvdXRlcXVpcG1lbnQ6JHsgcmVnaW9uID8/IHRoaXMuZGVmYXVsdFJlZ2lvbiB9OiR7IGFjY291bnQgPz8gdGhpcy5kZWZhdWx0QWNjb3VudCB9Om1vZGVsLyR7IG1vZGVsTmFtZSB9LyR7IG1vZGVsSWQgfS9tb2RlbC12ZXJzaW9uLyR7IG1vZGVsVmVyc2lvbk51bWJlciB9YCk7XG4gIH1cblxuICAvKipcbiAgICogQWRkcyBhIHJlc291cmNlIG9mIHR5cGUgaW5mZXJlbmNlLXNjaGVkdWxlciB0byB0aGUgc3RhdGVtZW50XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9sb29rb3V0LWZvci1lcXVpcG1lbnQvbGF0ZXN0L3VnL2luZmVyZW5jZS1zY2hlZHVsZXIuaHRtbFxuICAgKlxuICAgKiBAcGFyYW0gaW5mZXJlbmNlU2NoZWR1bGVyTmFtZSAtIElkZW50aWZpZXIgZm9yIHRoZSBpbmZlcmVuY2VTY2hlZHVsZXJOYW1lLlxuICAgKiBAcGFyYW0gaW5mZXJlbmNlU2NoZWR1bGVySWQgLSBJZGVudGlmaWVyIGZvciB0aGUgaW5mZXJlbmNlU2NoZWR1bGVySWQuXG4gICAqIEBwYXJhbSBhY2NvdW50IC0gQWNjb3VudCBvZiB0aGUgcmVzb3VyY2U7IGRlZmF1bHRzIHRvIGAqYCwgdW5sZXNzIHVzaW5nIHRoZSBDREssIHdoZXJlIHRoZSBkZWZhdWx0IGlzIHRoZSBjdXJyZW50IFN0YWNrJ3MgYWNjb3VudC5cbiAgICogQHBhcmFtIHJlZ2lvbiAtIFJlZ2lvbiBvZiB0aGUgcmVzb3VyY2U7IGRlZmF1bHRzIHRvIGAqYCwgdW5sZXNzIHVzaW5nIHRoZSBDREssIHdoZXJlIHRoZSBkZWZhdWx0IGlzIHRoZSBjdXJyZW50IFN0YWNrJ3MgcmVnaW9uLlxuICAgKiBAcGFyYW0gcGFydGl0aW9uIC0gUGFydGl0aW9uIG9mIHRoZSBBV1MgYWNjb3VudCBbYXdzLCBhd3MtY24sIGF3cy11cy1nb3ZdOyBkZWZhdWx0cyB0byBgYXdzYCwgdW5sZXNzIHVzaW5nIHRoZSBDREssIHdoZXJlIHRoZSBkZWZhdWx0IGlzIHRoZSBjdXJyZW50IFN0YWNrJ3MgcGFydGl0aW9uLlxuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1Jlc291cmNlVGFnKClcbiAgICovXG4gIHB1YmxpYyBvbkluZmVyZW5jZVNjaGVkdWxlcihpbmZlcmVuY2VTY2hlZHVsZXJOYW1lOiBzdHJpbmcsIGluZmVyZW5jZVNjaGVkdWxlcklkOiBzdHJpbmcsIGFjY291bnQ/OiBzdHJpbmcsIHJlZ2lvbj86IHN0cmluZywgcGFydGl0aW9uPzogc3RyaW5nKSB7XG4gICAgcmV0dXJuIHRoaXMub24oYGFybjokeyBwYXJ0aXRpb24gPz8gdGhpcy5kZWZhdWx0UGFydGl0aW9uIH06bG9va291dGVxdWlwbWVudDokeyByZWdpb24gPz8gdGhpcy5kZWZhdWx0UmVnaW9uIH06JHsgYWNjb3VudCA/PyB0aGlzLmRlZmF1bHRBY2NvdW50IH06aW5mZXJlbmNlLXNjaGVkdWxlci8keyBpbmZlcmVuY2VTY2hlZHVsZXJOYW1lIH0vJHsgaW5mZXJlbmNlU2NoZWR1bGVySWQgfWApO1xuICB9XG5cbiAgLyoqXG4gICAqIEFkZHMgYSByZXNvdXJjZSBvZiB0eXBlIGxhYmVsLWdyb3VwIHRvIHRoZSBzdGF0ZW1lbnRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2xvb2tvdXQtZm9yLWVxdWlwbWVudC9sYXRlc3QvdWcvbGFiZWwtZ3JvdXAuaHRtbFxuICAgKlxuICAgKiBAcGFyYW0gbGFiZWxHcm91cE5hbWUgLSBJZGVudGlmaWVyIGZvciB0aGUgbGFiZWxHcm91cE5hbWUuXG4gICAqIEBwYXJhbSBsYWJlbEdyb3VwSWQgLSBJZGVudGlmaWVyIGZvciB0aGUgbGFiZWxHcm91cElkLlxuICAgKiBAcGFyYW0gYWNjb3VudCAtIEFjY291bnQgb2YgdGhlIHJlc291cmNlOyBkZWZhdWx0cyB0byBgKmAsIHVubGVzcyB1c2luZyB0aGUgQ0RLLCB3aGVyZSB0aGUgZGVmYXVsdCBpcyB0aGUgY3VycmVudCBTdGFjaydzIGFjY291bnQuXG4gICAqIEBwYXJhbSByZWdpb24gLSBSZWdpb24gb2YgdGhlIHJlc291cmNlOyBkZWZhdWx0cyB0byBgKmAsIHVubGVzcyB1c2luZyB0aGUgQ0RLLCB3aGVyZSB0aGUgZGVmYXVsdCBpcyB0aGUgY3VycmVudCBTdGFjaydzIHJlZ2lvbi5cbiAgICogQHBhcmFtIHBhcnRpdGlvbiAtIFBhcnRpdGlvbiBvZiB0aGUgQVdTIGFjY291bnQgW2F3cywgYXdzLWNuLCBhd3MtdXMtZ292XTsgZGVmYXVsdHMgdG8gYGF3c2AsIHVubGVzcyB1c2luZyB0aGUgQ0RLLCB3aGVyZSB0aGUgZGVmYXVsdCBpcyB0aGUgY3VycmVudCBTdGFjaydzIHBhcnRpdGlvbi5cbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NSZXNvdXJjZVRhZygpXG4gICAqL1xuICBwdWJsaWMgb25MYWJlbEdyb3VwKGxhYmVsR3JvdXBOYW1lOiBzdHJpbmcsIGxhYmVsR3JvdXBJZDogc3RyaW5nLCBhY2NvdW50Pzogc3RyaW5nLCByZWdpb24/OiBzdHJpbmcsIHBhcnRpdGlvbj86IHN0cmluZykge1xuICAgIHJldHVybiB0aGlzLm9uKGBhcm46JHsgcGFydGl0aW9uID8/IHRoaXMuZGVmYXVsdFBhcnRpdGlvbiB9Omxvb2tvdXRlcXVpcG1lbnQ6JHsgcmVnaW9uID8/IHRoaXMuZGVmYXVsdFJlZ2lvbiB9OiR7IGFjY291bnQgPz8gdGhpcy5kZWZhdWx0QWNjb3VudCB9OmxhYmVsLWdyb3VwLyR7IGxhYmVsR3JvdXBOYW1lIH0vJHsgbGFiZWxHcm91cElkIH1gKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBGaWx0ZXJzIGFjY2VzcyBieSB0aGUgcHJlc2VuY2Ugb2YgdGFnIGtleS12YWx1ZSBwYWlycyBpbiB0aGUgcmVxdWVzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vSUFNL2xhdGVzdC9Vc2VyR3VpZGUvcmVmZXJlbmNlX3BvbGljaWVzX2NvbmRpdGlvbi1rZXlzLmh0bWwjY29uZGl0aW9uLWtleXMtcmVxdWVzdHRhZ1xuICAgKlxuICAgKiBBcHBsaWVzIHRvIGFjdGlvbnM6XG4gICAqIC0gLnRvQ3JlYXRlRGF0YXNldCgpXG4gICAqIC0gLnRvQ3JlYXRlSW5mZXJlbmNlU2NoZWR1bGVyKClcbiAgICogLSAudG9DcmVhdGVMYWJlbEdyb3VwKClcbiAgICogLSAudG9DcmVhdGVNb2RlbCgpXG4gICAqIC0gLnRvSW1wb3J0RGF0YXNldCgpXG4gICAqIC0gLnRvSW1wb3J0TW9kZWxWZXJzaW9uKClcbiAgICogLSAudG9UYWdSZXNvdXJjZSgpXG4gICAqXG4gICAqIEBwYXJhbSB0YWdLZXkgVGhlIHRhZyBrZXkgdG8gY2hlY2tcbiAgICogQHBhcmFtIHZhbHVlIFRoZSB2YWx1ZShzKSB0byBjaGVja1xuICAgKiBAcGFyYW0gb3BlcmF0b3IgV29ya3Mgd2l0aCBbc3RyaW5nIG9wZXJhdG9yc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0lBTS9sYXRlc3QvVXNlckd1aWRlL3JlZmVyZW5jZV9wb2xpY2llc19lbGVtZW50c19jb25kaXRpb25fb3BlcmF0b3JzLmh0bWwjQ29uZGl0aW9uc19TdHJpbmcpLiAqKkRlZmF1bHQ6KiogYFN0cmluZ0xpa2VgXG4gICAqL1xuICBwdWJsaWMgaWZBd3NSZXF1ZXN0VGFnKHRhZ0tleTogc3RyaW5nLCB2YWx1ZTogc3RyaW5nIHwgc3RyaW5nW10sIG9wZXJhdG9yPzogT3BlcmF0b3IgfCBzdHJpbmcpIHtcbiAgICByZXR1cm4gdGhpcy5pZihgYXdzOlJlcXVlc3RUYWcvJHsgdGFnS2V5IH1gLCB2YWx1ZSwgb3BlcmF0b3IgPz8gJ1N0cmluZ0xpa2UnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBGaWx0ZXJzIGFjY2VzcyBieSB0YWcga2V5LXZhbHVlIHBhaXJzIGF0dGFjaGVkIHRvIHRoZSByZXNvdXJjZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vSUFNL2xhdGVzdC9Vc2VyR3VpZGUvcmVmZXJlbmNlX3BvbGljaWVzX2NvbmRpdGlvbi1rZXlzLmh0bWwjY29uZGl0aW9uLWtleXMtcmVzb3VyY2V0YWdcbiAgICpcbiAgICogQXBwbGllcyB0byByZXNvdXJjZSB0eXBlczpcbiAgICogLSBkYXRhc2V0XG4gICAqIC0gbW9kZWxcbiAgICogLSBtb2RlbC12ZXJzaW9uXG4gICAqIC0gaW5mZXJlbmNlLXNjaGVkdWxlclxuICAgKiAtIGxhYmVsLWdyb3VwXG4gICAqXG4gICAqIEBwYXJhbSB0YWdLZXkgVGhlIHRhZyBrZXkgdG8gY2hlY2tcbiAgICogQHBhcmFtIHZhbHVlIFRoZSB2YWx1ZShzKSB0byBjaGVja1xuICAgKiBAcGFyYW0gb3BlcmF0b3IgV29ya3Mgd2l0aCBbc3RyaW5nIG9wZXJhdG9yc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0lBTS9sYXRlc3QvVXNlckd1aWRlL3JlZmVyZW5jZV9wb2xpY2llc19lbGVtZW50c19jb25kaXRpb25fb3BlcmF0b3JzLmh0bWwjQ29uZGl0aW9uc19TdHJpbmcpLiAqKkRlZmF1bHQ6KiogYFN0cmluZ0xpa2VgXG4gICAqL1xuICBwdWJsaWMgaWZBd3NSZXNvdXJjZVRhZyh0YWdLZXk6IHN0cmluZywgdmFsdWU6IHN0cmluZyB8IHN0cmluZ1tdLCBvcGVyYXRvcj86IE9wZXJhdG9yIHwgc3RyaW5nKSB7XG4gICAgcmV0dXJuIHRoaXMuaWYoYGF3czpSZXNvdXJjZVRhZy8keyB0YWdLZXkgfWAsIHZhbHVlLCBvcGVyYXRvciA/PyAnU3RyaW5nTGlrZScpO1xuICB9XG5cbiAgLyoqXG4gICAqIEZpbHRlcnMgYWNjZXNzIGJ5IHRoZSBwcmVzZW5jZSBvZiB0YWcga2V5cyBpbiB0aGUgcmVxdWVzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vSUFNL2xhdGVzdC9Vc2VyR3VpZGUvcmVmZXJlbmNlX3BvbGljaWVzX2NvbmRpdGlvbi1rZXlzLmh0bWwjY29uZGl0aW9uLWtleXMtdGFna2V5c1xuICAgKlxuICAgKiBBcHBsaWVzIHRvIGFjdGlvbnM6XG4gICAqIC0gLnRvQ3JlYXRlRGF0YXNldCgpXG4gICAqIC0gLnRvQ3JlYXRlSW5mZXJlbmNlU2NoZWR1bGVyKClcbiAgICogLSAudG9DcmVhdGVMYWJlbEdyb3VwKClcbiAgICogLSAudG9DcmVhdGVNb2RlbCgpXG4gICAqIC0gLnRvSW1wb3J0RGF0YXNldCgpXG4gICAqIC0gLnRvSW1wb3J0TW9kZWxWZXJzaW9uKClcbiAgICogLSAudG9UYWdSZXNvdXJjZSgpXG4gICAqIC0gLnRvVW50YWdSZXNvdXJjZSgpXG4gICAqXG4gICAqIEBwYXJhbSB2YWx1ZSBUaGUgdmFsdWUocykgdG8gY2hlY2tcbiAgICogQHBhcmFtIG9wZXJhdG9yIFdvcmtzIHdpdGggW3N0cmluZyBvcGVyYXRvcnNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9JQU0vbGF0ZXN0L1VzZXJHdWlkZS9yZWZlcmVuY2VfcG9saWNpZXNfZWxlbWVudHNfY29uZGl0aW9uX29wZXJhdG9ycy5odG1sI0NvbmRpdGlvbnNfU3RyaW5nKS4gKipEZWZhdWx0OioqIGBTdHJpbmdMaWtlYFxuICAgKi9cbiAgcHVibGljIGlmQXdzVGFnS2V5cyh2YWx1ZTogc3RyaW5nIHwgc3RyaW5nW10sIG9wZXJhdG9yPzogT3BlcmF0b3IgfCBzdHJpbmcpIHtcbiAgICByZXR1cm4gdGhpcy5pZihgYXdzOlRhZ0tleXNgLCB2YWx1ZSwgb3BlcmF0b3IgPz8gJ1N0cmluZ0xpa2UnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBGaWx0ZXJzIGFjY2VzcyBieSB0aGUgaW1wb3J0IHN0cmF0ZWd5IG9mIHVuZGVybHlpbmcgZGF0YVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vSUFNL2xhdGVzdC9Vc2VyR3VpZGUvcmVmZXJlbmNlX3BvbGljaWVzX2NvbmRpdGlvbi1rZXlzLmh0bWwjY29uZGl0aW9uLWtleXMtaXNpbXBvcnRpbmdkYXRhXG4gICAqXG4gICAqIEFwcGxpZXMgdG8gYWN0aW9uczpcbiAgICogLSAudG9JbXBvcnRNb2RlbFZlcnNpb24oKVxuICAgKlxuICAgKiBAcGFyYW0gdmFsdWUgYHRydWVgIG9yIGBmYWxzZWAuICoqRGVmYXVsdDoqKiBgdHJ1ZWBcbiAgICovXG4gIHB1YmxpYyBpZklzSW1wb3J0aW5nRGF0YSh2YWx1ZT86IGJvb2xlYW4pIHtcbiAgICByZXR1cm4gdGhpcy5pZihgSXNJbXBvcnRpbmdEYXRhYCwgKHR5cGVvZiB2YWx1ZSAhPT0gJ3VuZGVmaW5lZCcgPyB2YWx1ZSA6IHRydWUpLCAnQm9vbCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIFN0YXRlbWVudCBwcm92aWRlciBmb3Igc2VydmljZSBbbG9va291dGVxdWlwbWVudF0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3NlcnZpY2UtYXV0aG9yaXphdGlvbi9sYXRlc3QvcmVmZXJlbmNlL2xpc3RfYW1hem9ubG9va291dGZvcmVxdWlwbWVudC5odG1sKS5cbiAgICpcbiAgICovXG4gIGNvbnN0cnVjdG9yKHByb3BzPzogaWFtLlBvbGljeVN0YXRlbWVudFByb3BzKSB7XG4gICAgc3VwZXIocHJvcHMpO1xuICB9XG59XG4iXX0=