"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ManagedblockchainQuery = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [managedblockchain-query](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmanagedblockchainquery.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class ManagedblockchainQuery extends shared_1.PolicyStatement {
    /**
     * Grants permission to batch calls for GetTokenBalance API
     *
     * Access Level: Read
     */
    toBatchGetTokenBalance() {
        return this.to('BatchGetTokenBalance');
    }
    /**
     * Grants permission to fetch information about a contract on the blockchain
     *
     * Access Level: Read
     */
    toGetAssetContract() {
        return this.to('GetAssetContract');
    }
    /**
     * Grants permission to retrieve balance of a token for an address on the blockchain
     *
     * Access Level: Read
     */
    toGetTokenBalance() {
        return this.to('GetTokenBalance');
    }
    /**
     * Grants permission to retrieve a transaction on the blockchain
     *
     * Access Level: Read
     */
    toGetTransaction() {
        return this.to('GetTransaction');
    }
    /**
     * Grants permission to fetch multiple contracts on the blockchain
     *
     * Access Level: List
     */
    toListAssetContracts() {
        return this.to('ListAssetContracts');
    }
    /**
     * Grants permission to retrieve events on the blockchain with additional filters
     *
     * Access Level: List
     */
    toListFilteredTransactionEvents() {
        return this.to('ListFilteredTransactionEvents');
    }
    /**
     * Grants permission to retrieve multiple balances on the blockchain
     *
     * Access Level: List
     */
    toListTokenBalances() {
        return this.to('ListTokenBalances');
    }
    /**
     * Grants permission to retrieve events in a transaction on the blockchain
     *
     * Access Level: List
     */
    toListTransactionEvents() {
        return this.to('ListTransactionEvents');
    }
    /**
     * Grants permission to retrieve a multiple transactions on a blockchain
     *
     * Access Level: List
     */
    toListTransactions() {
        return this.to('ListTransactions');
    }
    /**
     * Statement provider for service [managedblockchain-query](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmanagedblockchainquery.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'managedblockchain-query';
        this.accessLevelList = {
            Read: [
                'BatchGetTokenBalance',
                'GetAssetContract',
                'GetTokenBalance',
                'GetTransaction'
            ],
            List: [
                'ListAssetContracts',
                'ListFilteredTransactionEvents',
                'ListTokenBalances',
                'ListTransactionEvents',
                'ListTransactions'
            ]
        };
    }
}
exports.ManagedblockchainQuery = ManagedblockchainQuery;
//# sourceMappingURL=data:application/json;base64,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