import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [marketplacecommerceanalytics](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplacecommerceanalyticsservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Marketplacecommerceanalytics extends PolicyStatement {
    servicePrefix: string;
    /**
     * Request a data set to be published to your Amazon S3 bucket.
     *
     * Access Level: Write
     */
    toGenerateDataSet(): this;
    /**
     * Request a support data set to be published to your Amazon S3 bucket.
     *
     * Access Level: Write
     */
    toStartSupportDataExport(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Statement provider for service [marketplacecommerceanalytics](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplacecommerceanalyticsservice.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
