import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [aws-marketplace-discovery](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplacediscovery.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class AwsMarketplaceDiscovery extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to users to list their private offers
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-offers-page.html
     */
    toListPrivateListings(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Statement provider for service [aws-marketplace-discovery](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplacediscovery.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
