"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsMarketplaceSellerReporting = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [aws-marketplace-seller-reporting](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplacesellerreporting.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class AwsMarketplaceSellerReporting extends shared_1.PolicyStatement {
    /**
     * Grants permission to view a seller dashboard
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/dashboards.html#reports-accessing
     */
    toGetSellerDashboard() {
        return this.to('GetSellerDashboard');
    }
    /**
     * Adds a resource of type SellerDashboard to the statement
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/dashboards.html#reports-accessing
     *
     * @param catalog - Identifier for the catalog.
     * @param factTable - Identifier for the factTable.
     * @param dashboardName - Identifier for the dashboardName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onSellerDashboard(catalog, factTable, dashboardName, account, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:aws-marketplace::${account ?? this.defaultAccount}:${catalog}/ReportingData/${factTable}/Dashboard/${dashboardName}`);
    }
    /**
     * Statement provider for service [aws-marketplace-seller-reporting](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplacesellerreporting.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'aws-marketplace';
        this.accessLevelList = {
            Read: [
                'GetSellerDashboard'
            ]
        };
    }
}
exports.AwsMarketplaceSellerReporting = AwsMarketplaceSellerReporting;
//# sourceMappingURL=data:application/json;base64,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