import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [mgh](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmigrationhub.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Mgh extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to accept a connection
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/mhj/latest/userguide/account-connections.html
     */
    toAcceptConnection(): this;
    /**
     * Grants permission to associate an IAM role to an automation unit
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub/latest/ug/API_AssociateAutomationUnitRole.html
     */
    toAssociateAutomationUnitRole(): this;
    /**
     * Grants permission to associate a given AWS artifact to a MigrationTask
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub/latest/ug/API_AssociateCreatedArtifact.html
     */
    toAssociateCreatedArtifact(): this;
    /**
     * Grants permission to associate a given ADS resource to a MigrationTask
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub/latest/ug/API_AssociateDiscoveredResource.html
     */
    toAssociateDiscoveredResource(): this;
    /**
     * Grants permission to associate source resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub/latest/ug/API_AssociateSourceResource.html
     */
    toAssociateSourceResource(): this;
    /**
     * Grants permission to batch-associate IAM roles with a connection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mhj/latest/userguide/account-connections.html
     */
    toBatchAssociateIamRoleWithConnection(): this;
    /**
     * Grants permission to batch-disassociate IAM roles from a connection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mhj/latest/userguide/account-connections.html
     */
    toBatchDisassociateIamRoleFromConnection(): this;
    /**
     * Grants permission to create an automation unit run
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub/latest/ug/API_CreateAutomationRun.html
     */
    toCreateAutomationRun(): this;
    /**
     * Grants permission to create an automation unit
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub/latest/ug/API_CreateAutomationUnit.html
     */
    toCreateAutomationUnit(): this;
    /**
     * Grants permission to create a Migration Hub Home Region Control
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-home-region/latest/APIReference/API_CreateHomeRegionControl.html
     */
    toCreateHomeRegionControl(): this;
    /**
     * Grants permission to create a ProgressUpdateStream
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub/latest/ug/API_CreateProgressUpdateStream.html
     */
    toCreateProgressUpdateStream(): this;
    /**
     * Grants permission to delete an automation unit run
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub/latest/ug/API_DeleteAutomationRun.html
     */
    toDeleteAutomationRun(): this;
    /**
     * Grants permission to delete an automation unit
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub/latest/ug/API_DeleteAutomationUnit.html
     */
    toDeleteAutomationUnit(): this;
    /**
     * Grants permission to delete a connection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mhj/latest/userguide/account-connections.html
     */
    toDeleteConnection(): this;
    /**
     * Grants permission to delete a Migration Hub Home Region Control
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-home-region/latest/APIReference/API_DeleteHomeRegionControl.html
     */
    toDeleteHomeRegionControl(): this;
    /**
     * Grants permission to delete a ProgressUpdateStream
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub/latest/ug/API_DeleteProgressUpdateStream.html
     */
    toDeleteProgressUpdateStream(): this;
    /**
     * Grants permission to get an Application Discovery Service Application's state
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub/latest/ug/API_DescribeApplicationState.html
     */
    toDescribeApplicationState(): this;
    /**
     * Grants permission to describe an automation unit run
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub/latest/ug/API_DescribeAutomationRun.html
     */
    toDescribeAutomationRun(): this;
    /**
     * Grants permission to describe an automation unit
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub/latest/ug/API_DescribeAutomationUnit.html
     */
    toDescribeAutomationUnit(): this;
    /**
     * Grants permission to list Home Region Controls
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub-home-region/latest/APIReference/API_DescribeHomeRegionControls.html
     */
    toDescribeHomeRegionControls(): this;
    /**
     * Grants permission to describe a MigrationTask
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub/latest/ug/API_DescribeMigrationTask.html
     */
    toDescribeMigrationTask(): this;
    /**
     * Grants permission to disassociate an IAM role from an automation unit
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub/latest/ug/API_DisassociateAutomationUnitRole.html
     */
    toDisassociateAutomationUnitRole(): this;
    /**
     * Grants permission to disassociate a given AWS artifact from a MigrationTask
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub/latest/ug/API_DisassociateCreatedArtifact.html
     */
    toDisassociateCreatedArtifact(): this;
    /**
     * Grants permission to disassociate a given ADS resource from a MigrationTask
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub/latest/ug/API_DisassociateDiscoveredResource.html
     */
    toDisassociateDiscoveredResource(): this;
    /**
     * Grants permission to diassociate source resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub/latest/ug/API_DisassociateSourceResource.html
     */
    toDisassociateSourceResource(): this;
    /**
     * Grants permission to get a connection
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mhj/latest/userguide/account-connections.html
     */
    toGetConnection(): this;
    /**
     * Grants permission to get the Migration Hub Home Region
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-home-region/latest/APIReference/API_GetHomeRegion.html
     */
    toGetHomeRegion(): this;
    /**
     * Grants permission to import a MigrationTask
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub/latest/ug/API_ImportMigrationTask.html
     */
    toImportMigrationTask(): this;
    /**
     * Grants permission to list Application statuses
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub/latest/ug/API_ListApplicationStates.html
     */
    toListApplicationStates(): this;
    /**
     * Grants permission to list automation unit runs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub/latest/ug/API_ListAutomationRuns.html
     */
    toListAutomationRuns(): this;
    /**
     * Grants permission to list automation units
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub/latest/ug/API_ListAutomationUnits.html
     */
    toListAutomationUnits(): this;
    /**
     * Grants permission to list connection roles
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mhj/latest/userguide/account-connections.html
     */
    toListConnectionRoles(): this;
    /**
     * Grants permission to list connections
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mhj/latest/userguide/account-connections.html
     */
    toListConnections(): this;
    /**
     * Grants permission to list associated created artifacts for a MigrationTask
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub/latest/ug/API_ListCreatedArtifacts.html
     */
    toListCreatedArtifacts(): this;
    /**
     * Grants permission to list associated ADS resources from MigrationTask
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub/latest/ug/API_ListDiscoveredResources.html
     */
    toListDiscoveredResources(): this;
    /**
     * Grants permission to list migration tasks updates
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub/latest/ug/API_ListMigrationTaskUpdates.html
     */
    toListMigrationTaskUpdates(): this;
    /**
     * Grants permission to list MigrationTasks
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub/latest/ug/API_ListMigrationTasks.html
     */
    toListMigrationTasks(): this;
    /**
     * Grants permission to to list ProgressUpdateStreams
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub/latest/ug/API_ListProgressUpdateStreams.html
     */
    toListProgressUpdateStreams(): this;
    /**
     * Grants permission to list source resources
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub/latest/ug/API_ListSourceResources.html
     */
    toListSourceResources(): this;
    /**
     * Grants permission to list tags for a resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub/latest/ug/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to update an Application Discovery Service Application's state
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub/latest/ug/API_NotifyApplicationState.html
     */
    toNotifyApplicationState(): this;
    /**
     * Grants permission to notify latest MigrationTask state
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub/latest/ug/API_NotifyMigrationTaskState.html
     */
    toNotifyMigrationTaskState(): this;
    /**
     * Grants permission to put ResourceAttributes
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub/latest/ug/API_PutResourceAttributes.html
     */
    toPutResourceAttributes(): this;
    /**
     * Grants permission to reject a connection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mhj/latest/userguide/account-connections.html
     */
    toRejectConnection(): this;
    /**
     * Grants permission to tag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/migrationhub/latest/ug/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to untag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/migrationhub/latest/ug/API_UntagResource.html
     */
    toUntagResource(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type progressUpdateStream to the statement
     *
     * https://docs.aws.amazon.com/migrationhub/latest/ug/API_ProgressUpdateStreamSummary.html
     *
     * @param stream - Identifier for the stream.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onProgressUpdateStream(stream: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type migrationTask to the statement
     *
     * https://docs.aws.amazon.com/migrationhub/latest/ug/API_MigrationTask.html
     *
     * @param stream - Identifier for the stream.
     * @param task - Identifier for the task.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onMigrationTask(stream: string, task: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type AutomationRunResource to the statement
     *
     * https://docs.aws.amazon.com/migrationhub/latest/ug/API_AutomationRunResource.html
     *
     * @param runID - Identifier for the runID.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAutomationRunResourceRunID()
     */
    onAutomationRunResource(runID: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type AutomationUnitResource to the statement
     *
     * https://docs.aws.amazon.com/migrationhub/latest/ug/API_AutomationUnitResource.html
     *
     * @param automationUnitId - Identifier for the automationUnitId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAutomationUnitResourceAutomationUnitArn()
     */
    onAutomationUnitResource(automationUnitId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type ConnectionResource to the statement
     *
     * https://docs.aws.amazon.com/migrationhub/latest/ug/API_ConnectionResource.html
     *
     * @param connectionArn - Identifier for the connectionArn.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifConnectionResourceConnectionArn()
     */
    onConnectionResource(connectionArn: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access based on the tags that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toAcceptConnection()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access based on the tags associated with the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to resource types:
     * - ConnectionResource
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access based on the tag keys that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toAcceptConnection()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * AutomationRunResource resource runID identifier
     *
     * https://docs.aws.amazon.com/migrationhub/latest/ug/ContextKeys_AutomationRunResourceRunID.html
     *
     * Applies to resource types:
     * - AutomationRunResource
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAutomationRunResourceRunID(value: string | string[], operator?: Operator | string): this;
    /**
     * AutomationUnitResource resource automationUnitArn identifier
     *
     * https://docs.aws.amazon.com/migrationhub/latest/ug/ContextKeys_AutomationUnitResourceAutomationUnitArn.html
     *
     * Applies to resource types:
     * - AutomationUnitResource
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifAutomationUnitResourceAutomationUnitArn(value: string | string[], operator?: Operator | string): this;
    /**
     * ConnectionResource resource connectionArn identifier
     *
     * https://docs.aws.amazon.com/migrationhub/latest/ug/security_iam_service-with-iam-id-based-policies-conditionkeys.html#condition-connectionresourceconnectionarn
     *
     * Applies to resource types:
     * - ConnectionResource
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifConnectionResourceConnectionArn(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [mgh](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmigrationhub.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
