import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [networkmanager-chat](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsnetworkmanagerchat.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class NetworkmanagerChat extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to cancel a response to a message
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/vpc/latest/reachability/security_iam_required-API-permissions.html
     */
    toCancelMessageResponse(): this;
    /**
     * Grants permission to create a conversation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/vpc/latest/reachability/security_iam_required-API-permissions.html
     */
    toCreateConversation(): this;
    /**
     * Grants permission to delete a conversation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/vpc/latest/reachability/security_iam_required-API-permissions.html
     */
    toDeleteConversation(): this;
    /**
     * Grants permission to list conversation messages
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/vpc/latest/reachability/security_iam_required-API-permissions.html
     */
    toListConversationMessages(): this;
    /**
     * Grants permission to list conversations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/vpc/latest/reachability/security_iam_required-API-permissions.html
     */
    toListConversations(): this;
    /**
     * Grants permission to notify whether there is activity in a conversation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/vpc/latest/reachability/security_iam_required-API-permissions.html
     */
    toNotifyConversationIsActive(): this;
    /**
     * Grants permission to send a conversation message
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/vpc/latest/reachability/security_iam_required-API-permissions.html
     */
    toSendConversationMessage(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Statement provider for service [networkmanager-chat](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsnetworkmanagerchat.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
