import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [one](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazononeenterprise.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class One extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to create a QR code for a Device Instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/one-enterprise/latest/userguide/configure-instance.html
     */
    toCreateDeviceActivationQrCode(): this;
    /**
     * Grants permission to create a Device Configuration Template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/one-enterprise/latest/userguide/create-config-template.html
     */
    toCreateDeviceConfigurationTemplate(): this;
    /**
     * Grants permission to create a Device Instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/one-enterprise/latest/userguide/create-device-instance.html
     */
    toCreateDeviceInstance(): this;
    /**
     * Grants permission to create a Device Instance Configuration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/one-enterprise/latest/userguide/configure-instance.html
     */
    toCreateDeviceInstanceConfiguration(): this;
    /**
     * Grants permission to create a Site
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/one-enterprise/latest/userguide/create-sites.html
     */
    toCreateSite(): this;
    /**
     * Grants permission to disassociate Device from a Device Instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/one-enterprise/latest/userguide/create-device-instance.html
     */
    toDeleteAssociatedDevice(): this;
    /**
     * Grants permission to delete a Device Configuration Template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/one-enterprise/latest/userguide/create-config-template.html
     */
    toDeleteDeviceConfigurationTemplate(): this;
    /**
     * Grants permission to delete a Device Instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/one-enterprise/latest/userguide/create-device-instance.html
     */
    toDeleteDeviceInstance(): this;
    /**
     * Grants permission to delete a Site
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/one-enterprise/latest/userguide/create-sites.html
     */
    toDeleteSite(): this;
    /**
     * Grants permission to delete a User
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/one-enterprise/latest/userguide/enrollment-entry.htmll
     */
    toDeleteUserV1(): this;
    /**
     * Grants permission to view a Device Configuration Template
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/one-enterprise/latest/userguide/create-config-template.html
     */
    toGetDeviceConfigurationTemplate(): this;
    /**
     * Grants permission to view a Device Instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/one-enterprise/latest/userguide/create-device-instance.html
     */
    toGetDeviceInstance(): this;
    /**
     * Grants permission to view a Device Instance Configuration
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/one-enterprise/latest/userguide/configure-instance.html
     */
    toGetDeviceInstanceConfiguration(): this;
    /**
     * Grants permission to view a Site
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/one-enterprise/latest/userguide/create-sites.html
     */
    toGetSite(): this;
    /**
     * Grants permission to view address of a Site
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/one-enterprise/latest/userguide/create-sites.html
     */
    toGetSiteAddress(): this;
    /**
     * Grants permission to retrieve list of Device Configuration Templates
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/one-enterprise/latest/userguide/create-config-template.html
     */
    toListDeviceConfigurationTemplates(): this;
    /**
     * Grants permission to retrieve list of Device Instances
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/one-enterprise/latest/userguide/create-device-instance.html
     */
    toListDeviceInstances(): this;
    /**
     * Grants permission to view list of Sites
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/one-enterprise/latest/userguide/create-sites.html
     */
    toListSites(): this;
    /**
     * Grants permission to list tags for an Amazon One Enterprise resource
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/one-enterprise/latest/userguide/actions-resources-contextkeys.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to view list of Users
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/one-enterprise/latest/userguide/enrollment-entry.html
     */
    toListUsersV1(): this;
    /**
     * Grants permission to reboot Device associated with a Device Instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/one-enterprise/latest/userguide/create-device-instance.html
     */
    toRebootDevice(): this;
    /**
     * Grants permission to add tags to an Amazon One Enterprise resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/one-enterprise/latest/userguide/actions-resources-contextkeys.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove tags from an Amazon One Enterprise resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/one-enterprise/latest/userguide/actions-resources-contextkeys.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update a Device Configuration Template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/one-enterprise/latest/userguide/create-config-template.html
     */
    toUpdateDeviceConfigurationTemplate(): this;
    /**
     * Grants permission to update a Device Instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/one-enterprise/latest/userguide/create-device-instance.html
     */
    toUpdateDeviceInstance(): this;
    /**
     * Grants permission to update a Site
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/one-enterprise/latest/userguide/create-sites.html
     */
    toUpdateSite(): this;
    /**
     * Grants permission to update address of a Site
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/one-enterprise/latest/userguide/create-sites.html
     */
    toUpdateSiteAddress(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type device-instance to the statement
     *
     * https://docs.aws.amazon.com/one-enterprise/latest/userguide/create-device-instance.html
     *
     * @param deviceInstanceId - Identifier for the deviceInstanceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDeviceInstance(deviceInstanceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type configuration to the statement
     *
     * https://docs.aws.amazon.com/one-enterprise/latest/userguide/configure-instance.html
     *
     * @param deviceInstanceId - Identifier for the deviceInstanceId.
     * @param version - Identifier for the version.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onConfiguration(deviceInstanceId: string, version: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type device-configuration-template to the statement
     *
     * https://docs.aws.amazon.com/one-enterprise/latest/userguide/create-config-template.html
     *
     * @param templateId - Identifier for the templateId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDeviceConfigurationTemplate(templateId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type site to the statement
     *
     * https://docs.aws.amazon.com/one-enterprise/latest/userguide/create-sites.html
     *
     * @param siteId - Identifier for the siteId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSite(siteId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type user to the statement
     *
     * https://docs.aws.amazon.com/one-enterprise/latest/userguide/enrollment-entry.html
     *
     * @param userId - Identifier for the userId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onUser(userId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by using tag key-value pairs in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateDeviceConfigurationTemplate()
     * - .toCreateDeviceInstance()
     * - .toCreateSite()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by using tag key-value pairs attached to the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to actions:
     * - .toCreateDeviceActivationQrCode()
     * - .toCreateDeviceInstanceConfiguration()
     * - .toDeleteAssociatedDevice()
     * - .toDeleteDeviceConfigurationTemplate()
     * - .toDeleteDeviceInstance()
     * - .toDeleteSite()
     * - .toGetDeviceConfigurationTemplate()
     * - .toGetDeviceInstance()
     * - .toGetDeviceInstanceConfiguration()
     * - .toGetSite()
     * - .toGetSiteAddress()
     * - .toListTagsForResource()
     * - .toRebootDevice()
     * - .toUpdateDeviceConfigurationTemplate()
     * - .toUpdateDeviceInstance()
     * - .toUpdateSite()
     * - .toUpdateSiteAddress()
     *
     * Applies to resource types:
     * - device-instance
     * - device-configuration-template
     * - site
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tag keys that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateDeviceConfigurationTemplate()
     * - .toCreateDeviceInstance()
     * - .toCreateSite()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [one](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazononeenterprise.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
