import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [partnercentral-account-management](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awspartnercentralaccountmanagement.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class PartnercentralAccountManagement extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to associate Partner account to AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/partner-central/latest/getting-started/controlling-access-in-apc-account-management.html
     */
    toAssociatePartnerAccount(): this;
    /**
     * Grants permission to associate Partner user to IAM role
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/partner-central/latest/getting-started/controlling-access-in-apc-account-management.html
     */
    toAssociatePartnerUser(): this;
    /**
     * Grants permission to disassociate Partner user to IAM role
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/partner-central/latest/getting-started/controlling-access-in-apc-account-management.html
     */
    toDisassociatePartnerUser(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Statement provider for service [partnercentral-account-management](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awspartnercentralaccountmanagement.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
