"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PartnercentralAccountManagement = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [partnercentral-account-management](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awspartnercentralaccountmanagement.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class PartnercentralAccountManagement extends shared_1.PolicyStatement {
    /**
     * Grants permission to associate Partner account to AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/partner-central/latest/getting-started/controlling-access-in-apc-account-management.html
     */
    toAssociatePartnerAccount() {
        return this.to('AssociatePartnerAccount');
    }
    /**
     * Grants permission to associate Partner user to IAM role
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/partner-central/latest/getting-started/controlling-access-in-apc-account-management.html
     */
    toAssociatePartnerUser() {
        return this.to('AssociatePartnerUser');
    }
    /**
     * Grants permission to disassociate Partner user to IAM role
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/partner-central/latest/getting-started/controlling-access-in-apc-account-management.html
     */
    toDisassociatePartnerUser() {
        return this.to('DisassociatePartnerUser');
    }
    /**
     * Statement provider for service [partnercentral-account-management](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awspartnercentralaccountmanagement.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'partnercentral-account-management';
        this.accessLevelList = {
            Write: [
                'AssociatePartnerAccount',
                'AssociatePartnerUser',
                'DisassociatePartnerUser'
            ]
        };
    }
}
exports.PartnercentralAccountManagement = PartnercentralAccountManagement;
//# sourceMappingURL=data:application/json;base64,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