import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [acm-pca](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsprivatecertificateauthority.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class AcmPca extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to create an AWS Private CA and its associated private key and configuration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/privateca/latest/APIReference/API_CreateCertificateAuthority.html
     */
    toCreateCertificateAuthority(): this;
    /**
     * Grants permission to create an audit report for an AWS Private CA
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/privateca/latest/APIReference/API_CreateCertificateAuthorityAuditReport.html
     */
    toCreateCertificateAuthorityAuditReport(): this;
    /**
     * Grants permission to create a permission for an AWS Private CA
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/privateca/latest/APIReference/API_CreatePermission.html
     */
    toCreatePermission(): this;
    /**
     * Grants permission to delete an AWS Private CA and its associated private key and configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/privateca/latest/APIReference/API_DeleteCertificateAuthority.html
     */
    toDeleteCertificateAuthority(): this;
    /**
     * Grants permission to delete a permission for an AWS Private CA
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/privateca/latest/APIReference/API_DeletePermission.html
     */
    toDeletePermission(): this;
    /**
     * Grants permission to delete the policy for an AWS Private CA
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/privateca/latest/APIReference/API_DeletePolicy.html
     */
    toDeletePolicy(): this;
    /**
     * Grants permission to return a list of the configuration and status fields contained in the specified AWS Private CA
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/privateca/latest/APIReference/API_DescribeCertificateAuthority.html
     */
    toDescribeCertificateAuthority(): this;
    /**
     * Grants permission to return the status and information about an AWS Private CA audit report
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/privateca/latest/APIReference/API_DescribeCertificateAuthorityAuditReport.html
     */
    toDescribeCertificateAuthorityAuditReport(): this;
    /**
     * Grants permission to retrieve an AWS Private CA certificate and certificate chain for the certificate authority specified by an ARN
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/privateca/latest/APIReference/API_GetCertificate.html
     */
    toGetCertificate(): this;
    /**
     * Grants permission to retrieve an AWS Private CA certificate and certificate chain for the certificate authority specified by an ARN
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/privateca/latest/APIReference/API_GetCertificateAuthorityCertificate.html
     */
    toGetCertificateAuthorityCertificate(): this;
    /**
     * Grants permission to retrieve an AWS Private CA certificate signing request (CSR) for the certificate-authority specified by an ARN
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/privateca/latest/APIReference/API_GetCertificateAuthorityCsr.html
     */
    toGetCertificateAuthorityCsr(): this;
    /**
     * Grants permission to retrieve the policy on an AWS Private CA
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/privateca/latest/APIReference/API_GetPolicy.html
     */
    toGetPolicy(): this;
    /**
     * Grants permission to import an SSL/TLS certificate into AWS Private CA for use as the CA certificate of an AWS Private CA
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/privateca/latest/APIReference/API_ImportCertificateAuthorityCertificate.html
     */
    toImportCertificateAuthorityCertificate(): this;
    /**
     * Grants permission to issue an AWS Private CA certificate
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifTemplateArn()
     *
     * https://docs.aws.amazon.com/privateca/latest/APIReference/API_IssueCertificate.html
     */
    toIssueCertificate(): this;
    /**
     * Grants permission to retrieve a list of the AWS Private CA certificate authority ARNs, and a summary of the status of each CA in the calling account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/privateca/latest/APIReference/API_ListCertificateAuthorities.html
     */
    toListCertificateAuthorities(): this;
    /**
     * Grants permission to list the permissions that have been applied to the AWS Private CA certificate authority
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/privateca/latest/APIReference/API_ListPermissions.html
     */
    toListPermissions(): this;
    /**
     * Grants permission to list the tags that have been applied to the AWS Private CA certificate authority
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/privateca/latest/APIReference/API_ListTags.html
     */
    toListTags(): this;
    /**
     * Grants permission to put a policy on an AWS Private CA
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/privateca/latest/APIReference/API_PutPolicy.html
     */
    toPutPolicy(): this;
    /**
     * Grants permission to restore an AWS Private CA from the deleted state to the state it was in when deleted
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/privateca/latest/APIReference/API_RestoreCertificateAuthority.html
     */
    toRestoreCertificateAuthority(): this;
    /**
     * Grants permission to revoke a certificate issued by an AWS Private CA
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/privateca/latest/APIReference/API_RevokeCertificate.html
     */
    toRevokeCertificate(): this;
    /**
     * Grants permission to add one or more tags to an AWS Private CA
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/privateca/latest/APIReference/API_TagCertificateAuthority.html
     */
    toTagCertificateAuthority(): this;
    /**
     * Grants permission to remove one or more tags from an AWS Private CA
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/privateca/latest/APIReference/API_UntagCertificateAuthority.html
     */
    toUntagCertificateAuthority(): this;
    /**
     * Grants permission to update the configuration of an AWS Private CA
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/privateca/latest/APIReference/API_UpdateCertificateAuthority.html
     */
    toUpdateCertificateAuthority(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type certificate-authority to the statement
     *
     * https://docs.aws.amazon.com/privateca/latest/userguide/api-permissions.html
     *
     * @param certificateAuthorityId - Identifier for the certificateAuthorityId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onCertificateAuthority(certificateAuthorityId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the arn of the certificate template used in Issue Certificate request
     *
     * https://docs.aws.amazon.com/privateca/latest/userguide/UsingTemplates.html#template-varieties
     *
     * Applies to actions:
     * - .toIssueCertificate()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifTemplateArn(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tags that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateCertificateAuthority()
     * - .toTagCertificateAuthority()
     * - .toUntagCertificateAuthority()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tags associated with the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to actions:
     * - .toCreateCertificateAuthority()
     *
     * Applies to resource types:
     * - certificate-authority
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tag keys that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateCertificateAuthority()
     * - .toTagCertificateAuthority()
     * - .toUntagCertificateAuthority()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [acm-pca](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsprivatecertificateauthority.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
