import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [resource-explorer-2](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsresourceexplorer.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class ResourceExplorer2 extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to set the specified view as the default for this AWS Region in this AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_AssociateDefaultView.html
     */
    toAssociateDefaultView(): this;
    /**
     * Grants permission to retrieve details about views that you specify by a list of ARNs
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - resource-explorer-2:GetView
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_BatchGetView.html
     */
    toBatchGetView(): this;
    /**
     * Grants permission to turn on Resource Explorer in the AWS Region in which you called this operation by creating an index
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_CreateIndex.html
     */
    toCreateIndex(): this;
    /**
     * Grants permission to create managed view
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/userguide/API_ManagedView.html
     */
    toCreateManagedView(): this;
    /**
     * Grants permission to create a view that users can query
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_CreateView.html
     */
    toCreateView(): this;
    /**
     * Grants permission to turn off Resource Explorer in the specified AWS Region by deleting the index
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_DeleteIndex.html
     */
    toDeleteIndex(): this;
    /**
     * Grants permission to delete the specified view's resource policy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-views-share.html
     */
    toDeleteResourcePolicy(): this;
    /**
     * Grants permission to delete a view
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_DeleteView.html
     */
    toDeleteView(): this;
    /**
     * Grants permission to remove the default view for the AWS Region in which you call this operation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_DisassociateDefaultView.html
     */
    toDisassociateDefaultView(): this;
    /**
     * Grants permission to Resource Explorer to access account level data within your AWS Organization
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_GetAccountLevelServiceConfiguration.html
     */
    toGetAccountLevelServiceConfiguration(): this;
    /**
     * Grants permission to retrieve the Amazon resource name (ARN) of the view that is the default for the AWS Region in which you call this operation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_GetDefaultView.html
     */
    toGetDefaultView(): this;
    /**
     * Grants permission to retrieve information about the index in the AWS Region in which you call this operation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_GetIndex.html
     */
    toGetIndex(): this;
    /**
     * Grants permission to get managed view
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_GetManagedView.html
     */
    toGetManagedView(): this;
    /**
     * Grants permission to retrieve information about the specified view's resource policy
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-views-share.html
     */
    toGetResourcePolicy(): this;
    /**
     * Grants permission to retrieve information about the specified view
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_GetView.html
     */
    toGetView(): this;
    /**
     * Grants permission to list the indexes in all AWS Regions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_ListIndexes.html
     */
    toListIndexes(): this;
    /**
     * Grants permission to list the organization member account's indexes in all AWS Regions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_ListIndexesForMembers.html
     */
    toListIndexesForMembers(): this;
    /**
     * Grants permission to list managed views
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_ListManagedViews.html
     */
    toListManagedViews(): this;
    /**
     * Grants permission to retrieve a list of all resource types currently supported by Resource Explorer
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_ListSupportedResourceTypes.html
     */
    toListSupportedResourceTypes(): this;
    /**
     * Grants permission to list the tags that are attached to the specified resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to list the Amazon resource names (ARNs) of all of the views available in the AWS Region in which you call this operation
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_ListViews.html
     */
    toListViews(): this;
    /**
     * Grants permission to update the specified view's resource policy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-views-share.html
     */
    toPutResourcePolicy(): this;
    /**
     * Grants permission to search for resources and display details about all resources that match the specified criteria
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifOperation()
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_Search.html
     */
    toSearch(): this;
    /**
     * Grants permission to add one or more tag key and value pairs to the specified resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove one or more tag key and value pairs from the specified resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to change the type of the index from LOCAL to AGGREGATOR or back
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_UpdateIndexType.html
     */
    toUpdateIndexType(): this;
    /**
     * Grants permission to modify some of the details of a view
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_UpdateView.html
     */
    toUpdateView(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type view to the statement
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_View.html
     *
     * @param viewName - Identifier for the viewName.
     * @param viewUuid - Identifier for the viewUuid.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onView(viewName: string, viewUuid: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type index to the statement
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_Index.html
     *
     * @param indexUuid - Identifier for the indexUuid.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onIndex(indexUuid: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type managed-view to the statement
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/userguide/API_ManagedView.html
     *
     * @param managedViewName - Identifier for the managedViewName.
     * @param managedViewUuid - Identifier for the managedViewUuid.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onManagedView(managedViewName: string, managedViewUuid: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the tag keys that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateIndex()
     * - .toCreateView()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tag keyss attached to the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to resource types:
     * - view
     * - index
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tag keys that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateIndex()
     * - .toCreateView()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the actual operation that is being invoked, available values: Search, ListResources
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsresourceexplorer.html
     *
     * Applies to actions:
     * - .toSearch()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifOperation(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [resource-explorer-2](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsresourceexplorer.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
